package com.biz.crm.tpm.business.promotion.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.promotion.plan.local.entity.CurrentMonthSaleEntity;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthSaleVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 当月销售实体类(CurrentMonthSaleEntity)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-11-02 19:22:12
 */
public interface CurrentMonthSaleMapper extends BaseMapper<CurrentMonthSaleEntity> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param currentMonthSale 查询实体
   * @return 所有数据
  */
  public Page<CurrentMonthSaleVo> findByConditions(@Param("page") Page<CurrentMonthSaleVo> page, @Param("dto") CurrentMonthSaleDto currentMonthSale);

    BigDecimal getMinActivityBasePrice(@Param("dto") CurrentMonthSaleDto dto);

    /**
     * 按客户加产品汇总当月销售数据
     */
    List<CurrentMonthSaleVo> findCustomerProductMonthSaleSumList(@Param("dto") CurrentMonthSaleDto dto);

}

