package com.biz.crm.tpm.business.promotion.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.promotion.plan.local.entity.GeneralExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanCostProgressDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 费用申请实体类(GeneralExpenses)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-11-03 16:02:55
 */
public interface GeneralExpensesMapper extends BaseMapper<GeneralExpensesEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page            分页对象
     * @param generalExpenses 查询实体
     * @return 所有数据
     */
    Page<GeneralExpensesVo> findByConditions(@Param("page") Page<GeneralExpensesVo> page, @Param("dto") GeneralExpensesDto generalExpenses);


    /**
     * 分页查询所有数据
     *
     * @param page
     * @param promotionPlan
     * @return
     */
    Page<GeneralExpensesVo> findByConditionsGeneral(@Param("page") Page<GeneralExpensesVo> page, @Param("dto") PromotionPlanDto promotionPlan);

    /**
     * 查询总条数
     * @param dto 查询参数
     * @return Integer
     */
    Integer getGeneralExpenseTotal(@Param("dto") PromotionPlanDto dto);

    /**
     * 更新结案金额
     *
     * @param dtoList
     */
    void updateAuditAmount(@Param("dtoList") List<GeneralExpensesDto> dtoList);

    /**
     * 根据明细编码查询
     *
     * @param expensesCodeList
     */
    List<GeneralExpensesVo> findByExpensesCode(@Param("expensesCodeList") List<String> expensesCodeList);

    Page<GeneralExpensesVo> findForWithholding(Page<GeneralExpensesVo> page,
                                               @Param("processStatus") String processStatus,
                                               @Param("upAccountStatus") String upAccountStatus);

    /**
     * 获取合同金额
     * @param promotionPlanCode 促销规划编码
     * @return list
     */
    BigDecimal getContractAmount(@Param("promotionPlanCode") String promotionPlanCode);
    /**
     * 按明细编码查询数据
     * @param set
     * @return
     */
    List<GeneralExpensesVo> findDataByExpensesCodes(@Param("set")Set<String> set);

    /**
     * 费用进度监控条件查询
     *
     * @param page
     * @param dto
     * @return
     */
    Page<PromotionPlanCostProgressVo> findCostProgressByConditions(@Param("page") Page<PromotionPlanCostProgressVo> page, @Param("dto") PromotionPlanCostProgressDto dto);

    /**
     * 根据商务政策查询
     *
     * @param businessPolicyCodeList
     * @return
     */
    List<GeneralExpensesVo> findByBusinessPolicyCode(@Param("businessPolicyCodeList") List<String> businessPolicyCodeList);


    List<GeneralExpensesVo> findByExpensesCodes(@Param("set") Set<String> detailCodes);

    Page<GeneralExpensesVo> findCanAutoAuditItemPage(@Param("page") Page<GeneralExpensesVo> page,@Param("autoAuditParams") AutoAuditParamsDto autoAuditParams);

    void updateAutoAuditFlag(@Param("codeList") List<String> list,@Param("autoAudit") String autoAudit);
}

