package com.biz.crm.tpm.business.promotion.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.promotion.plan.local.entity.OtherExpensesEntity;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.OtherExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.OtherExpensesVo;
import org.apache.ibatis.annotations.Param;

/**
 * 其他费用实体类(OtherExpensesEntity)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-11-03 09:32:22
 */
public interface OtherExpensesMapper extends BaseMapper<OtherExpensesEntity> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param otherExpenses 查询实体
   * @return 所有数据
  */
  public Page<OtherExpensesVo> findByConditions(@Param("page") Page<OtherExpensesVo> page, @Param("dto") OtherExpensesDto otherExpenses);
}

