package com.biz.crm.tpm.business.promotion.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanEntity;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanForEventPrepaymentDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanForEventPrepaymentVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 促销规划实体类(PromotionPlanEntity)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-11-02 19:22:12
 */
public interface PromotionPlanMapper extends BaseMapper<PromotionPlanEntity> {

  /**
   * 分页查询所有数据
   *
   * @param page          分页对象
   * @param promotionPlan 查询实体
   * @return 所有数据
   */
  public Page<PromotionPlanVo> findByConditions(@Param("page") Page<PromotionPlanVo> page, @Param("dto") PromotionPlanDto promotionPlan);

  Integer getPromotionTotal(@Param("dto") PromotionPlanDto dto);

  /**
   * 活动预付电商选择活动明细
   *
   * @param page
   * @param dto
   * @return
   */
  Page<PromotionPlanForEventPrepaymentVo> findPromotionPlanPageListForEventPrepayment(@Param("page") Page<PromotionPlanForEventPrepaymentVo> page
          , @Param("dto") PromotionPlanForEventPrepaymentDto dto);

    List<PromotionPlanVo> findByDateConditions(@Param("dto") PromotionPlanDto promotionPlanDto);
}

