package com.biz.crm.tpm.business.promotion.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanResult;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanTableForm;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanTableFormDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanParamVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanTableFormExportVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanTableFormVo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 平台维度电商的促销规划一览汇总表mybatis访问层
 *
 * @author cyj
 * @since 2023-01-16 17:53:12
 */
public interface PromotionPlanTableFormMapper extends BaseMapper<PromotionPlanTableForm> {

    List<PromotionPlanTableFormVo> findByPlatformLevelByDepartmentId(@Param("salesDepartmentCode") String salesDepartmentCode
            ,@Param("levelCode") String levelCode
            ,@Param("tenantCode") String tenantCode
            ,@Param("delFlag") String delFlag
            ,@Param("yearAndMonth") String yearAndMonth);

    Page<PromotionPlanTableFormExportVo> findExportByConditions(Page<PromotionPlanTableFormDto> page, PromotionPlanTableFormDto dto);
}

