package com.biz.crm.tpm.business.promotion.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PurchaseSale;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PurchaseSaleVo;
import org.apache.ibatis.annotations.Param;

/**
 * 采销库存(PurchaseSale)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-11-26 14:58:22
 */
public interface PurchaseSaleMapper extends BaseMapper<PurchaseSale> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param purchaseSale 查询实体
   * @return 所有数据
  */
  public Page<PurchaseSaleVo> findByConditions(@Param("page") Page<PurchaseSaleVo> page, @Param("dto") PurchaseSaleDto purchaseSale);
}

