package com.biz.crm.tpm.business.promotion.plan.local.register;

import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionFeeApportionDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionFeeApportionService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author: yaoyongming
 * @date: 2023/9/9 15:05
 */
@Component
public class PromotionFeeApportionFormulaVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private PromotionFeeApportionService promotionFeeApportionService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "promotionFeeApportion";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "消费者费用分摊销售额";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerCode(),"客户编码不能为空");
        Validate.notBlank(calculateDto.getYearMonthLy(),"年月不能为空");
        Validate.notBlank(calculateDto.getActivityFormCode(),"活动形式编码不能为空");
        PromotionFeeApportionDto dto = new PromotionFeeApportionDto();
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setYearMonthLy(calculateDto.getYearMonthLy());
        dto.setActivityFormCode(calculateDto.getActivityFormCode());
        BigDecimal total = promotionFeeApportionService.findForFormulaVariable(dto);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), Objects.nonNull(total) ? total : BigDecimal.ZERO);
        return resultMap;
    }
}
