package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.ActualProfitLoss;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.ActualProfitLossMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-02 18:14:37
 */
@Component
public class ActualProfitLossRepository extends ServiceImpl<ActualProfitLossMapper, ActualProfitLoss> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据id逻辑删除
     *
     * @param ids
     */
    public void removeProfitLossByIds(List<String> ids) {
        this.lambdaUpdate().in(ActualProfitLoss::getId, ids).set(ActualProfitLoss::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }

    /**
     * 查询
     *
     * @param dto
     * @return
     */
    public List<ActualProfitLossVo> findProfitLoss(ActualProfitLossVo dto, List<String> month) {
        LambdaQueryChainWrapper<ActualProfitLoss> wrapper = this.lambdaQuery().in(ActualProfitLoss::getYearMonthly, month)
                .eq(ActualProfitLoss::getBusinessUnitName, PromotionPlanConstant.DS)
                .eq(ActualProfitLoss::getType, dto.getType())
                .eq(ActualProfitLoss::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        if (StringUtils.isNotBlank(dto.getCustomerCode())) {
            wrapper.eq(ActualProfitLoss::getCustomerCode, dto.getCustomerCode());
        } else if (StringUtils.isNotBlank(dto.getDepartmentCode())) {
            wrapper.eq(ActualProfitLoss::getDepartmentCode, dto.getDepartmentCode());
        }
        List<ActualProfitLoss> list = wrapper.list();
        return CollectionUtils.isNotEmpty(list) ? new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(list, ActualProfitLoss.class, ActualProfitLossVo.class, HashSet.class, ArrayList.class)) :
                new ArrayList<>();
    }

    public List<ActualProfitLossVo> findProfitLossByDto(ActualProfitLossVo dto) {
        return this.baseMapper.findProfitLossByDto(dto);
    }
}

