package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.BudgetProfitLoss;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.BudgetProfitLossMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-02 18:14:37
 */
@Component
public class BudgetProfitLossRepository extends ServiceImpl<BudgetProfitLossMapper, BudgetProfitLoss> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据id逻辑删除
     *
     * @param ids
     */
    public void removeProfitLossByIds(List<String> ids) {
        this.lambdaUpdate().in(BudgetProfitLoss::getId, ids).set(BudgetProfitLoss::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }

    /**
     * 查询
     *
     * @param dto
     * @return
     */
    public List<BudgetProfitLossVo> findProfitLoss(BudgetProfitLossVo dto, List<String> month) {
        LambdaQueryChainWrapper<BudgetProfitLoss> wrapper = this.lambdaQuery().in(BudgetProfitLoss::getYearMonthly, month)
                .eq(BudgetProfitLoss::getBusinessUnitName, PromotionPlanConstant.DS)
                .eq(BudgetProfitLoss::getType, dto.getType())
                .eq(BudgetProfitLoss::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        if (StringUtils.isNotBlank(dto.getCustomerCode())) {
            wrapper.eq(BudgetProfitLoss::getCustomerCode, dto.getCustomerCode());
        } else if (StringUtils.isNotBlank(dto.getDepartmentCode())) {
            wrapper.eq(BudgetProfitLoss::getDepartmentCode, dto.getDepartmentCode());
        }
        List<BudgetProfitLoss> list = wrapper.list();
        return CollectionUtils.isNotEmpty(list) ? new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(list, BudgetProfitLoss.class, BudgetProfitLossVo.class, HashSet.class, ArrayList.class)) :
                new ArrayList<>();
    }

    public List<BudgetProfitLossVo> findProfitLossByDto(BudgetProfitLossVo dto) {
        return this.baseMapper.findProfitLossByDto(dto);
    }
}

