package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.CurrentMonthDeliveryEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.CurrentMonthSaleEntity;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.CurrentMonthDeliveryMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthDeliveryDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthDeliveryVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthDeliveryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 当月送货实体类(CurrentMonthDeliveryEntity)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-02 18:14:37
 */
@Component
public class CurrentMonthDeliveryRepository extends ServiceImpl<CurrentMonthDeliveryMapper, CurrentMonthDeliveryEntity> {

    @Autowired(required = false)
    private CurrentMonthDeliveryMapper currentMonthDeliveryMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable             分页对象
     * @param currentMonthDelivery 实体对象
     * @return
     */
    public Page<CurrentMonthDeliveryVo> findByConditions(Pageable pageable, CurrentMonthDeliveryDto currentMonthDelivery) {
        Page<CurrentMonthDeliveryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<CurrentMonthDeliveryVo> pageList = this.currentMonthDeliveryMapper.findByConditions(page, currentMonthDelivery);
        return pageList;
    }

    /**
     * 根据PromotionPlanCode查询
     *
     * @param code
     * @return
     */
    public List<CurrentMonthDeliveryDto> findByPlanCode(String code) {
        List<CurrentMonthDeliveryEntity> itemList = this.lambdaQuery()
                .eq(CurrentMonthDeliveryEntity::getPromotionPlanCode, code)
                .eq(CurrentMonthDeliveryEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .orderByDesc(CurrentMonthDeliveryEntity::getCreateTime,CurrentMonthDeliveryEntity::getId)
                .list();
        return (List<CurrentMonthDeliveryDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, CurrentMonthDeliveryEntity.class, CurrentMonthDeliveryDto.class, HashSet.class, ArrayList.class);
    }

    /**
     * 根据PromotionPlanCode删除
     *
     * @param code
     */
    public void deleteByPromotionPlanCode(String code) {
        this.lambdaUpdate().eq(CurrentMonthDeliveryEntity::getPromotionPlanCode, code).remove();
    }

    /**
     * 根据PromotionPlanCodeList逻辑删除
     *
     * @param codeList
     */
    public void removeByPromotionPlanCodeList(List<String> codeList) {
        this.lambdaUpdate().in(CurrentMonthDeliveryEntity::getPromotionPlanCode, codeList).set(CurrentMonthDeliveryEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }
}

