package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.CurrentMonthSaleEntity;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.CurrentMonthSaleMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthSaleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 当月销售实体类(CurrentMonthSaleEntity)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-02 18:14:37
 */
@Component
public class CurrentMonthSaleRepository extends ServiceImpl<CurrentMonthSaleMapper, CurrentMonthSaleEntity> {

    @Autowired(required = false)
    private CurrentMonthSaleMapper currentMonthSaleMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param currentMonthSale 实体对象
     * @return
     */
    public Page<CurrentMonthSaleVo> findByConditions(Pageable pageable, CurrentMonthSaleDto currentMonthSale) {
        Page<CurrentMonthSaleVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<CurrentMonthSaleVo> pageList = this.currentMonthSaleMapper.findByConditions(page, currentMonthSale);
        return pageList;
    }

    /**
     * 根据PromotionPlanCode查询
     *
     * @param code
     * @return
     */
    public List<CurrentMonthSaleDto> findByPlanCode(String code) {
        List<CurrentMonthSaleEntity> itemList = this.lambdaQuery()
                .eq(CurrentMonthSaleEntity::getPromotionPlanCode, code)
                .eq(CurrentMonthSaleEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .orderByDesc(CurrentMonthSaleEntity::getCreateTime,CurrentMonthSaleEntity::getId)
                .list();
        return (List<CurrentMonthSaleDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, CurrentMonthSaleEntity.class, CurrentMonthSaleDto.class, HashSet.class, ArrayList.class);
    }

    /**
     * 根据PromotionPlanCode列表查询
     *
     * @param codeList
     * @return
     */
    public List<CurrentMonthSaleDto> findByPlanCodeList(List<String> codeList) {
        List<CurrentMonthSaleEntity> itemList = this.lambdaQuery().in(CurrentMonthSaleEntity::getPromotionPlanCode, codeList)
                .eq(CurrentMonthSaleEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        if (CollectionUtils.isEmpty(itemList)) {
            return new ArrayList<>();
        }
        return (List<CurrentMonthSaleDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, CurrentMonthSaleEntity.class, CurrentMonthSaleDto.class, HashSet.class, ArrayList.class);
    }

    /**
     * 根据PromotionPlanCode删除
     *
     * @param code
     */
    public void deleteByPromotionPlanCode(String code) {
        this.lambdaUpdate().eq(CurrentMonthSaleEntity::getPromotionPlanCode, code).remove();
    }

    /**
     * 根据PromotionPlanCodeList逻辑删除
     *
     * @param codeList
     */
    public void removeByPromotionPlanCodeList(List<String> codeList) {
        this.lambdaUpdate().in(CurrentMonthSaleEntity::getPromotionPlanCode, codeList).set(CurrentMonthSaleEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }

    public BigDecimal getMinActivityBasePrice(CurrentMonthSaleDto currentMonthSaleDto) {
        return currentMonthSaleMapper.getMinActivityBasePrice(currentMonthSaleDto);
    }

    public List<CurrentMonthSaleVo> findCustomerProductMonthSaleSumList(CurrentMonthSaleDto dto) {
        return currentMonthSaleMapper.findCustomerProductMonthSaleSumList(dto);
    }
}

