package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.OtherExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.OtherExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.OtherExpensesMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.OtherExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.OtherExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.OtherExpensesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 其他费用实体类(OtherExpensesEntity)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-03 09:32:22
 */
@Component
public class OtherExpensesRepository extends ServiceImpl<OtherExpensesMapper, OtherExpensesEntity> {

    @Autowired(required = false)
    private OtherExpensesMapper otherExpensesMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable      分页对象
     * @param otherExpenses 实体对象
     * @return
     */
    public Page<OtherExpensesVo> findByConditions(Pageable pageable, OtherExpensesDto otherExpenses) {
        Page<OtherExpensesVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<OtherExpensesVo> pageList = this.otherExpensesMapper.findByConditions(page, otherExpenses);
        return pageList;
    }

    /**
     * 根据PromotionPlanCode查询
     *
     * @param code
     * @return
     */
    public List<OtherExpensesDto> findByPlanCode(String code) {
        List<OtherExpensesEntity> itemList = this.lambdaQuery().eq(OtherExpensesEntity::getPromotionPlanCode, code)
                .eq(OtherExpensesEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        if (CollectionUtils.isEmpty(itemList)) {
            return new ArrayList<>();
        }
        return (List<OtherExpensesDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, OtherExpensesEntity.class, OtherExpensesDto.class, HashSet.class, ArrayList.class);
    }

    /**
     * 根据PromotionPlanCode删除
     *
     * @param code
     */
    public void deleteByPromotionPlanCode(String code) {
        this.lambdaUpdate().eq(OtherExpensesEntity::getPromotionPlanCode, code).remove();
    }

    /**
     * 根据PromotionPlanCodeList逻辑删除
     *
     * @param codeList
     */
    public void removeByPromotionPlanCodeList(List<String> codeList) {
        this.lambdaUpdate().in(OtherExpensesEntity::getPromotionPlanCode, codeList).set(OtherExpensesEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }
}

