package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionFeeApportion;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PromotionFeeApportionMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionFeeApportionDto;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;


@Component
public class PromotionFeeApportionRepository extends ServiceImpl<PromotionFeeApportionMapper, PromotionFeeApportion> {

    /**
     * 按唯一键查询
     *
     * @param keys
     * @return
     */
    public List<PromotionFeeApportion> findByUniqueKey (List<String> keys) {
        return lambdaQuery().in(PromotionFeeApportion::getUniqueKey, keys).list();
    }

    /**
     * 变量查询
     *
     * @return
     */
    public BigDecimal findForFormulaVariable(PromotionFeeApportionDto dto) {
        return baseMapper.findForFormulaVariable(dto);
    }
}

