package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanEntity;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PromotionPlanMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanForEventPrepaymentDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanForEventPrepaymentVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 促销规划实体类(PromotionPlanEntity)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-02 18:14:37
 */
@Component
public class PromotionPlanRepository extends ServiceImpl<PromotionPlanMapper, PromotionPlanEntity> {

    @Autowired(required = false)
    private PromotionPlanMapper promotionPlanMapper;

    /**
     * 分页查询数据
     *
     * @param pageable      分页对象
     * @param promotionPlan 实体对象
     * @return
     */
    public Page<PromotionPlanVo> findByConditions(Pageable pageable, PromotionPlanDto promotionPlan) {
        Page<PromotionPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<PromotionPlanVo> pageList = this.promotionPlanMapper.findByConditions(page, promotionPlan);
        return pageList;
    }

    /**
     * 活动预付电商选择活动明细
     * @param dto
     * @return
     */
    public Page<PromotionPlanForEventPrepaymentVo> findPromotionPlanPageListForEventPrepayment(Page<PromotionPlanForEventPrepaymentVo> page, PromotionPlanForEventPrepaymentDto dto){
        return this.promotionPlanMapper.findPromotionPlanPageListForEventPrepayment(page,dto);
    }

    /**
     * 按id批量逻辑删除
     *
     * @param ids
     */
    public void removePromotionPlanByIds(List<String> ids) {
        this.lambdaUpdate().in(PromotionPlanEntity::getId, ids).set(PromotionPlanEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }

    /**
     * 根据编码查询
     *
     * @param code
     * @return
     */
    public PromotionPlanEntity findByCode(String code) {
        return this.lambdaQuery().eq(PromotionPlanEntity::getPromotionPlanCode, code)
                .eq(PromotionPlanEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    /**
     * 根据编码查询
     *
     * @param codes
     * @return
     */
    public List<PromotionPlanEntity> findByCodes(List<String> codes) {
        return this.lambdaQuery().in(PromotionPlanEntity::getPromotionPlanCode, codes)
                .eq(PromotionPlanEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public List<PromotionPlanEntity> findByCodeList(List<String> codeList) {
        return this.lambdaQuery()
                .in(PromotionPlanEntity::getPromotionPlanCode, codeList)
                .eq(PromotionPlanEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public int getTotalPromotion(PromotionPlanDto promotionPlan){

        Integer promotionTotal = this.promotionPlanMapper.getPromotionTotal(promotionPlan);

        return promotionTotal == null ? 0 : promotionTotal;

    }

    public List<PromotionPlanVo> findByDateConditions(PromotionPlanDto promotionPlanDto) {
        return this.baseMapper.findByDateConditions(promotionPlanDto);
    }

    public void updateProcessStatusById(String id, String processStatus) {
        if (StringUtils.isEmpty(id)
                || StringUtils.isEmpty(processStatus)) {
            return;
        }
        this.lambdaUpdate()
                .eq(PromotionPlanEntity::getId, id)
                .set(PromotionPlanEntity::getProcessStatus, processStatus)
                .update();
    }
}

