package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanResult;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanTableForm;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PromotionPlanResultMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanParamVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanResultVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;


/**
 * 促销规划结果呈现表数据库访问层
 *
 * @author yaoyongming
 * @since 2023-01-16 17:56:37
 */
@Component
public class PromotionPlanResultRepository extends ServiceImpl<PromotionPlanResultMapper, PromotionPlanResult> {

    @Autowired(required = false)
    private PromotionPlanResultMapper promotionPlanResultMapper;

    /**
     * 按时间获取
     *
     * @param startDate
     * @return
     */
    public List<PromotionPlanResult> getByDate(Date startDate, String customerCode, String type) {
        return promotionPlanResultMapper.getByDate(startDate, customerCode, type);
    }

    /**
     * 按时间获取全量数据
     *
     * @param startDate
     * @return
     */
    public List<PromotionPlanParamVo> getAllByDate(String startDate,String type,String processStatus) {
        return promotionPlanResultMapper.getAllByDate(startDate,type,processStatus, BusinessUnitEnum.ONLINE.getCode());
    }

    /**
     * 按时间获取全量数据
     *
     * @param startDate
     * @return
     */
    public List<PromotionPlanParamVo> getAllByStartDateAndEnd(String startDate,String endDate,String type) {
        return promotionPlanResultMapper.getAllByStartDateAndEnd(startDate,endDate,type);
    }

    /**
     * 按时间获取全量数据月份汇总
     *
     * @param startDate
     * @return
     */
    public List<PromotionPlanResultVo> getAllByStartDateAndEndSum(String startDate,String endDate,String type, String processStatus) {
        return promotionPlanResultMapper.getAllByStartDateAndEndSum(startDate,endDate,type,processStatus);
    }

    /**
     * 按编码删除
     *
     * @param code
     */
    public void removeByCode(String code) {
        lambdaUpdate().eq(PromotionPlanResult::getPromotionPlanCode, code).remove();
    }
}

