package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanResult;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanTableForm;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PromotionPlanResultMapper;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PromotionPlanTableFormMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanTableFormDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanParamVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanTableFormExportVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanTableFormVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import liquibase.util.StringUtil;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;


/**
 * 平台维度电商的促销规划一览汇总表数据库访问层
 *
 * @author cyj
 * @since 2023-01-16 17:56:37
 */
@Component
public class PromotionPlanTableFormRepository extends ServiceImpl<PromotionPlanTableFormMapper, PromotionPlanTableForm> {

    public List<PromotionPlanTableForm> findByOnlyKey(List<String> onlyKeys, String tenantCode, String delFlag) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return Lists.newArrayList();
        } else {
            return this.lambdaQuery().in(PromotionPlanTableForm::getOnlyKey, onlyKeys).eq(PromotionPlanTableForm::getTenantCode, tenantCode).eq(PromotionPlanTableForm::getDelFlag, delFlag)
                    .select(PromotionPlanTableForm::getOnlyKey, PromotionPlanTableForm::getId).list();
        }
    }

    public List<PromotionPlanTableFormVo> findByPlatformLevelByDepartmentId(String salesDepartmentCode, String platform, String yearAndMonth) {
        if (StringUtil.isNotEmpty(salesDepartmentCode) && StringUtil.isNotEmpty(platform)) {
            return this.baseMapper.findByPlatformLevelByDepartmentId(salesDepartmentCode, platform, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL.getCode(), yearAndMonth);
        } else {
            return Lists.newArrayList();
        }
    }

    public Page<PromotionPlanTableFormExportVo> findExportByConditions(Page<PromotionPlanTableFormDto> page, PromotionPlanTableFormDto dto) {
        return this.baseMapper.findExportByConditions(page, dto);
    }
}

