package com.biz.crm.tpm.business.promotion.plan.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanWholeSummaryDetail;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PromotionPlanWholeSummaryDetailMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: yaoyongming
 * @date: 2023/9/11 16:06
 */
@Component
public class PromotionPlanWholeSummaryDetailRepository extends ServiceImpl<PromotionPlanWholeSummaryDetailMapper, PromotionPlanWholeSummaryDetail> {

    /**
     * 按年月匹配
     *
     * @param yearMonthLy
     * @return
     */
    public List<PromotionPlanWholeSummaryDetail> findByYearMonth(String yearMonthLy) {
        return lambdaQuery().eq(PromotionPlanWholeSummaryDetail::getYearMonthLy, yearMonthLy)
                .orderByAsc(PromotionPlanWholeSummaryDetail::getSortIndex).list();
    }

    /**
     * 按年月删除
     *
     * @param yearMonthLy
     * @return
     */
    public void deleteYearMonth(String yearMonthLy) {
        lambdaUpdate().eq(PromotionPlanWholeSummaryDetail::getYearMonthLy, yearMonthLy).remove();
    }
}
