package com.biz.crm.tpm.business.promotion.plan.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanWholeSummary;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PromotionPlanWholeSummaryMapper;
import org.springframework.stereotype.Component;

/**
 * @author: yaoyongming
 * @date: 2023/9/11 16:06
 */
@Component
public class PromotionPlanWholeSummaryRepository extends ServiceImpl<PromotionPlanWholeSummaryMapper, PromotionPlanWholeSummary> {

    /**
     * 按年月匹配
     *
     * @param yearMonthLy
     * @return
     */
    public PromotionPlanWholeSummary findByYearMonth(String yearMonthLy) {
        return lambdaQuery().eq(PromotionPlanWholeSummary::getYearMonthLy, yearMonthLy).one();
    }

    /**
     * 按年月删除
     *
     * @param yearMonthLy
     * @return
     */
    public void deleteYearMonth(String yearMonthLy) {
        lambdaUpdate().eq(PromotionPlanWholeSummary::getYearMonthLy, yearMonthLy).remove();
    }
}
