package com.biz.crm.tpm.business.promotion.plan.local.repository;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.GeneralExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PurchaseSale;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PurchaseSaleMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PurchaseSaleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 采销库存(PurchaseSale)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-26 14:58:22
 */
@Component
public class PurchaseSaleRepository extends ServiceImpl<PurchaseSaleMapper, PurchaseSale> {

    @Autowired(required = false)
    private PurchaseSaleMapper purchaseSaleMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable     分页对象
     * @param purchaseSale 实体对象
     * @return
     */
    public Page<PurchaseSaleVo> findByConditions(Pageable pageable, PurchaseSaleDto purchaseSale) {
        Page<PurchaseSaleVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<PurchaseSaleVo> pageList = this.purchaseSaleMapper.findByConditions(page, purchaseSale);
        return pageList;
    }

    /**
     * 根据PromotionPlanCode查询
     *
     * @param code
     * @return
     */
    public List<PurchaseSaleDto> findByPlanCode(String code) {
        List<PurchaseSale> itemList = this.lambdaQuery().eq(PurchaseSale::getPromotionPlanCode, code)
                .eq(PurchaseSale::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        return (List<PurchaseSaleDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, PurchaseSale.class, PurchaseSaleDto.class, HashSet.class, ArrayList.class);
    }

    /**
     * 根据PromotionPlanCode删除
     *
     * @param code
     */
    public void deleteByPromotionPlanCode(String code) {
        this.lambdaUpdate().eq(PurchaseSale::getPromotionPlanCode, code).remove();
    }

    /**
     * 根据PromotionPlanCodeList逻辑删除
     *
     * @param codeList
     */
    public void removeByPromotionPlanCodeList(List<String> codeList) {
        this.lambdaUpdate().in(PurchaseSale::getPromotionPlanCode, codeList).set(PurchaseSale::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }
}

