package com.biz.crm.tpm.business.promotion.plan.local.service;

import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionAllResult;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanParamVo;

import java.util.List;
import java.util.Map;

/**
 * 促销规划注册器
 * @author wanghaojia
 * @date 2023/6/14 15:11
 */
public abstract class PromotionResultRegister {

    /**
     * 变量编码
     * @return
     */
    public abstract String planResultCode();

    /**
     * 变量名
     * @return
     */
    public abstract String planResultName();


    /**
     * 构建数据
     */
    public abstract PromotionAllResult buildParam(String date, String projectCode, Map<String, List<ActualProfitLossVo>> actualProfitLossMap,
                                                         Map<String, List<BudgetProfitLossVo>> budgetProfitLossMap,
                                                         Map<String, List<PromotionPlanParamVo>> paramVoMap, List<ActualProfitLossVo> profitLoss,
                                                         List<BudgetProfitLossVo> profitLossByDto, String yearMonthDate,
                                                         List<PromotionPlanParamVo> paramVoList, String lastLastMonth, String lastMonth,String lastYearDate);

}
