package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.biz.crm.tpm.business.promotion.plan.local.entity.ActualProfitLoss;
import com.biz.crm.tpm.business.promotion.plan.local.repository.ActualProfitLossRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * 损益实际表服务实现类
 *
 * @author: yaoyongming
 * @date: 2023/2/14 10:38
 */
@Slf4j
@Service("actualProfitLossService")
public class ActualProfitLossServiceImpl implements ActualProfitLossService {

    @Autowired(required = false)
    private ActualProfitLossRepository actualProfitLossRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<ActualProfitLoss> list = this.actualProfitLossRepository.listByIds(idList);
        Validate.notEmpty(list, "根据提供的主键集合信息，未能获取到相应数据");
        this.actualProfitLossRepository.removeProfitLossByIds(idList);
    }

    /**
     * 批量新增
     *
     * @param list
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveBatch(List<ActualProfitLossVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Collection<ActualProfitLoss> profitLosses = nebulaToolkitService.copyCollectionByWhiteList(list, ActualProfitLossVo.class, ActualProfitLoss.class, LinkedHashSet.class, ArrayList.class);
        actualProfitLossRepository.saveBatch(profitLosses);
    }

    /**
     * 查询
     *
     * @param dto
     * @return
     */
    @Override
    public List<ActualProfitLossVo> findProfitLoss(ActualProfitLossVo dto, List<String> month) {
        return actualProfitLossRepository.findProfitLoss(dto, month);
    }

    @Override
    public List<ActualProfitLossVo> findProfitLossByDto(ActualProfitLossVo dto) {
        return actualProfitLossRepository.findProfitLossByDto(dto);
    }
}
