package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.biz.crm.tpm.business.promotion.plan.local.entity.BudgetProfitLoss;
import com.biz.crm.tpm.business.promotion.plan.local.repository.BudgetProfitLossRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * 损益实际表服务实现类
 *
 * @author: yaoyongming
 * @date: 2023/2/14 10:38
 */
@Slf4j
@Service("budgetProfitLossService")
public class BudgetProfitLossServiceImpl implements BudgetProfitLossService {

    @Autowired(required = false)
    private BudgetProfitLossRepository budgetProfitLossRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<BudgetProfitLoss> list = this.budgetProfitLossRepository.listByIds(idList);
        Validate.notEmpty(list, "根据提供的主键集合信息，未能获取到相应数据");
        this.budgetProfitLossRepository.removeProfitLossByIds(idList);
    }

    /**
     * 批量新增
     *
     * @param list
     */
    @Override
    public void saveBatch(List<BudgetProfitLossVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Collection<BudgetProfitLoss> profitLosses = nebulaToolkitService.copyCollectionByWhiteList(list, BudgetProfitLossVo.class, BudgetProfitLoss.class, LinkedHashSet.class, ArrayList.class);
        budgetProfitLossRepository.saveBatch(profitLosses);
    }

    /**
     * 查询
     *
     * @param dto
     * @return
     */
    @Override
    public List<BudgetProfitLossVo> findProfitLoss(BudgetProfitLossVo dto, List<String> month) {
        return budgetProfitLossRepository.findProfitLoss(dto, month);
    }

    @Override
    public List<BudgetProfitLossVo> findProfitLossByDto(BudgetProfitLossVo dto) {
        return budgetProfitLossRepository.findProfitLossByDto(dto);
    }
}
