package com.biz.crm.tpm.business.promotion.plan.local.service.internal;


import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.util.FieldInfo;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionAllResult;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionAllResultRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanResultRepository;
import com.biz.crm.tpm.business.promotion.plan.local.service.PromotionResultRegister;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanResultProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanResultProjectForEachEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionAllResultService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanParamVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.sun.org.apache.bcel.internal.generic.SWITCH;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 促销规划整体一览表(promotionAllResultService)表服务实现类
 *
 * @author cyj
 * @since 2022-11-03 09:32:22
 */
@Service("promotionAllResultService")
@Slf4j
public class PromotionAllResultServiceImpl implements PromotionAllResultService {

    @Autowired(required = false)
    private ActualProfitLossService actualProfitLossService;

    @Autowired(required = false)
    private BudgetProfitLossService budgetProfitLossService;

    @Autowired(required = false)
    private List<PromotionResultRegister> promotionResultRegisters;

    @Autowired(required = false)
    private PromotionPlanResultRepository promotionPlanResultRepository;

    @Autowired(required = false)
    private PromotionAllResultRepository promotionAllResultRepository;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void autoGetPromotionAllResult(String date) {
        if (!StringUtils.isEmpty(date)) {
            date = DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.MONTH,-1);
        //上个月
        String lastMonth = DateUtil.format(cal.getTime(), DateUtil.DEFAULT_YEAR_MONTH);
        //上上个月
        cal.add(Calendar.MONTH,-1);
        String lastLastMonth = DateUtil.format(cal.getTime(), DateUtil.DEFAULT_YEAR_MONTH);
        cal.set(Calendar.MONTH, 1);
        //今年一月
        String yearMonthDate = DateUtil.format(cal.getTime(), DateUtil.DEFAULT_YEAR_MONTH);
        cal.add(Calendar.YEAR, -1);
        //去年一月
        String lastYearMonthDate = DateUtil.format(cal.getTime(), DateUtil.DEFAULT_YEAR_MONTH);
        //去年同月
        String lastYearDate = DateUtil.format(DateUtil.formatAddYear(DateUtil.parseDate(date,DateUtil.DEFAULT_YEAR_MONTH),-1),DateUtil.DEFAULT_YEAR_MONTH);
        //损益表-实际
        ActualProfitLossVo dto = new ActualProfitLossVo();
        dto.setType(PromotionPlanConstant.PAPER);
        dto.setBeginDate(lastYearMonthDate);
        dto.setEndDate(date);
        List<ActualProfitLossVo> profitLoss = Optional.ofNullable(this.actualProfitLossService.findProfitLossByDto(dto)).orElse(new ArrayList<>());
        log.info("查询损益表-实际的数据量为:{}", profitLoss.size());
        Map<String, List<ActualProfitLossVo>> actualProfitLossMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(profitLoss)) {
            actualProfitLossMap = profitLoss.stream().filter(vo -> StringUtils.isNotEmpty(vo.getYearMonthly())).collect(Collectors.groupingBy(ActualProfitLossVo::getYearMonthly));
        }

        //损益表-预算
        BudgetProfitLossVo budgetDto = new BudgetProfitLossVo();
        budgetDto.setType(PromotionPlanConstant.PAPER);
        budgetDto.setBeginDate(lastYearMonthDate);
        budgetDto.setEndDate(date);
        List<BudgetProfitLossVo> profitLossByDto = Optional.ofNullable(this.budgetProfitLossService.findProfitLossByDto(budgetDto)).orElse(new ArrayList<>());
        log.info("查询损益表-预算的数据量为:{}", profitLoss.size());
        Map<String, List<BudgetProfitLossVo>> budgetProfitLossMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(profitLossByDto)) {
            budgetProfitLossMap = profitLossByDto.stream().filter(vo -> StringUtils.isNotEmpty(vo.getYearMonthly())).collect(Collectors.groupingBy(BudgetProfitLossVo::getYearMonthly));
        }

        //促销规划-当月销售
        List<PromotionPlanParamVo> paramVoList = Optional.ofNullable(this.promotionPlanResultRepository.getAllByStartDateAndEnd(date, yearMonthDate,PromotionPlanConstant.PAPER)).orElse(new ArrayList<>());
        Map<String, List<PromotionPlanParamVo>> paramVoMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(paramVoList)){
            paramVoMap = paramVoList.stream().filter(vo -> StringUtils.isNotEmpty(vo.getProjectCode())).collect(Collectors.groupingBy(vo ->StringUtils.join(vo.getProjectCode(),vo.getStartDate().substring(0,7))));
        }

        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        List<PromotionAllResult> promotionAllResultList = new ArrayList<>();
        for (PromotionResultRegister promotionResultRegister : promotionResultRegisters) {
            String projectCode = promotionResultRegister.planResultCode();
            String projectName = promotionResultRegister.planResultName();
            PromotionAllResult promotionAllResult = promotionResultRegister.buildParam(date,projectCode,actualProfitLossMap,budgetProfitLossMap,paramVoMap,profitLoss,profitLossByDto,yearMonthDate,paramVoList,lastLastMonth,lastMonth,lastYearDate);
            promotionAllResult.setTenantCode(tenantCode);
            promotionAllResult.setDelFlag(delFlag);
            promotionAllResult.setProjectName(projectName);
            promotionAllResultList.add(promotionAllResult);
        }
        this.promotionAllResultRepository.updateBatchById(promotionAllResultList);
    }
}

