package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionFeeApportion;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionFeeApportionRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionFeeApportionDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionFeeApportionService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 促销费用分摊服务实现
 *
 * @author: yaoyongming
 * @date: 2023/8/29 16:13
 */
@Service("promotionFeeApportionService")
@Slf4j
public class PromotionFeeApportionServiceImpl implements PromotionFeeApportionService {

    @Autowired(required = false)
    private PromotionFeeApportionRepository promotionFeeApportionRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 导入保存
     *
     * @param dtoList
     */
    @Override
    public void importSave(List<PromotionFeeApportionDto> dtoList) {
        List<String> uniqueKeys = dtoList.stream().map(e -> e.getUniqueKey()).collect(Collectors.toList());
        List<PromotionFeeApportion> byUniqueKey = promotionFeeApportionRepository.findByUniqueKey(uniqueKeys);
        Validate.isTrue(CollectionUtils.isEmpty(byUniqueKey), "系统中存在重复数据，请检查");
        Collection<PromotionFeeApportion> entities = nebulaToolkitService.copyCollectionByWhiteList(dtoList, PromotionFeeApportionDto.class, PromotionFeeApportion.class, LinkedHashSet.class, ArrayList.class);
        promotionFeeApportionRepository.saveBatch(entities);
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        promotionFeeApportionRepository.removeByIds(idList);
    }

    /**
     * 变量查询
     *
     * @param dto
     * @return
     */
    @Override
    public BigDecimal findForFormulaVariable(PromotionFeeApportionDto dto) {
        return promotionFeeApportionRepository.findForFormulaVariable(dto);
    }
}
