package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.promotion.plan.local.repository.CurrentMonthSaleRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.GeneralExpensesRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanCostProgressDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanCostProgressService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressVo;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: yaoyongming
 * @date: 2023/7/28 14:58
 */
@Slf4j
@Service("promotionPlanCostProgressService")
public class PromotionPlanCostProgressServiceImpl implements PromotionPlanCostProgressService {

    @Autowired(required = false)
    private GeneralExpensesRepository generalExpensesRepository;

    @Autowired(required = false)
    private CurrentMonthSaleRepository currentMonthSaleRepository;

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private Ce1MnjtSdkService ce1MnjtSdkService;

    /**
     * 费用进度监控条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<PromotionPlanCostProgressVo> findCostProgressByConditions(Pageable pageable, PromotionPlanCostProgressDto dto) {
        if (StringUtils.isBlank(dto.getYearMonthLy())) {
            dto.setYearMonthLy(DateUtil.format(new Date(), "yyyy-MM"));
        }
        
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        Page<PromotionPlanCostProgressVo> page = generalExpensesRepository.findCostProgressByConditions(pageable, dto);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return page;
        }

        List<PromotionPlanCostProgressVo> records = page.getRecords();
        Set<String> ppCodeSet = new HashSet<>();
        Set<String> detailCodeSet = new HashSet<>();
        Set<String> customerCodeSet = new HashSet<>();
        for (PromotionPlanCostProgressVo vo : records) {
            ppCodeSet.add(vo.getPromotionPlanCode());
            detailCodeSet.add(vo.getExpensesCode());
            customerCodeSet.add(vo.getCustomerCode());
        }

        //查询客户数据
        Map<String, CustomerVo> customerVoMap;
        Map<String, CustomerVo> customerVirtualVoMap = new HashMap<>();
        List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodeSet));
        if (!CollectionUtils.isEmpty(customerVos)) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            Iterator<String> it = customerVoMap.keySet().iterator();
            while(it.hasNext()) {
                String k = it.next();
                CustomerVo customerVo = customerVoMap.get(k);
                if (BooleanEnum.TRUE.getCapital().equals(customerVo.getIsVirtually())) {
                    customerVirtualVoMap.put(k, customerVo);
                    it.remove();
                }
            }
        } else {
            throw new IllegalArgumentException("未找到任意客户，请检查！");
        }

        //查询日销售数据，虚拟与非虚拟客户
        Pageable pageableSales = PageRequest.of(1, 20000);
        String startDate = dto.getYearMonthLy().replace("-", "") + "01";
        String endDate = DateUtil.getFinalDayOfMonth(dto.getYearMonthLy()).replace("-", "");
        Map<String, String> virtualStrMap = new HashMap<>();
        Map<String, BigDecimal> salesAmountMap = new HashMap<>();
        if (!customerVirtualVoMap.isEmpty()) {
            Set<String> dtoStrSet = new HashSet<>();
            customerVirtualVoMap.forEach((k, v) -> {
                String str = v.getBusinessFormatCode() +
                        v.getSalesInstitutionErpCode() +
                        v.getCustomerChannelCode();
                dtoStrSet.add(str);
                virtualStrMap.put(k, str);
            });
            Ce1MnjtFullDto ce1MnjtFullDto = new Ce1MnjtFullDto();
            ce1MnjtFullDto.setCustomerVirtualCodeList(new ArrayList<>(dtoStrSet));
            ce1MnjtFullDto.setPostDateStart(startDate);
            ce1MnjtFullDto.setPostDateEnd(endDate);
            Page<Ce1MnjtFullVo2> salesVoPage = ce1MnjtSdkService.findSalesByConditions(pageableSales, ce1MnjtFullDto);
            if (!CollectionUtils.isEmpty(salesVoPage.getRecords())) {
                List<Ce1MnjtFullVo2> salesVoList = salesVoPage.getRecords();
                Map<String, List<String>> stringListMap = salesVoList.stream().collect(Collectors.groupingBy(e -> e.getProductTeamCode() + e.getSaleOrgCode() + e.getDistributionChannelCode(), Collectors.mapping(e -> e.getSalesTaxAmount(), Collectors.toList())));
                stringListMap.forEach((k, v) -> salesAmountMap.put(k, v.stream().map(e ->  new BigDecimal(e))
                        .reduce(BigDecimal.ZERO, BigDecimal::add)));
            }
        }
        Map<String, String> strMap = new HashMap<>();
        if (!customerVoMap.isEmpty()) {
            Set<String> dtoStrSet = new HashSet<>();
            customerVoMap.forEach((k, v) -> {
                String str = v.getBusinessFormatCode() +
                        v.getSalesInstitutionErpCode() +
                        v.getCustomerChannelCode() +
                        v.getErpCode();
                dtoStrSet.add(str);
                strMap.put(k, str);
            });
            Ce1MnjtFullDto ce1MnjtFullDto = new Ce1MnjtFullDto();
            ce1MnjtFullDto.setCustomerUniqueCodeList(new ArrayList<>(dtoStrSet));
            ce1MnjtFullDto.setPostDateStart(startDate);
            ce1MnjtFullDto.setPostDateEnd(endDate);
            Page<Ce1MnjtFullVo2> salesVoPage = ce1MnjtSdkService.findSalesByConditions(pageableSales, ce1MnjtFullDto);
            if (!CollectionUtils.isEmpty(salesVoPage.getRecords())) {
                List<Ce1MnjtFullVo2> salesVoList = salesVoPage.getRecords();
                Map<String, List<String>> stringListMap = salesVoList.stream().collect(Collectors.groupingBy(e -> e.getProductTeamCode() + e.getSaleOrgCode() + e.getDistributionChannelCode() + e.getCustomerCode(), Collectors.mapping(e -> e.getSalesTaxAmount(), Collectors.toList())));
                stringListMap.forEach((k, v) -> salesAmountMap.put(k, v.stream().map(e ->  new BigDecimal(e))
                        .reduce(BigDecimal.ZERO, BigDecimal::add)));
            }
        }

        //月预计销售额（元）	促销规划编码对应的促销规划的当月销售中，预计折后销售额求和汇总。
        Map<String, BigDecimal> cmsAmountMap = new HashMap<>();
        List<CurrentMonthSaleDto> cmsDtoList = currentMonthSaleRepository.findByPlanCodeList(new ArrayList<>(ppCodeSet));
        if (!CollectionUtils.isEmpty(cmsDtoList)) {
            Map<String, List<CurrentMonthSaleDto>> cmsMap = cmsDtoList.stream().collect(Collectors.groupingBy(e -> e.getPromotionPlanCode()));
            for (String k : cmsMap.keySet()) {
                List<CurrentMonthSaleDto> currentMonthSaleDtos = cmsMap.get(k);
                cmsAmountMap.put(k, currentMonthSaleDtos.stream().map(e -> Optional.ofNullable(e.getEstimatedAmountAfter()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        //费用实际消耗   细案预测表中查找明细对应的预核销金额
        List<DetailedForecastVo> dfVoList = detailedForecastService.findByActivityDetailItemCode(detailCodeSet);
        Map<String, DetailedForecastVo> dfVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(dfVoList)) {
            dfVoMap = dfVoList.stream().collect(Collectors.toMap(e -> e.getActivityDetailItemCode(), Function.identity()));
        }

        for (PromotionPlanCostProgressVo item : page.getRecords()) {
            //月预计销售额（元）	促销规划编码对应的促销规划的当月销售中，预计折后销售额求和汇总。
            //规划费率	费用申请金额（元）/月预计销售额（元）
            //实际费率	费用实际消耗（元）/实际销售额（元）
            //销售进度	实际销售额/月预计销售额
            //费用消耗进度	费用实际消耗（元）/费用申请金额（元）

            BigDecimal monthSaleAmount = BigDecimal.ZERO;
            if (cmsAmountMap.containsKey(item.getPromotionPlanCode())) {
                monthSaleAmount = cmsAmountMap.get(item.getPromotionPlanCode());
            }
            item.setMonthSaleAmount(monthSaleAmount);
            if (BigDecimal.ZERO.compareTo(monthSaleAmount) != 0) {
                item.setPlanRate(item.getApplyAmount().divide(monthSaleAmount, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (virtualStrMap.containsKey(item.getCustomerCode())) {
                item.setChannelCode(customerVirtualVoMap.get(item.getCustomerCode()).getCustomerChannelCode());
                String str = virtualStrMap.get(item.getCustomerCode());
                if (salesAmountMap.containsKey(str)) {
                    item.setActualSaleAmount(salesAmountMap.get(str));
                }
            } else if (strMap.containsKey(item.getCustomerCode())) {
                item.setChannelCode(customerVoMap.get(item.getCustomerCode()).getCustomerChannelCode());
                String str = strMap.get(item.getCustomerCode());
                if (salesAmountMap.containsKey(str)) {
                    item.setActualSaleAmount(salesAmountMap.get(str));
                }
            }
            if (dfVoMap.containsKey(item.getExpensesCode())) {
                BigDecimal actualCost = dfVoMap.get(item.getExpensesCode()).getEstimatedWriteOffAmount();
                item.setActualCost(actualCost != null ? actualCost : BigDecimal.ZERO);
                item.setCostProgress(item.getActualCost().divide(item.getApplyAmount(), 2, BigDecimal.ROUND_HALF_UP));
            }
            if (item.getActualSaleAmount() != null) {
                if (item.getActualSaleAmount().compareTo(BigDecimal.ZERO) != 0) {
                    item.setActualRate(item.getActualCost().divide(item.getActualSaleAmount(), 2, BigDecimal.ROUND_HALF_UP));
                }
                if (item.getMonthSaleAmount().compareTo(BigDecimal.ZERO) != 0) {
                    item.setSaleAmountProgress(item.getActualSaleAmount().divide(item.getMonthSaleAmount(), 2, BigDecimal.ROUND_HALF_UP));
                }
            }
        }
        return page;
    }
}
