package com.biz.crm.tpm.business.promotion.plan.local.service.internal;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.constant.ActivityApplyRulesConstant;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.enums.PromotionPlanActFormEnum;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeFormDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeRelationDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyLockService;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import com.biz.crm.tpm.business.freight.charge.maintenance.sdk.dto.TpmFreightChargeMaintenanceDto;
import com.biz.crm.tpm.business.freight.charge.maintenance.sdk.service.TpmFreightChargeMaintenanceService;
import com.biz.crm.tpm.business.freight.charge.maintenance.sdk.vo.TpmFreightChargeMaintenanceVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.promotion.plan.local.entity.*;
import com.biz.crm.tpm.business.promotion.plan.local.repository.*;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.*;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.log.PromotionPlanLogEventDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanResultProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.event.log.PromotionPlanLogEventListener;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.*;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.*;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 促销规划实体类(PromotionPlanEntity)表服务实现类
 *
 * @author yaoyongming
 * @since 2022-11-02 18:14:37
 */
@Slf4j
@Service("promotionPlanService")
public class PromotionPlanServiceImpl implements PromotionPlanService {

    @Autowired(required = false)
    private PromotionPlanRepository promotionPlanRepository;

    @Autowired(required = false)
    private GeneralExpensesRepository generalExpensesRepository;

    @Autowired(required = false)
    private CurrentMonthDeliveryRepository currentMonthDeliveryRepository;

    @Autowired(required = false)
    private CurrentMonthSaleRepository currentMonthSaleRepository;

    @Autowired(required = false)
    private PurchaseSaleRepository purchaseSaleRepository;

    @Autowired(required = false)
    private OtherExpensesRepository otherExpensesRepository;

    @Autowired(required = false)
    private GeneralExpensesService generalExpensesService;

    @Autowired(required = false)
    private CurrentMonthDeliveryService currentMonthDeliveryService;

    @Autowired(required = false)
    private CurrentMonthSaleService currentMonthSaleService;

    @Autowired(required = false)
    private OtherExpensesService otherExpensesService;

    @Autowired(required = false)
    private PurchaseSaleService purchaseSaleService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private BusinessPolicyService businessPolicyService;

    @Autowired(required = false)
    private BusinessPolicyLockService businessPolicyLockService;

    @Autowired(required = false)
    private PromotionPlanResultRepository promotionPlanResultRepository;

    @Autowired(required = false)
    private ActualProfitLossService actualProfitLossService;

    @Autowired(required = false)
    private BudgetProfitLossService budgetProfitLossService;

    @Autowired(required = false)
    private TpmFreightChargeMaintenanceService tpmFreightChargeMaintenanceService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 分页查询数据
     *
     * @param pageable      分页对象
     * @param promotionPlan 实体对象
     * @return
     */
    @Override
    public Page<PromotionPlanVo> findByConditions(Pageable pageable, PromotionPlanDto promotionPlan) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(promotionPlan)) {
            promotionPlan = new PromotionPlanDto();
        }
        return this.promotionPlanRepository.findByConditions(pageable, promotionPlan);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param code 主键
     * @return 单条数据
     */
    @Override
    public PromotionPlanVo findById(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        PromotionPlanEntity plan = this.promotionPlanRepository.findByCode(code);
        Validate.notNull(plan, "未找到查询的数据");

        PromotionPlanVo planVo = nebulaToolkitService.copyObjectByWhiteList(plan, PromotionPlanVo.class, HashSet.class, ArrayList.class);

//        List<GeneralExpensesEntity> generalEntities = generalExpensesRepository.findByPlanCode(plan.getPromotionPlanCode());
//        List<CurrentMonthDeliveryEntity> deliveryEntities = currentMonthDeliveryRepository.findByPlanCode(plan.getPromotionPlanCode());
//        List<CurrentMonthSaleEntity> saleEntities = currentMonthSaleRepository.findByPlanCode(plan.getPromotionPlanCode());
//        List<OtherExpensesEntity> otherEntities = otherExpensesRepository.findByPlanCode(plan.getPromotionPlanCode());
//
//        planVo.setGeneralExpensesVos(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(generalEntities, GeneralExpensesEntity.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class)));
//        planVo.setCurrentMonthDeliveryVos(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(deliveryEntities, CurrentMonthDeliveryEntity.class, CurrentMonthDeliveryVo.class, HashSet.class, ArrayList.class)));
//        planVo.setCurrentMonthSaleVos(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(saleEntities, CurrentMonthSaleEntity.class, CurrentMonthSaleVo.class, HashSet.class, ArrayList.class)));
//        planVo.setOtherExpensesVos(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(otherEntities, OtherExpensesEntity.class, OtherExpensesVo.class, HashSet.class, ArrayList.class)));

        return planVo;
    }

    /**
     * 通过编码查询单条数据
     *
     * @param promotionPlanCode 编码
     * @return 单条数据
     */
    @Override
    public PromotionPlanVo findByCode(String promotionPlanCode) {
        if (StringUtils.isBlank(promotionPlanCode)) {
            return null;
        }
        PromotionPlanEntity plan = this.promotionPlanRepository.findByCode(promotionPlanCode);
        Validate.notNull(plan, "未找到查询的数据");

        PromotionPlanVo planVo = nebulaToolkitService.copyObjectByWhiteList(plan, PromotionPlanVo.class, HashSet.class, ArrayList.class);
        List<GeneralExpensesEntity> itemList = generalExpensesRepository.lambdaQuery().eq(GeneralExpensesEntity::getPromotionPlanCode, promotionPlanCode)
                .eq(GeneralExpensesEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        if (!CollectionUtils.isEmpty(itemList)) {
            Collection<GeneralExpensesVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(itemList, GeneralExpensesEntity.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class);
            planVo.setGeneralExpensesVos((List<GeneralExpensesVo>) vos);
        }

        List<CurrentMonthDeliveryEntity> itemList2 = currentMonthDeliveryRepository.lambdaQuery().eq(CurrentMonthDeliveryEntity::getPromotionPlanCode, promotionPlanCode)
                .eq(CurrentMonthDeliveryEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        if (!CollectionUtils.isEmpty(itemList2)) {
            Collection<CurrentMonthDeliveryVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(itemList2, CurrentMonthDeliveryEntity.class, CurrentMonthDeliveryVo.class, HashSet.class, ArrayList.class);
            planVo.setCurrentMonthDeliveryVos((List<CurrentMonthDeliveryVo>) vos);
        }

        List<CurrentMonthSaleEntity> itemList3 = currentMonthSaleRepository.lambdaQuery().eq(CurrentMonthSaleEntity::getPromotionPlanCode, promotionPlanCode)
                .eq(CurrentMonthSaleEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        if (!CollectionUtils.isEmpty(itemList3)) {
            Collection<CurrentMonthSaleVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(itemList3, CurrentMonthSaleEntity.class, CurrentMonthSaleVo.class, HashSet.class, ArrayList.class);
            planVo.setCurrentMonthSaleVos((List<CurrentMonthSaleVo>) vos);
        }

        List<OtherExpensesEntity> itemList4 = otherExpensesRepository.lambdaQuery().eq(OtherExpensesEntity::getPromotionPlanCode, promotionPlanCode)
                .eq(OtherExpensesEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        if (!CollectionUtils.isEmpty(itemList4)) {
            Collection<OtherExpensesVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(itemList4, OtherExpensesEntity.class, OtherExpensesVo.class, HashSet.class, ArrayList.class);
            planVo.setOtherExpensesVos((List<OtherExpensesVo>) vos);
        }

        return planVo;
    }

    @Override
    public List<PromotionPlanVo> findByCodes(List<String> promotionPlanCodes) {
        if (CollectionUtils.isEmpty(promotionPlanCodes)) {
            return null;
        }
        List<PromotionPlanEntity> plans = this.promotionPlanRepository.findByCodes(promotionPlanCodes);
        Validate.notEmpty(plans, "未找到查询的数据");
        List<PromotionPlanVo> planVos = (List<PromotionPlanVo>) nebulaToolkitService.copyCollectionByWhiteList(plans, PromotionPlanEntity.class, PromotionPlanVo.class, HashSet.class, ArrayList.class);
        List<GeneralExpensesEntity> itemList = generalExpensesRepository.lambdaQuery().in(GeneralExpensesEntity::getPromotionPlanCode, promotionPlanCodes)
                .eq(GeneralExpensesEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        Map<String, List<GeneralExpensesVo>> generalExpensesVosMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(itemList)) {
            Collection<GeneralExpensesVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(itemList, GeneralExpensesEntity.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class);
            generalExpensesVosMap = vos.stream().collect(Collectors.groupingBy(GeneralExpensesVo::getPromotionPlanCode));
        }

        List<CurrentMonthDeliveryEntity> itemList2 = currentMonthDeliveryRepository.lambdaQuery().in(CurrentMonthDeliveryEntity::getPromotionPlanCode, promotionPlanCodes)
                .eq(CurrentMonthDeliveryEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        Map<String, List<CurrentMonthDeliveryVo>> deliveryVosMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(itemList2)) {
            Collection<CurrentMonthDeliveryVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(itemList2, CurrentMonthDeliveryEntity.class, CurrentMonthDeliveryVo.class, HashSet.class, ArrayList.class);
            deliveryVosMap = vos.stream().collect(Collectors.groupingBy(CurrentMonthDeliveryVo::getPromotionPlanCode));
        }

        List<CurrentMonthSaleEntity> itemList3 = currentMonthSaleRepository.lambdaQuery().in(CurrentMonthSaleEntity::getPromotionPlanCode, promotionPlanCodes)
                .eq(CurrentMonthSaleEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        Map<String, List<CurrentMonthSaleVo>> saleVosMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(itemList3)) {
            Collection<CurrentMonthSaleVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(itemList3, CurrentMonthSaleEntity.class, CurrentMonthSaleVo.class, HashSet.class, ArrayList.class);
            saleVosMap = vos.stream().collect(Collectors.groupingBy(CurrentMonthSaleVo::getPromotionPlanCode));
        }

        List<OtherExpensesEntity> itemList4 = otherExpensesRepository.lambdaQuery().in(OtherExpensesEntity::getPromotionPlanCode, promotionPlanCodes)
                .eq(OtherExpensesEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        Map<String, List<OtherExpensesVo>> otherExpensesVosMap = new HashMap<>();

        if (!CollectionUtils.isEmpty(itemList4)) {
            Collection<OtherExpensesVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(itemList4, OtherExpensesEntity.class, OtherExpensesVo.class, HashSet.class, ArrayList.class);
            otherExpensesVosMap = vos.stream().collect(Collectors.groupingBy(OtherExpensesVo::getPromotionPlanCode));
        }
        for (PromotionPlanVo e : planVos) {
            e.setGeneralExpensesVos(generalExpensesVosMap.get(e.getPromotionPlanCode()));
            e.setCurrentMonthDeliveryVos(deliveryVosMap.get(e.getPromotionPlanCode()));
            e.setCurrentMonthSaleVos(saleVosMap.get(e.getPromotionPlanCode()));
            e.setOtherExpensesVos(otherExpensesVosMap.get(e.getPromotionPlanCode()));
        }
        return planVos;
    }

    /**
     * 新增数据
     *
     * @param promotionPlan    dto对象
     * @param cacheKeySale     当月销售缓存键
     * @param cacheKeyDelivery 当月送货缓存键
     * @param cacheKeyPurchase 采销库存缓存键
     * @param cacheKeyGeneral  费用申请缓存键
     * @param cacheKeyOther    其他费用缓存键
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel = createValidate(promotionPlan);

        createHandle(businessModel, promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase,
                cacheKeyGeneral, cacheKeyOther, false);

        //数据保存完清理掉缓存
        clearCacheList(businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
    }

    /**
     * 新增处理
     *
     * @param businessModel
     * @param promotionPlan
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyPurchase
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     * @param isSubmit         是否提交
     */
    public void createHandle(String businessModel, PromotionPlanDto promotionPlan, String cacheKeySale,
                             String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral,
                             String cacheKeyOther, boolean isSubmit) {
        promotionPlan.setId(null);

        //获取明细缓存
        getCacheList(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase,
                cacheKeyGeneral, cacheKeyOther, isSubmit);

        if (isSubmit) {
            //明细校验
            detailsValidate(promotionPlan, businessModel);
            //重新计算损益
            //计算其他
            if (!CollectionUtils.isEmpty(promotionPlan.getCurrentMonthSaleDtos())) {
                monthSaleFee(promotionPlan);
            }
            if (!CollectionUtils.isEmpty(promotionPlan.getCurrentMonthDeliveryDtos())) {
                monthDeliveryFee(promotionPlan);
            }
        }

        // redis生成料编码code
        List<String> codeList = this.generateCodeService.generateCode(PromotionPlanConstant.PREFIX_CODE + DateFormatUtils.format(new Date(), "yyyyMMdd"), 1, 5, 2, TimeUnit.DAYS);

        store(promotionPlan, businessModel, codeList.get(0));
        PromotionPlanEntity promotionPlanEntity = nebulaToolkitService.copyObjectByWhiteList(promotionPlan, PromotionPlanEntity.class, HashSet.class, ArrayList.class);
        promotionPlanEntity.setPromotionPlanCode(codeList.get(0));
        promotionPlanEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        promotionPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        promotionPlanEntity.setTenantCode(TenantUtils.getTenantCode());
        promotionPlanEntity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
        //当前用户信息
        FacturerUserDetails loginDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
        promotionPlanEntity.setOrgCode(loginDetails.getOrgCode());
        promotionPlanEntity.setOrgName(loginDetails.getOrgName());
        promotionPlanEntity.setPositionCode(loginDetails.getPostCode());
        promotionPlanEntity.setPositionName(loginDetails.getPostName());
        this.promotionPlanRepository.saveOrUpdate(promotionPlanEntity);
        promotionPlan.setId(promotionPlanEntity.getId());
        promotionPlan.setPromotionPlanCode(codeList.get(0));

        //清除并新增促销规划结果呈现表
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult1 = getStoreResult(promotionPlan, promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPurchaseSaleDtos(),
                promotionPlan.getGeneralExpensesDtos(), promotionPlan.getOtherExpensesDtos(), businessModel, PromotionPlanConstant.FRONT);
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult2 = getStoreResult(promotionPlan, promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPurchaseSaleDtos(),
                promotionPlan.getGeneralExpensesDtos(), promotionPlan.getOtherExpensesDtos(), businessModel, PromotionPlanConstant.PAPER);
        List<PromotionPlanResultVo> cahchResult = new ArrayList<>();
        cahchResult.addAll(cahchResult1.values());
        cahchResult.addAll(cahchResult2.values());
        promotionPlanResultRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(cahchResult, PromotionPlanResultVo.class, PromotionPlanResult.class, HashSet.class, ArrayList.class));

        //新增业务日志
        PromotionPlanLogEventDto logEventDto = new PromotionPlanLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(promotionPlan);
        SerializableBiConsumer<PromotionPlanLogEventListener, PromotionPlanLogEventDto> onCreate =
                PromotionPlanLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, PromotionPlanLogEventListener.class, onCreate);
    }

    /**
     * 修改新据
     *
     * @param promotionPlan    dto对象
     * @param cacheKeySale     当月销售缓存键
     * @param cacheKeyDelivery 当月送货缓存键
     * @param cacheKeyPurchase 采销库存缓存键
     * @param cacheKeyGeneral  费用申请缓存键
     * @param cacheKeyOther    其他费用缓存键
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel = updateValidate(promotionPlan);

        updateHandle(businessModel, promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase,
                cacheKeyGeneral, cacheKeyOther, false);

        //数据保存完清理掉缓存
        clearCacheList(businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
    }

    public void updateHandle(String businessModel, PromotionPlanDto promotionPlan, String cacheKeySale,
                             String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral,
                             String cacheKeyOther, boolean isSubmit) {
        PromotionPlanEntity promotionPlanEntityOld = promotionPlanRepository.getById(promotionPlan.getId());

        if (!ProcessStatusEnum.PREPARE.getKey().equals(promotionPlanEntityOld.getProcessStatus()) &&
                !ProcessStatusEnum.REJECT.getKey().equals(promotionPlanEntityOld.getProcessStatus()) &&
                !ProcessStatusEnum.RECOVER.getKey().equals(promotionPlanEntityOld.getProcessStatus())) {
            throw new RuntimeException("只能编辑待提交、驳回、追回状态的数据！");
        }

        //获取明细缓存
        getCacheList2(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
        Validate.notNull(promotionPlanEntityOld, "未找到修改的数据");

        //明细校验
        if (isSubmit) {
            detailsValidate(promotionPlan, businessModel);
        }

        //移除旧数据
        generalExpensesRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        currentMonthSaleRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        currentMonthDeliveryRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        purchaseSaleRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        otherExpensesRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());

        if (isSubmit) {
            //重新计算损益
            //计算其他
            if (!CollectionUtils.isEmpty(promotionPlan.getCurrentMonthSaleDtos())) {
                monthSaleFee(promotionPlan);
            }
            if (!CollectionUtils.isEmpty(promotionPlan.getCurrentMonthDeliveryDtos())) {
                monthDeliveryFee(promotionPlan);
            }
        }

        store(promotionPlan, businessModel, promotionPlanEntityOld.getPromotionPlanCode());

        PromotionPlanEntity promotionPlanEntity = nebulaToolkitService.copyObjectByWhiteList(promotionPlan, PromotionPlanEntity.class, HashSet.class, ArrayList.class);
        promotionPlanEntity.setPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        promotionPlanEntity.setTenantCode(TenantUtils.getTenantCode());

        promotionPlanRepository.saveOrUpdate(promotionPlanEntity);

        promotionPlan.setPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());

        //清除并新增促销规划结果呈现表
        promotionPlanResultRepository.removeByCode(promotionPlan.getPromotionPlanCode());
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult1 = getStoreResult(promotionPlan, promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPurchaseSaleDtos(),
                promotionPlan.getGeneralExpensesDtos(), promotionPlan.getOtherExpensesDtos(), businessModel, PromotionPlanConstant.FRONT);
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult2 = getStoreResult(promotionPlan, promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPurchaseSaleDtos(),
                promotionPlan.getGeneralExpensesDtos(), promotionPlan.getOtherExpensesDtos(), businessModel, PromotionPlanConstant.PAPER);
        List<PromotionPlanResultVo> cahchResult = new ArrayList<>();
        cahchResult.addAll(cahchResult1.values());
        cahchResult.addAll(cahchResult2.values());
        promotionPlanResultRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(cahchResult, PromotionPlanResultVo.class, PromotionPlanResult.class, HashSet.class, ArrayList.class));

        //编辑业务日志
        PromotionPlanLogEventDto logEventDto = new PromotionPlanLogEventDto();
        logEventDto.setOriginal(this.nebulaToolkitService.copyObjectByWhiteList(promotionPlanEntityOld, PromotionPlanDto.class, LinkedHashSet.class, ArrayList.class));
        logEventDto.setNewest(promotionPlan);
        SerializableBiConsumer<PromotionPlanLogEventListener, PromotionPlanLogEventDto> onUpdate =
                PromotionPlanLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, PromotionPlanLogEventListener.class, onUpdate);
    }

    /**
     * 获取缓存保存到dto
     *
     * @param promotionPlan
     * @param businessModel
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyPurchase
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     * @param isSubmit         是否提交
     */
    private void getCacheList(PromotionPlanDto promotionPlan, String businessModel, String cacheKeySale,
                              String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral,
                              String cacheKeyOther, boolean isSubmit) {
        if (isSubmit) {
            Validate.notBlank(cacheKeyGeneral, "费用申请缓存键不能为空");
        }
        promotionPlan.setGeneralExpensesDtos(generalExpensesService.findCacheList(cacheKeyGeneral));
        if (PromotionPlanConstant.CX.equals(businessModel)) {
            if (StringUtils.isNotBlank(cacheKeyDelivery)) {
                promotionPlan.setCurrentMonthDeliveryDtos(currentMonthDeliveryService.findCacheList(cacheKeyDelivery));
            }
            if (StringUtils.isNotBlank(cacheKeyPurchase)) {
                promotionPlan.setPurchaseSaleDtos(purchaseSaleService.findCacheList(cacheKeyPurchase));
            }
        }
        if (StringUtils.isNotBlank(cacheKeySale)) {
            promotionPlan.setCurrentMonthSaleDtos(currentMonthSaleService.findCacheList(cacheKeySale));
        }
        if (StringUtils.isNotBlank(cacheKeyOther)) {
            promotionPlan.setOtherExpensesDtos(otherExpensesService.findCacheList(cacheKeyOther));
        }
    }

    /**
     * 获取缓存保存到dto
     *
     * @param promotionPlan
     * @param businessModel
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyPurchase
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    private void getCacheList2(PromotionPlanDto promotionPlan, String businessModel, String cacheKeySale,
                               String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral,
                               String cacheKeyOther) {

        String promotionPlanCode = promotionPlan.getPromotionPlanCode();
        if (PromotionPlanConstant.CX.equals(businessModel)) {
            if (StringUtils.isNotBlank(cacheKeyDelivery)) {
                promotionPlan.setCurrentMonthDeliveryDtos(currentMonthDeliveryService.findCacheList(cacheKeyDelivery));
            } else {
                if (StringUtils.isNotBlank(promotionPlan.getPromotionPlanCode())) {
                    List<CurrentMonthDeliveryDto> dtoList = currentMonthDeliveryRepository.findByPlanCode(promotionPlanCode);
                    promotionPlan.setCurrentMonthDeliveryDtos(dtoList);
                }
            }
            if (StringUtils.isNotBlank(cacheKeyPurchase)) {
                promotionPlan.setPurchaseSaleDtos(purchaseSaleService.findCacheList(cacheKeyPurchase));
            } else {
                if (StringUtils.isNotBlank(promotionPlan.getPromotionPlanCode())) {
                    List<PurchaseSaleDto> dtoList = purchaseSaleRepository.findByPlanCode(promotionPlanCode);
                    promotionPlan.setPurchaseSaleDtos(dtoList);
                }
            }
        }
        if (StringUtils.isNotBlank(cacheKeyOther)) {
            promotionPlan.setOtherExpensesDtos(otherExpensesService.findCacheList(cacheKeyOther));
        } else {
            if (StringUtils.isNotBlank(promotionPlan.getPromotionPlanCode())) {
                List<OtherExpensesDto> dtoList = otherExpensesRepository.findByPlanCode(promotionPlanCode);
                promotionPlan.setOtherExpensesDtos(dtoList);
            }
        }
        if (StringUtils.isNotBlank(cacheKeyGeneral)) {
            promotionPlan.setGeneralExpensesDtos(generalExpensesService.findCacheList(cacheKeyGeneral));
        } else {
            if (StringUtils.isNotBlank(promotionPlan.getPromotionPlanCode())) {
                List<GeneralExpensesDto> dtoList = generalExpensesRepository.findByPlanCode(promotionPlanCode);
                promotionPlan.setGeneralExpensesDtos(dtoList);
            }
        }
        if (StringUtils.isNotBlank(cacheKeySale)) {
            promotionPlan.setCurrentMonthSaleDtos(currentMonthSaleService.findCacheList(cacheKeySale));
        } else {
            if (StringUtils.isNotBlank(promotionPlan.getPromotionPlanCode())) {
                List<CurrentMonthSaleDto> dtoList = currentMonthSaleRepository.findByPlanCode(promotionPlanCode);
                promotionPlan.setCurrentMonthSaleDtos(dtoList);
            }
        }
    }

    /**
     * 清除缓存
     *
     * @param businessModel
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyPurchase
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    private void clearCacheList(String businessModel, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        if (PromotionPlanConstant.CX.equals(businessModel)) {
            if (StringUtils.isNotBlank(cacheKeyDelivery)) {
                currentMonthDeliveryService.clearCache(cacheKeyDelivery);
            }
            if (StringUtils.isNotBlank(cacheKeyPurchase)) {
                purchaseSaleService.clearCache(cacheKeyPurchase);
            }
        }
        if (StringUtils.isNotBlank(cacheKeySale)) {
            currentMonthSaleService.clearCache(cacheKeySale);
        }
        if (StringUtils.isNotBlank(cacheKeyOther)) {
            otherExpensesService.clearCache(cacheKeyOther);
        }
        generalExpensesService.clearCache(cacheKeyGeneral);
    }

    /**
     * 保存
     *
     * @param promotionPlan
     * @param businessModel
     * @param promotionPlanCode
     */
    private void store(PromotionPlanDto promotionPlan, String businessModel, String promotionPlanCode) {

        // redis生成料编码code
        List<String> codeList = this.generateCodeService.generateCode(PromotionPlanConstant.PREFIX_CODE_MX,
                ((CollectionUtils.isEmpty(promotionPlan.getGeneralExpensesDtos()) ? 0 : promotionPlan.getGeneralExpensesDtos().size()) +
                        (CollectionUtils.isEmpty(promotionPlan.getCurrentMonthSaleDtos()) ? 0 : promotionPlan.getCurrentMonthSaleDtos().size()) +
                        (CollectionUtils.isEmpty(promotionPlan.getOtherExpensesDtos()) ? 0 : promotionPlan.getOtherExpensesDtos().size()))
                        + (PromotionPlanConstant.CX.equals(businessModel) ? (
                        (CollectionUtils.isEmpty(promotionPlan.getCurrentMonthDeliveryDtos()) ? 0 : promotionPlan.getCurrentMonthDeliveryDtos().size()) +
                                (CollectionUtils.isEmpty(promotionPlan.getPurchaseSaleDtos()) ? 0 : promotionPlan.getPurchaseSaleDtos().size())
                ) : 0)
                , 9, 2, TimeUnit.DAYS
        );

        int index = 0;

        //费用申请
        BigDecimal totalApplyAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(promotionPlan.getGeneralExpensesDtos())) {
            Collection<GeneralExpensesEntity> generalExpensesEntities = nebulaToolkitService.copyCollectionByWhiteList(promotionPlan.getGeneralExpensesDtos(),
                    GeneralExpensesDto.class, GeneralExpensesEntity.class, HashSet.class, ArrayList.class);
            for (GeneralExpensesEntity e : generalExpensesEntities) {
                e.setPromotionPlanCode(promotionPlanCode);
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setExpensesCode(codeList.get(index));
                e.setBalance(e.getApplyAmount());
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                if (Objects.isNull(e.getApplyAmount())) {
                    e.setApplyAmount(BigDecimal.ZERO);
                }
                totalApplyAmount = totalApplyAmount.add(e.getApplyAmount());
                index++;
            }
            generalExpensesRepository.saveBatch(generalExpensesEntities);
            promotionPlan.setTotalApplyAmount(totalApplyAmount);
        }

        //当月销售
        if (!CollectionUtils.isEmpty(promotionPlan.getCurrentMonthSaleDtos())) {
            Collection<CurrentMonthSaleEntity> currentMonthSaleEntities = nebulaToolkitService.copyCollectionByWhiteList(promotionPlan.getCurrentMonthSaleDtos(),
                    CurrentMonthSaleDto.class, CurrentMonthSaleEntity.class, HashSet.class, ArrayList.class);
            for (CurrentMonthSaleEntity e : currentMonthSaleEntities) {
                e.setPromotionPlanCode(promotionPlanCode);
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setExpensesCode(codeList.get(index));
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                index++;
            }
            currentMonthSaleRepository.saveBatch(currentMonthSaleEntities);
        }

        //其他费用
        if (!CollectionUtils.isEmpty(promotionPlan.getOtherExpensesDtos())) {
            Collection<OtherExpensesEntity> otherExpensesEntitys = nebulaToolkitService.copyCollectionByWhiteList(promotionPlan.getOtherExpensesDtos(),
                    OtherExpensesDto.class, OtherExpensesEntity.class, HashSet.class, ArrayList.class);
            for (OtherExpensesEntity e : otherExpensesEntitys) {
                e.setPromotionPlanCode(promotionPlanCode);
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setExpensesCode(codeList.get(index));
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                index++;
            }
            otherExpensesRepository.saveBatch(otherExpensesEntitys);
        }


        //采销模式保存当月送货、采销库存
        if (PromotionPlanConstant.CX.equals(businessModel)) {
            //当月送货
            if (!CollectionUtils.isEmpty(promotionPlan.getCurrentMonthDeliveryDtos())) {
                Collection<CurrentMonthDeliveryEntity> currentMonthDeliveryEntities = nebulaToolkitService.copyCollectionByWhiteList(promotionPlan.getCurrentMonthDeliveryDtos(),
                        CurrentMonthDeliveryDto.class, CurrentMonthDeliveryEntity.class, HashSet.class, ArrayList.class);
                for (CurrentMonthDeliveryEntity e : currentMonthDeliveryEntities) {
                    e.setPromotionPlanCode(promotionPlanCode);
                    e.setTenantCode(TenantUtils.getTenantCode());
                    e.setExpensesCode(codeList.get(index));
                    e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    index++;
                }
                currentMonthDeliveryRepository.saveBatch(currentMonthDeliveryEntities);
            }

            //采销库存
            if (!CollectionUtils.isEmpty(promotionPlan.getPurchaseSaleDtos())) {
                Collection<PurchaseSale> purchaseSaleEntities = nebulaToolkitService.copyCollectionByWhiteList(promotionPlan.getPurchaseSaleDtos(),
                        PurchaseSaleDto.class, PurchaseSale.class, HashSet.class, ArrayList.class);
                for (PurchaseSale e : purchaseSaleEntities) {
                    e.setPromotionPlanCode(promotionPlanCode);
                    e.setTenantCode(TenantUtils.getTenantCode());
                    e.setExpensesCode(codeList.get(index));
                    e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    index++;
                }
                purchaseSaleRepository.saveBatch(purchaseSaleEntities);
            }
        }
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<PromotionPlanEntity> planlist = this.promotionPlanRepository.listByIds(idList);
        Validate.notEmpty(planlist, "根据提供的主键集合信息，未能获取到相应数据");

        //只能删除【待提交】、【驳回】、【追回】状态的方案
        for (PromotionPlanEntity entity : planlist) {
            if (!ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) && !ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus())
                    && !ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus())) {
                throw new RuntimeException("[" + entity.getPromotionPlanCode() + "]未处于【待提交】、【驳回】、【追回】状态，不能删除！");
            }
        }

        List<String> codeList = planlist.stream().map(e -> e.getPromotionPlanCode()).collect(Collectors.toList());

        this.promotionPlanRepository.removePromotionPlanByIds(idList);
        //逻辑删除明细
        generalExpensesRepository.removeByPromotionPlanCodeList(codeList);
        currentMonthDeliveryRepository.removeByPromotionPlanCodeList(codeList);
        currentMonthSaleRepository.removeByPromotionPlanCodeList(codeList);
        purchaseSaleRepository.removeByPromotionPlanCodeList(codeList);
        otherExpensesRepository.removeByPromotionPlanCodeList(codeList);

        //删除业务日志
        Collection<PromotionPlanDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(planlist,
                PromotionPlanEntity.class, PromotionPlanDto.class, HashSet.class, ArrayList.class);
        SerializableBiConsumer<PromotionPlanLogEventListener, PromotionPlanLogEventDto> onDelete =
                PromotionPlanLogEventListener::onDelete;
        for (PromotionPlanDto dto : dtoList) {
            PromotionPlanLogEventDto logEventDto = new PromotionPlanLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish(logEventDto, PromotionPlanLogEventListener.class, onDelete);
        }
    }

    /**
     * 分页查询费用申请
     *
     * @param pageable
     * @param promotionPlan
     * @return
     */
    @Override
    public Page<GeneralExpensesVo> findByConditionsGeneral(Pageable pageable, PromotionPlanDto promotionPlan) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(promotionPlan)) {
            promotionPlan = new PromotionPlanDto();
        }
        Page<GeneralExpensesVo> expensesVoPage = generalExpensesRepository.findByConditionsGeneral(pageable, promotionPlan);
        List<GeneralExpensesVo> records = expensesVoPage.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            ArrayList<GeneralExpensesVo> list = new ArrayList<>(records.size());
            Set<String> set = records.stream().map(GeneralExpensesVo::getExpensesCode).collect(Collectors.toSet());
            List<GeneralExpensesVo> expensesVos = generalExpensesRepository.findDataByExpensesCodes(set);
            Map<String, GeneralExpensesVo> voMap = expensesVos.stream().collect(Collectors.toMap(GeneralExpensesVo::getExpensesCode, Function.identity(), (a, b) -> a));
            for (GeneralExpensesVo r : records) {
                if (Objects.nonNull(voMap)) {
                    GeneralExpensesVo expensesVo = voMap.get(r.getExpensesCode());
                    if (Objects.isNull(expensesVo)) {
                        continue;
                    }
                    r.setWithholdingAmount(expensesVo.getWithholdingAmount());
                    r.setEstimatedWriteOffAmount(expensesVo.getEstimatedWriteOffAmount());
                }
                list.add(r);
            }
            return expensesVoPage.setRecords(list);
        }
        return expensesVoPage;
    }

    /**
     * 分页查询促销规划及其费用申请信息
     *
     * @param pageable      分页对象
     * @param promotionPlan 实体对象
     * @return
     */
    @Override
    public Page<PromotionPlanVo> findByConditionsWithGeneralExpenses(Pageable pageable, PromotionPlanDto promotionPlan) {
        Page<PromotionPlanVo> byConditions = this.findByConditions(pageable, promotionPlan);
        List<PromotionPlanVo> promotionPlanVoList = byConditions.getRecords();
        promotionPlanVoList.forEach(promotionPlanVo -> {
            List<GeneralExpensesDto> GeneralExpensesDtoList = generalExpensesRepository.findByPlanCode(promotionPlanVo.getPromotionPlanCode());
            List<GeneralExpensesVo> GeneralExpensesVoList = (List<GeneralExpensesVo>) nebulaToolkitService.copyCollectionByWhiteList(GeneralExpensesDtoList, GeneralExpensesDto.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class);
            promotionPlanVo.setGeneralExpensesVos(GeneralExpensesVoList);
        });
        return byConditions;
    }

    /**
     * 通过明细编码查询费用申请
     *
     * @param detailCode 明细编码
     * @return 单条数据
     */
    @Override
    public GeneralExpensesVo findByDetailCodeGeneral(String detailCode) {
        List<GeneralExpensesEntity> list = generalExpensesRepository.findByExpensesCode(detailCode);
        Validate.isTrue(!CollectionUtils.isEmpty(list), "未找到对应的费用申请");
        return nebulaToolkitService.copyObjectByWhiteList(list.get(0), GeneralExpensesVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<GeneralExpensesVo> findByDetailCodes(Set<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        return generalExpensesRepository.findByExpensesCodes(detailCodes);

    }

    /**
     * 修改费用申请
     *
     * @param vo
     * @return
     */
    @Override
    public void updateGeneral(GeneralExpensesVo vo) {
        GeneralExpensesEntity generalExpensesEntity = nebulaToolkitService.copyObjectByWhiteList(vo, GeneralExpensesEntity.class, HashSet.class, ArrayList.class);

        generalExpensesRepository.saveOrUpdate(generalExpensesEntity);
    }

    /**
     * 根据预估计算费用
     *
     * @param promotionPlan
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyGeneral
     */
    @Override
    public void generateGeneralExpenses(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral) {
        // 查询数据字典
        Map<String, List<DictDataVo>> dictDataMap = dictDataVoService.findByDictTypeCodeList(Arrays.asList(PromotionPlanConstant.BUSINESS_MODEL, ActivityApplyRulesConstant.PROMOTION_PLAN_ACT_FORM, ActivityApplyRulesConstant.PROMOTION_PLAN_ACT_FORM2));
        Validate.notEmpty(dictDataMap, "未查找到任意配置字典");
        DictDataVo dictDataVo = dictDataMap.get(PromotionPlanConstant.BUSINESS_MODEL).stream().filter(e ->
                promotionPlan.getBusinessModelCode().equals(e.getDictCode())).findFirst().orElse(null);
        Validate.notNull(dictDataVo, "数据字典：业务模式，未维护");

        List<DictDataVo> dictDataTypeVos = dictDataMap.get(ActivityApplyRulesConstant.PROMOTION_PLAN_ACT_FORM);
        Validate.notEmpty(dictDataTypeVos, "未查找到促销规划活动类型编码配置字典");
        Map<String, DictDataVo> typeMap = dictDataTypeVos.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));

        List<DictDataVo> dictDataFormVos = dictDataMap.get(ActivityApplyRulesConstant.PROMOTION_PLAN_ACT_FORM2);
        Validate.notEmpty(dictDataFormVos, "未查找到促销规划活动形式编码配置字典");
        Map<String, DictDataVo> formMap = dictDataFormVos.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));

        List<GeneralExpensesDto> generateGeneralDtos = new ArrayList<>();
        if (PromotionPlanConstant.CX.equals(dictDataVo.getDictValue())) {
            //当月送货转费用申请
            if (StringUtils.isNotBlank(cacheKeyDelivery)) {
                //渠道推广费、采购返点
                BigDecimal channelPromotionFee = BigDecimal.ZERO;
                BigDecimal purchaseRebate = BigDecimal.ZERO;
                List<CurrentMonthDeliveryDto> deliveryList = currentMonthDeliveryService.findCacheList(cacheKeyDelivery);
                for (CurrentMonthDeliveryDto e : deliveryList) {
                    if (e.getChannelPromotionFee() != null) {
                        channelPromotionFee = channelPromotionFee.add(e.getChannelPromotionFee());
                    }
                    if (e.getPurchaseRebate() != null) {
                        purchaseRebate = purchaseRebate.add(e.getPurchaseRebate());
                    }
                }
                addGeneral(generateGeneralDtos, promotionPlan, channelPromotionFee, typeMap.get(PromotionPlanActFormEnum.CHANNEL_PROMOTION_FEE.getCode()).getDictValue(),
                        formMap.get(PromotionPlanActFormEnum.CHANNEL_PROMOTION_FEE.getCode()).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                addGeneral(generateGeneralDtos, promotionPlan, purchaseRebate, typeMap.get(PromotionPlanActFormEnum.PURCHASE_REBATE.getCode()).getDictValue(),
                        formMap.get(PromotionPlanActFormEnum.PURCHASE_REBATE.getCode()).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
            }
            //采销库存转费用申请
            if (StringUtils.isNotBlank(cacheKeyPurchase)) {
                List<PurchaseSaleDto> purchaseList = purchaseSaleService.findCacheList(cacheKeyPurchase);
                //费用池-补差、费用池-销售返、费用池-投放、费用池-采购返、费用池-毛保汇总生成
                BigDecimal difference = BigDecimal.ZERO;
                BigDecimal saleCommission = BigDecimal.ZERO;
                BigDecimal put = BigDecimal.ZERO;
                BigDecimal purchaseRebate = BigDecimal.ZERO;
                BigDecimal grossProtection = BigDecimal.ZERO;
                for (PurchaseSaleDto purchase : purchaseList) {
                    if (purchase.getFeePoolDifference() != null) {
                        difference = difference.add(purchase.getFeePoolDifference());
                    }
                    if (purchase.getFeePoolSaleCommission() != null) {
                        saleCommission = saleCommission.add(purchase.getFeePoolSaleCommission());
                    }
                    if (purchase.getFeePoolPut() != null) {
                        put = put.add(purchase.getFeePoolPut());
                    }
                    if (purchase.getFeePoolPurchaseRebate() != null) {
                        purchaseRebate = purchaseRebate.add(purchase.getFeePoolPurchaseRebate());
                    }
                    if (purchase.getFeePoolGrossProtection() != null) {
                        grossProtection = grossProtection.add(purchase.getFeePoolGrossProtection());
                    }
                }
                addGeneral(generateGeneralDtos, promotionPlan, difference, typeMap.get(PromotionPlanActFormEnum.FEE_POOL_DIFFERENCE.getCode()).getDictValue(),
                        formMap.get(PromotionPlanActFormEnum.FEE_POOL_DIFFERENCE.getCode()).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                addGeneral(generateGeneralDtos, promotionPlan, saleCommission, typeMap.get(PromotionPlanActFormEnum.FEE_POOL_SALE_COMMISSION.getCode()).getDictValue(),
                        formMap.get(PromotionPlanActFormEnum.FEE_POOL_SALE_COMMISSION.getCode()).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                addGeneral(generateGeneralDtos, promotionPlan, put, typeMap.get(PromotionPlanActFormEnum.FEE_POOL_PUT.getCode()).getDictValue(),
                        formMap.get(PromotionPlanActFormEnum.FEE_POOL_PUT.getCode()).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                addGeneral(generateGeneralDtos, promotionPlan, purchaseRebate, typeMap.get(PromotionPlanActFormEnum.FEE_POOL_PURCHASE_REBATE.getCode()).getDictValue(),
                        formMap.get(PromotionPlanActFormEnum.FEE_POOL_PURCHASE_REBATE.getCode()).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                addGeneral(generateGeneralDtos, promotionPlan, grossProtection, typeMap.get(PromotionPlanActFormEnum.FEE_POOL_GROSS_PROTECTION.getCode()).getDictValue(),
                        formMap.get(PromotionPlanActFormEnum.FEE_POOL_GROSS_PROTECTION.getCode()).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
            }
        }
        //当月销售转费用申请
        if (StringUtils.isNotBlank(cacheKeySale)) {
            List<CurrentMonthSaleDto> saleList = currentMonthSaleService.findCacheList(cacheKeySale);
            //按客户分组汇总
            Map<String, List<CurrentMonthSaleDto>> customerMap = saleList.stream().collect(Collectors.groupingBy(e ->
                    e.getCustomerCode() + "|" + e.getCustomerName() + "|" + e.getChannelCode() + "|" + e.getChannelName()
            ));
            customerMap.forEach((k, v) -> {
                //产品促销、大日期处理、新客专享、老客留存、达人佣金（抖音）、平台毛保、平台服务费、平台返点费用、平台佣金扣点、销售返点、渠道推广费、仓间不均、高周转、
                //采购返点、销基础返点（旬返）、分销基础返点（月返）、月度目标达成返点（分销）、到手价政策（分销）、人员费用（分销）、投放费用（分销）、物流支持（分销）、年度目标达成返点（分销）、到手价政策（分销）
                BigDecimal productPromotion = BigDecimal.ZERO,
                        largeDateProcess = BigDecimal.ZERO,
                        newCustomer = BigDecimal.ZERO,
                        oldCustomer = BigDecimal.ZERO,
                        tiktokMaster = BigDecimal.ZERO,
                        platformGrossProtection = BigDecimal.ZERO,
                        platformService = BigDecimal.ZERO,
                        platformRebate = BigDecimal.ZERO,
                        platformCommission = BigDecimal.ZERO,
                        saleCommission = BigDecimal.ZERO,
                        uneven = BigDecimal.ZERO,
                        highTurnover = BigDecimal.ZERO,
                        jd = BigDecimal.ZERO,
                        distributionBaseTen = BigDecimal.ZERO,
                        distributionBaseMonth = BigDecimal.ZERO,
                        monthGoalAchievement = BigDecimal.ZERO,
                        prePack = BigDecimal.ZERO,
                        staffFee = BigDecimal.ZERO,
                        putFee = BigDecimal.ZERO,
                        logisticsSupport = BigDecimal.ZERO,
                        yearGoalAchievement = BigDecimal.ZERO,
                        takeHomePricePolicyFee = BigDecimal.ZERO;
                for (CurrentMonthSaleDto e : v) {
                    if (e.getProductPromotion() != null) {
                        productPromotion = productPromotion.add(e.getProductPromotion());
                    }
                    if (e.getLargeDateProcess() != null) {
                        largeDateProcess = largeDateProcess.add(e.getLargeDateProcess());
                    }
                    if (e.getNewCustomer() != null) {
                        newCustomer = newCustomer.add(e.getNewCustomer());
                    }
                    if (e.getOldCustomer() != null) {
                        oldCustomer = oldCustomer.add(e.getOldCustomer());
                    }
                    if (e.getTiktokMaster() != null) {
                        tiktokMaster = tiktokMaster.add(e.getTiktokMaster());
                    }
                    if (e.getPlatformGrossProtection() != null) {
                        platformGrossProtection = platformGrossProtection.add(e.getPlatformGrossProtection());
                    }
                    if (e.getPlatformService() != null) {
                        platformService = platformService.add(e.getPlatformService());
                    }
                    if (e.getPlatformRebate() != null) {
                        platformRebate = platformRebate.add(e.getPlatformRebate());
                    }
                    if (e.getPlatformCommission() != null) {
                        platformCommission = platformCommission.add(e.getPlatformCommission());
                    }
                    if (e.getSaleCommission() != null) {
                        saleCommission = saleCommission.add(e.getSaleCommission());
                    }
                    if (e.getUneven() != null) {
                        uneven = uneven.add(e.getUneven());
                    }
                    if (e.getHighTurnover() != null) {
                        highTurnover = highTurnover.add(e.getHighTurnover());
                    }
                    if (e.getJd() != null) {
                        jd = jd.add(e.getJd());
                    }
                    if (e.getDistributionBaseTen() != null) {
                        distributionBaseTen = distributionBaseTen.add(e.getDistributionBaseTen());
                    }
                    if (e.getDistributionBaseMonth() != null) {
                        distributionBaseMonth = distributionBaseMonth.add(e.getDistributionBaseMonth());
                    }
                    if (e.getMonthGoalAchievement() != null) {
                        monthGoalAchievement = monthGoalAchievement.add(e.getMonthGoalAchievement());
                    }
                    if (e.getPrePack() != null) {
                        prePack = prePack.add(e.getPrePack());
                    }
                    if (e.getStaffFee() != null) {
                        staffFee = staffFee.add(e.getStaffFee());
                    }
                    if (e.getPutFee() != null) {
                        putFee = putFee.add(e.getPutFee());
                    }
                    if (e.getLogisticsSupport() != null) {
                        logisticsSupport = logisticsSupport.add(e.getLogisticsSupport());
                    }
                    if (e.getYearGoalAchievement() != null) {
                        yearGoalAchievement = yearGoalAchievement.add(e.getYearGoalAchievement());
                    }
                    if (e.getTakeHomePricePolicyFee() != null) {
                        takeHomePricePolicyFee = takeHomePricePolicyFee.add(e.getTakeHomePricePolicyFee());
                    }
                }
                String[] split = k.split("\\|");
                String customerCode = split[0];
                String customerName = split[1];
                String channelCode = split[2];
                String channelName = split[3];
                if (PromotionPlanConstant.FX.equals(dictDataVo.getDictValue())) {
                    addGeneral(generateGeneralDtos, promotionPlan, distributionBaseTen, typeMap.get(PromotionPlanActFormEnum.DISTRIBUTION_BASE_TEN.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.DISTRIBUTION_BASE_TEN.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, distributionBaseMonth, typeMap.get(PromotionPlanActFormEnum.DISTRIBUTION_BASE_MONTH.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.DISTRIBUTION_BASE_MONTH.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, monthGoalAchievement, typeMap.get(PromotionPlanActFormEnum.MONTH_GOAL_ACHIEVEMENT.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.MONTH_GOAL_ACHIEVEMENT.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, prePack, typeMap.get(PromotionPlanActFormEnum.PRE_PACK.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.PRE_PACK.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, staffFee, typeMap.get(PromotionPlanActFormEnum.STAFF_FEE.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.STAFF_FEE.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, putFee, typeMap.get(PromotionPlanActFormEnum.PUT_FEE.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.PUT_FEE.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, logisticsSupport, typeMap.get(PromotionPlanActFormEnum.LOGISTICS_SUPPORT.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.LOGISTICS_SUPPORT.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, yearGoalAchievement, typeMap.get(PromotionPlanActFormEnum.YEAR_GOAL_ACHIEVEMENT.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.YEAR_GOAL_ACHIEVEMENT.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, takeHomePricePolicyFee, typeMap.get(PromotionPlanActFormEnum.TAKE_HOME_PRICE_POLICY_FEE.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.TAKE_HOME_PRICE_POLICY_FEE.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                } else {
                    addGeneral(generateGeneralDtos, promotionPlan, productPromotion, typeMap.get(PromotionPlanActFormEnum.PRODUCT_PROMOTION.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.PRODUCT_PROMOTION.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, largeDateProcess, typeMap.get(PromotionPlanActFormEnum.LARGE_DATE_PROCESS.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.LARGE_DATE_PROCESS.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, newCustomer, typeMap.get(PromotionPlanActFormEnum.NEW_CUSTOMER.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.NEW_CUSTOMER.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, oldCustomer, typeMap.get(PromotionPlanActFormEnum.OLD_CUSTOMER.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.OLD_CUSTOMER.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, tiktokMaster, typeMap.get(PromotionPlanActFormEnum.TIKTOK_MASTER.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.TIKTOK_MASTER.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, platformGrossProtection, typeMap.get(PromotionPlanActFormEnum.PLATFORM_GROSS_PROTECTION.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.PLATFORM_GROSS_PROTECTION.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, platformService, typeMap.get(PromotionPlanActFormEnum.PLATFORM_SERVICE.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.PLATFORM_SERVICE.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, platformRebate, typeMap.get(PromotionPlanActFormEnum.PLATFORM_REBATE.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.PLATFORM_REBATE.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, platformCommission, typeMap.get(PromotionPlanActFormEnum.PLATFORM_COMMISSION.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.PLATFORM_COMMISSION.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, saleCommission, typeMap.get(PromotionPlanActFormEnum.SALE_COMMISSION.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.SALE_COMMISSION.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, uneven, typeMap.get(PromotionPlanActFormEnum.UNEVEN.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.UNEVEN.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, highTurnover, typeMap.get(PromotionPlanActFormEnum.HIGH_TURNOVER.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.HIGH_TURNOVER.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                    addGeneral(generateGeneralDtos, promotionPlan, jd, typeMap.get(PromotionPlanActFormEnum.PURCHASE_REBATE.getCode()).getDictValue(),
                            formMap.get(PromotionPlanActFormEnum.PURCHASE_REBATE.getCode()).getDictValue(), customerCode, customerName, channelCode, channelName);
                }
            });
        }
        //如果生成了费用申请，清除缓存，重新保存
        if (!CollectionUtils.isEmpty(generateGeneralDtos)) {
            generalExpensesService.addItemListCache(cacheKeyGeneral, generateGeneralDtos);
        }
    }

    /**
     * 提交审批
     *
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void submitApproval(PromotionPlanSubmitDto dto) {
        Validate.isTrue(Objects.nonNull(dto.getProcessBusiness()), "流程参数不能为空");
        PromotionPlanEntity entity = promotionPlanRepository.getById(dto.getId());
        Validate.notNull(entity, "未找到对应的促销规划");
        PromotionPlanDto promotionPlanDto = nebulaToolkitService.copyObjectByWhiteList(entity, PromotionPlanDto.class, HashSet.class, ArrayList.class);
        monthBudgetHandle(promotionPlanDto, BudgetOperationTypeEnum.USE.getCode());
        submitApprovalHandle(promotionPlanDto, dto.getProcessBusiness());
    }

    /**
     * 保存并提交审批
     *
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void submitAndSetPass(PromotionPlanSubmitDto dto, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.isTrue(Objects.nonNull(dto), "促销规划的数据不能为空");
        Validate.isTrue(Objects.nonNull(processBusiness), "流程参数不能为空");
        PromotionPlanDto promotionPlanDto = nebulaToolkitService.copyObjectByWhiteList(dto, PromotionPlanDto.class, HashSet.class, ArrayList.class);
        String businessModel;
        if (StringUtils.isNotBlank(dto.getId())) {
            businessModel = updateValidate(promotionPlanDto);
            updateHandle(businessModel, promotionPlanDto, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase,
                    cacheKeyGeneral, cacheKeyOther, true);
        } else {
            businessModel = createValidate(promotionPlanDto);
            createHandle(businessModel, promotionPlanDto, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase,
                    cacheKeyGeneral, cacheKeyOther, true);
        }
        PromotionPlanEntity entity = promotionPlanRepository.getById(promotionPlanDto.getId());
        Validate.notNull(entity, "未找到对应的促销规划");
        promotionPlanDto = nebulaToolkitService.copyObjectByWhiteList(entity, PromotionPlanDto.class, HashSet.class, ArrayList.class);
        monthBudgetHandle(promotionPlanDto, BudgetOperationTypeEnum.USE.getCode());
        submitApprovalHandle(promotionPlanDto, processBusiness);

        //数据保存完清理掉缓存
        clearCacheList(businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
    }

    /**
     * 获取预算信息
     *
     * @param cacheKeyGeneral
     * @return
     */
    @Override
    public List<MonthBudgetBusinessPolicyQueryVo> getMonthBudget(String cacheKeyGeneral, String cacheKeySale, String promotionPlanCode) {
        List<MonthBudgetBusinessPolicyQueryVo> monthBudgetVoList = new ArrayList<>();
        List<GeneralExpensesDto> cacheList = new ArrayList<>();
        List<CurrentMonthSaleDto> saleList = new ArrayList<>();

        if (StringUtils.isNotBlank(cacheKeyGeneral)) {
            cacheList = generalExpensesService.findCacheList(cacheKeyGeneral);
        } else {
            if (StringUtils.isNotBlank(promotionPlanCode)) {
                cacheList = generalExpensesRepository.findByPlanCode(promotionPlanCode);
            }
        }
        if (StringUtils.isNotBlank(cacheKeySale)) {
            saleList = currentMonthSaleService.findCacheList(cacheKeySale);
        } else {
            if (StringUtils.isNotBlank(promotionPlanCode)) {
                saleList = currentMonthSaleRepository.findByPlanCode(promotionPlanCode);
            }
        }

        monthBudgetVoList = getMonthBudgetHandle(cacheList, saleList);

        return monthBudgetVoList;
    }

    /**
     * 封装预算信息
     *
     * @param cacheList
     * @param saleList
     */
    public List<MonthBudgetBusinessPolicyQueryVo> getMonthBudgetHandle(List<GeneralExpensesDto> cacheList, List<CurrentMonthSaleDto> saleList) {
        List<MonthBudgetBusinessPolicyQueryVo> monthBudgetVoList = new ArrayList<>();
        //预计折后销售额汇总
        BigDecimal sumSale = saleList.stream().map(e -> bdNull(e.getEstimatedAmountAfter())).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!CollectionUtils.isEmpty(cacheList)) {
            LinkedHashSet<String> codes = cacheList.stream().filter(e -> StringUtils.isNotBlank(e.getMonthBudgetCode())).map(e -> e.getMonthBudgetCode()).collect(Collectors.toCollection(LinkedHashSet::new));
            monthBudgetVoList = monthBudgetService.findBusinessPolicyByCodes(new ArrayList<>(codes));
            monthBudgetVoList.forEach(vo -> {
                BigDecimal amount = cacheList.stream().filter(e -> vo.getMonthBudgetCode().equals(e.getMonthBudgetCode()))
                        .map(e -> bdNull(e.getApplyAmount()))
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setUsedAmount(amount);
                vo.setUsedVsControl(amount.subtract(bdNull(vo.getControlBalanceAmount())));
                //费用率(%)：自动计算，费用率（%）=本次使用金额/当月销售中的预计折后销售额汇总值，保留6位小数
                vo.setFeeRatio(sumSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.divide(sumSale, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)));
                vo.setBusinessCode(cacheList.get(0).getPromotionPlanCode());
            });
        }
        return monthBudgetVoList;
    }

    /**
     * 驳回追回
     *
     * @param promotionPlan
     */
    @Override
    public void rejectRecover(PromotionPlanDto promotionPlan) {
        monthBudgetHandle(promotionPlan, BudgetOperationTypeEnum.RETURN.getCode());
    }

    /**
     * 结果呈现
     *
     * @param promotionPlan
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyPurchase
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    @Override
    public List<PromotionPlanResultVoStr> calculationResult(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther, String type) {
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult = getCahchResult(promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther, type);
        //当前年份1月至当月预算数据合计
        String nowStr = LocalDate.now().getYear() + "-01-01";
        List<PromotionPlanResult> history = promotionPlanResultRepository.getByDate(DateUtil.parse(nowStr, DatePattern.NORM_DATE_PATTERN), promotionPlan.getCustomerCode(), type);
        if (!CollectionUtils.isEmpty(history)) {
            List<PromotionPlanResultVo> historyVo = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(history, PromotionPlanResult.class, PromotionPlanResultVo.class, HashSet.class, ArrayList.class));
            Map<String, List<PromotionPlanResultVo>> historyMap = historyVo.stream().collect(Collectors.groupingBy(e -> e.getProjectCode()));
            historyMap.forEach((k, v) -> {
                BigDecimal total = v.stream().map(e -> bdNull(e.getPlan()))
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                cahchResult.get(k).setPlanTotal(total.add(cahchResult.get(k).getPlan() == null ? BigDecimal.ZERO : cahchResult.get(k).getPlan()));
            });
        } else {
            for (String k : cahchResult.keySet()) {
                PromotionPlanResultVo v = cahchResult.get(k);
                if (PromotionPlanResultProjectEnum.INTENSITY.getCode().equals(k)) {
                    continue;
                }
                v.setPlanTotal(v.getPlan());
            }
        }

        BigDecimal cost = cahchResult.get(PromotionPlanResultProjectEnum.COST.getCode()).getPlanTotal();
        BigDecimal netIncome = cahchResult.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).getPlanTotal();
        BigDecimal discount = cahchResult.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).getPlanTotal();
        BigDecimal discountAfterSale = cahchResult.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).getPlanTotal();
        BigDecimal reimbursement = cahchResult.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).getPlanTotal();
        BigDecimal consumer = cahchResult.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).getPlanTotal();
        BigDecimal channel = cahchResult.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).getPlanTotal();
        BigDecimal put = cahchResult.get(PromotionPlanResultProjectEnum.PUT.getCode()).getPlanTotal();
        BigDecimal platformOperate = cahchResult.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).getPlanTotal();
        BigDecimal discountBeforeSale = cahchResult.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).getPlanTotal();
        BigDecimal logistics = cahchResult.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).getPlanTotal();
        BigDecimal ton = cahchResult.get(PromotionPlanResultProjectEnum.TON.getCode()).getPlanTotal();
        BigDecimal netProfit = cahchResult.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).getPlanTotal();
        BigDecimal feePool = cahchResult.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).getPlanTotal();

        //毛利率 （规划净收入-规划成本）/规划净收入
        cahchResult.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setPlanTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                (netIncome.subtract(cost)).divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
        //折扣费用率 规划折扣费用/规划折后含税销售额
        cahchResult.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                discount.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //报销费用率 规划报销费用/规划折后含税销售额
        cahchResult.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                reimbursement.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //消费者费用率 规划消费者费用/规划折后含税销售额
        cahchResult.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                consumer.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //渠道费用率 规划渠道费用/规划折后含税销售额
        cahchResult.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                channel.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //投放费用率 规划投放费用/规划折后含税销售额
        cahchResult.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                put.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //平台运营费用率 规划平台运营费用/规划折后含税销售额
        cahchResult.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                platformOperate.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //专项费用率 采销：（规划消费者费用+规划渠道费用+规划投放费用+规划平台运营费用+规划费用池）/规划折后含税销售额，其他：（规划消费者费用+规划渠道费用+规划投放费用+规划平台运营费用）/规划折后含税销售额
        BigDecimal specialCost = BigDecimal.ZERO;
        if (PromotionPlanConstant.CX_CODE.equals(promotionPlan.getBusinessModelCode())) {
            specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    (consumer.add(channel).add(put).add(platformOperate)).add(feePool).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
        } else {
            specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    (consumer.add(channel).add(put).add(platformOperate)).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
        }
        cahchResult.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setPlanTotal(specialCost);
        //物流费用率 规划物流费用/规划折前销售额
        cahchResult.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setPlanTotal(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                logistics.divide(discountBeforeSale, 4, BigDecimal.ROUND_HALF_UP));
        //物流费用单吨（元/吨） 规划物流费用/吨数
        cahchResult.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setPlanTotal(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                logistics.multiply(new BigDecimal(1000)).divide(ton, 2, BigDecimal.ROUND_HALF_UP));
        //净利率 规划净利润/规划净收入
        cahchResult.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setPlanTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                netProfit.divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));

        for (String k : cahchResult.keySet()) {
            PromotionPlanResultVo v = cahchResult.get(k);
            v.setPlanVsContemporaneous(bdNull(v.getPlan()).subtract(bdNull(v.getContemporaneous())));
            v.setPlanVsBudget(bdNull(v.getPlan()).subtract(bdNull(v.getBudget())));
            if (PromotionPlanResultProjectEnum.INTENSITY.getCode().equals(k)) {
                continue;
            }
            v.setActualPlan(bdNull(v.getContemporaneousTotal()).add(bdNull(v.getPlan())));
            v.setActualPlanVsBudget(v.getActualPlan().subtract(bdNull(v.getBudgetTotal())));
        }

        return voChange(cahchResult);
    }

    /**
     * 当月销售计算折扣、销管报销、行政+人力
     *
     * @param promotionPlan
     * @param cacheKeySale
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    @Override
    public void calculationCurrentMonthSaleFee(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel = createValidate(promotionPlan);
        getCacheList2(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);

        monthSaleFee(promotionPlan);
        currentMonthSaleService.clearCache(cacheKeySale);
        currentMonthSaleService.addListCache(cacheKeySale, promotionPlan.getCurrentMonthSaleDtos());
    }

    private void monthSaleFee(PromotionPlanDto promotionPlan) {

        List<CurrentMonthSaleDto> currentMonthSaleDtos = promotionPlan.getCurrentMonthSaleDtos() == null ? new ArrayList<>() : promotionPlan.getCurrentMonthSaleDtos();
        List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos = promotionPlan.getCurrentMonthDeliveryDtos() == null ? new ArrayList<>() : promotionPlan.getCurrentMonthDeliveryDtos();
        List<PurchaseSaleDto> purchaseSaleDtos = promotionPlan.getPurchaseSaleDtos() == null ? new ArrayList<>() : promotionPlan.getPurchaseSaleDtos();
        List<GeneralExpensesDto> generalExpensesDtos = promotionPlan.getGeneralExpensesDtos() == null ? new ArrayList<>() : promotionPlan.getGeneralExpensesDtos();
        List<OtherExpensesDto> otherExpensesDtos = promotionPlan.getOtherExpensesDtos() == null ? new ArrayList<>() : promotionPlan.getOtherExpensesDtos();

        //获取不同逻辑所包含的平台名称
        Map<String, List<DictDataVo>> dictTypeCodeMap = dictDataVoService.findByDictTypeCodeList(Arrays.asList(PromotionPlanConstant.DISCOUNTS, PromotionPlanConstant.TPM_SALES_MANAGEMENT_REIMBURSEMENT));
        Map<String, DictDataVo> saleDiscountMap = dictTypeCodeMap.get(PromotionPlanConstant.DISCOUNTS).stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        Map<String, DictDataVo> saleReimburseMap = dictTypeCodeMap.get(PromotionPlanConstant.TPM_SALES_MANAGEMENT_REIMBURSEMENT).stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));

        List<String> oneD = saleDiscountMap.get(PromotionPlanConstant.ONE).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> twoD = saleDiscountMap.get(PromotionPlanConstant.TWO).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> threeD = saleDiscountMap.get(PromotionPlanConstant.THREE).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> fourD = saleDiscountMap.get(PromotionPlanConstant.FOUR).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> oneR = saleReimburseMap.get(PromotionPlanConstant.ONE).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> twoR = saleReimburseMap.get(PromotionPlanConstant.TWO).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> threeR = saleReimburseMap.get(PromotionPlanConstant.THREE).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());

        //折扣	"折扣=单品折扣+分摊折扣（费用申请页中手工增加的结案形式为“红字发票”的费用合计后进行分摊）
        //分摊折扣=【费用申请中手工添加或者导入的同样客户的费用行中结案形式为“红字发票”的行申请金额汇总*当月销售中预计折前销售额/当月销售中预计折前销售额汇总】
        //单品折扣逻辑如下：
        //1、如果平台=京东商城，单品折扣=当月销售中的京东采购返
        //2、如果平台=天猫超市，单品折扣=当月销售的（产品促销+新客专享+老客留存+大日期+高周转+仓间不均+达人佣金（抖音）+平台毛保）
        //3、如果平台=线上分销、多多买菜，单品折扣=当月销售中的（分销基础返点（旬返）+分销基础返点（月返）+月度目标达成返点（分销）+年度目标达成返点（分销）+百利包（分销）+人员费用（分销）+投放费用（分销）+物流支持（分销)+到手价政策费用）
        //4、其他：
        //单品折扣=当月销售的（产品促销+新客专享+老客留存+大日期+高周转+仓间不均+达人佣金（抖音））"

        //销管报销（元）	"销管报销=单品报销金额+分摊的报销金额（费用申请页中手工增加的结案形式为“报销”的费用分摊金额）
        //分摊报销=【（费用申请中手工添加或者导入的同一个客户的费用行中结案形式为“报销”的行申请金额汇总）-（费用池补差+费用池销售返+费用池采购返+费用池投放+费用池毛保）*当月销售中预计折前销售额/当月销售中预计折前销售额汇总】
        //单品报销金额细化逻辑如下：
        //1、如果平台=天猫超市，单品报销=（当月送货中所有行的渠道推广费的汇总）*（当月销售中预计折前销售额/当月销售中预计折前销售额汇总）/1.06 + 当月销售中平台服务费/1.06
        //2、如果平台=京东商城，单品报销=当月销售的（产品促销+新客专享+老客留存+大日期+达人佣金（抖音）+高周转+仓间不均+平台毛保+销售返点）/1.06
        //4、其他平台：
        //单品报销=当月销售中的（平台服务费+平台返点费用+平台佣金扣点）/1.06

        //行政+人力（元）	当月费用申请的行政费用含税金额*预计折前销售额/预计折前销售额合计

        //物流费用（元）= 【用行上的客户匹配运费价格表的运费率*当月销售中的预计折前销售额】+【其他费用录入中的（物流费用-规划）*该产品在当月销售页面的预计折前销售额/预计折前销售额合计】

        //单品折扣（折扣）
        BigDecimal discountSingleD;
        //单品折扣（销管报销）
        BigDecimal discountSingleR;
        //当月销售中预计折前销售额汇总
        BigDecimal discountBeforeTotal = currentMonthSaleDtos.stream().map(e -> bdNull(e.getEstimatedAmountBefore()))
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //其他费用中人力+行政汇总
        BigDecimal adminHumanTotal = BigDecimal.ZERO;
        //物流规划汇总
        BigDecimal logisticsTotal = BigDecimal.ZERO;
        for (OtherExpensesDto dto : otherExpensesDtos) {
            adminHumanTotal = adminHumanTotal.add(bdNull(dto.getAdminAmountPlan())
                    .add(bdNull(dto.getHumanAmountPlan())));
            logisticsTotal = logisticsTotal.add(bdNull(dto.getLogisticsAmountPlan()));
        }

        Validate.isTrue(BigDecimal.ZERO.compareTo(discountBeforeTotal) < 0, "预计折前销售额汇总必须大于0");

        //按客户分组
        Map<String, List<GeneralExpensesDto>> customerListMap = generalExpensesDtos.stream().collect(Collectors.groupingBy(e -> e.getCustomerCode()));
        Map<String, Map<String, BigDecimal>> customerRRMap = new HashMap<>();
        customerListMap.forEach((k, v) -> {
            Map<String, BigDecimal> customerMap = new HashMap<>();
            //红字发票汇总
            BigDecimal redInvoice = BigDecimal.ZERO;
            //报销汇总
            BigDecimal reimburse = BigDecimal.ZERO;
            for (GeneralExpensesDto dto : v) {
                if (Boolean.TRUE.equals(dto.getBeGenerate())) {
                    continue;
                }
                if (PromotionPlanConstant.RED_INVOICE.equals(dto.getAuditWayName())) {
                    redInvoice = redInvoice.add(dto.getApplyAmount());
                }
                if (PromotionPlanConstant.REIMBURSE.equals(dto.getAuditWayName())) {
                    reimburse = reimburse.add(dto.getApplyAmount());
                }
            }
            customerMap.put("redInvoice", redInvoice);
            customerMap.put("reimburse", reimburse);
            customerRRMap.put(k, customerMap);
        });

        //当月送货渠道推广费汇总
        BigDecimal channelPromotionFee = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(currentMonthDeliveryDtos)) {
            channelPromotionFee = currentMonthDeliveryDtos.stream().map(e -> bdNull(e.getChannelPromotionFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        //按客户分组
        Map<String, List<CurrentMonthSaleDto>> currentMonthSaleMap = currentMonthSaleDtos.stream().collect(Collectors.groupingBy(e -> e.getCustomerCode()));
        List<CurrentMonthSaleDto> temp = new ArrayList<>();
        for (String k : currentMonthSaleMap.keySet()) {
            List<CurrentMonthSaleDto> dtoList = currentMonthSaleMap.get(k);
            BigDecimal discountBeforeTotalCustomer = dtoList.stream().map(e -> bdNull(e.getEstimatedAmountBefore()))
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            for (CurrentMonthSaleDto dto : dtoList) {
                //当月销售中平台服务费
                BigDecimal platformService = BigDecimal.ZERO;
                //分摊比例
                BigDecimal ratio = dto.getEstimatedAmountBefore().divide(discountBeforeTotalCustomer, 6, BigDecimal.ROUND_HALF_UP);

                //折扣
                if (oneD.contains(promotionPlan.getPlatformName())) {
                    discountSingleD = bdNull(dto.getJd());
                } else if (twoD.contains(promotionPlan.getPlatformName())) {
                    discountSingleD = bdNull(dto.getProductPromotion())
                            .add(bdNull(dto.getNewCustomer()))
                            .add(bdNull(dto.getOldCustomer()))
                            .add(bdNull(dto.getLargeDateProcess()))
                            .add(bdNull(dto.getHighTurnover()))
                            .add(bdNull(dto.getUneven()))
                            .add(bdNull(dto.getTiktokMaster()))
                            .add(bdNull(dto.getPlatformGrossProtection()));
                } else if (threeD.contains(promotionPlan.getPlatformName())) {
                    discountSingleD = bdNull(dto.getDistributionBaseTen())
                            .add(bdNull(dto.getDistributionBaseMonth()))
                            .add(bdNull(dto.getMonthGoalAchievement()))
                            .add(bdNull(dto.getPrePack()))
                            .add(bdNull(dto.getStaffFee()))
                            .add(bdNull(dto.getPutFee()))
                            .add(bdNull(dto.getLogisticsSupport()))
                            .add(bdNull(dto.getYearGoalAchievement()))
                            .add(bdNull(dto.getTakeHomePricePolicyFee()));
                    discountSingleR = bdNull(dto.getPlatformService())
                            .add(bdNull(dto.getPlatformRebate()))
                            .add(bdNull(dto.getPlatformCommission()));
                } else if (fourD.contains(promotionPlan.getPlatformName())) {
                    discountSingleD = bdNull(dto.getProductPromotion())
                            .add(bdNull(dto.getNewCustomer()))
                            .add(bdNull(dto.getOldCustomer()))
                            .add(bdNull(dto.getLargeDateProcess()))
                            .add(bdNull(dto.getHighTurnover()))
                            .add(bdNull(dto.getUneven()))
                            .add(bdNull(dto.getTiktokMaster()))
                            .add(bdNull(dto.getPlatformService()));
                    discountSingleR = bdNull(dto.getPlatformService())
                            .add(bdNull(dto.getPlatformRebate()))
                            .add(bdNull(dto.getPlatformCommission()));
                } else {
                    discountSingleD = bdNull(dto.getProductPromotion())
                            .add(bdNull(dto.getNewCustomer()))
                            .add(bdNull(dto.getOldCustomer()))
                            .add(bdNull(dto.getLargeDateProcess()))
                            .add(bdNull(dto.getHighTurnover()))
                            .add(bdNull(dto.getUneven()))
                            .add(bdNull(dto.getTiktokMaster()));
                }

                //销管报销
                if (oneR.contains(promotionPlan.getPlatformName())) {
                    discountSingleR = bdNull(dto.getProductPromotion())
                            .add(bdNull(dto.getNewCustomer()))
                            .add(bdNull(dto.getOldCustomer()))
                            .add(bdNull(dto.getLargeDateProcess()))
                            .add(bdNull(dto.getHighTurnover()))
                            .add(bdNull(dto.getUneven()))
                            .add(bdNull(dto.getTiktokMaster()))
                            .add(bdNull(dto.getPlatformGrossProtection()))
                            .add(bdNull(dto.getSaleCommission()));
                } else if (twoR.contains(promotionPlan.getPlatformName())) {
                    discountSingleR = channelPromotionFee.multiply(ratio);
                    platformService = bdNull(dto.getPlatformService()).divide(new BigDecimal("1.06"), 2, RoundingMode.HALF_UP);
                } else if (threeR.contains(promotionPlan.getPlatformName())) {
                    discountSingleR = bdNull(bdNull(dto.getPlatformRebate()))
                            .add(bdNull(dto.getPlatformCommission()));
                } else {
                    discountSingleR = bdNull(dto.getPlatformService())
                            .add(bdNull(dto.getPlatformRebate()))
                            .add(bdNull(dto.getPlatformCommission()));
                }

                Map<String, BigDecimal> rrMap = customerRRMap.get(dto.getCustomerCode());
                BigDecimal redInvoice = BigDecimal.ZERO;
                BigDecimal reimburse = BigDecimal.ZERO;
                if (rrMap != null) {
                    redInvoice = rrMap.get("redInvoice");
                    reimburse = rrMap.get("reimburse");
                }
                dto.setDiscount(discountSingleD.add(
                        redInvoice.multiply(ratio)).setScale(2, RoundingMode.HALF_UP));

                discountSingleR = discountSingleR.divide(new BigDecimal("1.06"), 2, RoundingMode.HALF_UP);
                dto.setSaleReimburse(discountSingleR.add(
                        platformService).add(
                        reimburse.divide(new BigDecimal("1.06"), 2, RoundingMode.HALF_UP).multiply(ratio)).setScale(2, BigDecimal.ROUND_HALF_UP));
            }
            temp.addAll(dtoList);
        }
        currentMonthSaleDtos = temp;
        BigDecimal finalLogisticsTotal = logisticsTotal;
        BigDecimal finalAdminHumanTotal = adminHumanTotal;
        currentMonthSaleDtos.forEach(e -> {
            //预计折前销售额（元）：自动计算：组合数量*平台供货价*预计销量（箱）
            e.setEstimatedAmountBefore(e.getCombinationQuantity().multiply(e.getPlatformSupplyPrice()).multiply(e.getEstimatedSalesBox()).setScale(2, RoundingMode.HALF_UP));
            //京东采购返（元）	"IF平台=“京东商城”才计算该字段，逻辑为：平台供货价*预计销量（箱）*组合数量*0.06"
            if ("京东商城".equals(promotionPlan.getPlatformName())) {
                e.setJd(e.getEstimatedAmountBefore().multiply(new BigDecimal("0.06")).setScale(2, RoundingMode.HALF_UP));
            }
            //分摊比例
            BigDecimal ratio = e.getEstimatedAmountBefore().divide(discountBeforeTotal, 6, BigDecimal.ROUND_HALF_UP);
            e.setLogistics(getLogistics(promotionPlan, finalLogisticsTotal, e.getEstimatedAmountBefore(), ratio, e.getCustomerCode(), e.getStartDate(), "sale"));

            e.setAdminHuman(finalAdminHumanTotal.multiply(ratio).setScale(2, RoundingMode.HALF_UP));
            currentMonthSaleService.calculationFee(e, promotionPlan.getBusinessModelCode());
        });
        promotionPlan.setCurrentMonthSaleDtos(currentMonthSaleDtos);
    }

    /**
     * 当月送货计算折扣、销管报销、行政+人力
     *
     * @param promotionPlan
     * @param cacheKeyDelivery
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    @Override
    public void calculationCurrentMonthDeliveryFee(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyPurchase, String cacheKeyDelivery, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel = createValidate(promotionPlan);
        getCacheList2(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);

        monthDeliveryFee(promotionPlan);
        currentMonthDeliveryService.clearCache(cacheKeyDelivery);
        currentMonthDeliveryService.addListCache(cacheKeyDelivery, promotionPlan.getCurrentMonthDeliveryDtos());
    }

    @Override
    public List<PromotionPlanVo> findByCodeList(List<String> codeList) {
        List<PromotionPlanEntity> entityList = promotionPlanRepository.findByCodeList(codeList);
        return (List<PromotionPlanVo>) nebulaToolkitService.copyCollectionByWhiteList(entityList, PromotionPlanEntity.class, PromotionPlanVo.class, LinkedHashSet.class, ArrayList.class);
    }

    @Override
    public Page<PromotionPlanForEventPrepaymentVo> findPromotionPlanPageListForEventPrepayment(Pageable pageable, PromotionPlanForEventPrepaymentDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        Page<PromotionPlanForEventPrepaymentVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (Objects.isNull(dto)) {
            dto = new PromotionPlanForEventPrepaymentDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.promotionPlanRepository.findPromotionPlanPageListForEventPrepayment(page, dto);
    }

    @Override
    public int findTotalByConditionsGeneral(PromotionPlanDto promotionPlanDto) {
        return this.generalExpensesRepository.getTotalNum(promotionPlanDto);
    }

    @Override
    public List<GeneralExpensesVo> findListByDetailCodeGeneral(Set<String> activityDetailCodes) {
        List<GeneralExpensesEntity> list = generalExpensesRepository.findListByExpensesCodes(activityDetailCodes);
        Validate.isTrue(!CollectionUtils.isEmpty(list), "未找到对应的费用申请");
        return (List<GeneralExpensesVo>) nebulaToolkitService.copyCollectionByWhiteList(list, GeneralExpensesEntity.class, GeneralExpensesVo.class, LinkedHashSet.class, ArrayList.class);
    }

    @Override
    public BigDecimal getMinActivityBasePrice(CurrentMonthSaleDto currentMonthSaleDto) {
        return currentMonthSaleRepository.getMinActivityBasePrice(currentMonthSaleDto);
    }

    @Override
    public List<PromotionPlanVo> findByDateConditions(PromotionPlanDto promotionPlanDto) {
        return this.promotionPlanRepository.findByDateConditions(promotionPlanDto);
    }

    @Override
    public Page<GeneralExpensesVo> findCanAutoAuditItemPage(Pageable pageable, AutoAuditParamsDto autoAuditParams) {

        Page<GeneralExpensesVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.generalExpensesRepository.findCanAutoAuditItemPage(page,autoAuditParams);
    }

    @Override
    public void updateAutoAuditFlag(List<String> activityDetailCodes, String falg) {
        if(CollectionUtils.isEmpty(activityDetailCodes)){
            return;
        }
        this.generalExpensesRepository.updateAutoAuditFlag(activityDetailCodes,falg);
    }

    private void monthDeliveryFee(PromotionPlanDto promotionPlan) {

        List<CurrentMonthSaleDto> currentMonthSaleDtos = promotionPlan.getCurrentMonthSaleDtos() == null ? new ArrayList<>() : promotionPlan.getCurrentMonthSaleDtos();
        List<CurrentMonthSaleDto> newCurrentMonthSaleDtos = (List<CurrentMonthSaleDto>) nebulaToolkitService.copyCollectionByWhiteList(currentMonthSaleDtos, CurrentMonthSaleDto.class, CurrentMonthSaleDto.class, LinkedHashSet.class, ArrayList.class);
        List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos = promotionPlan.getCurrentMonthDeliveryDtos() == null ? new ArrayList<>() : promotionPlan.getCurrentMonthDeliveryDtos();
        List<GeneralExpensesDto> generalExpensesDtos = promotionPlan.getGeneralExpensesDtos() == null ? new ArrayList<>() : promotionPlan.getGeneralExpensesDtos();
        List<OtherExpensesDto> otherExpensesDtos = promotionPlan.getOtherExpensesDtos() == null ? new ArrayList<>() : promotionPlan.getOtherExpensesDtos();
        List<PurchaseSaleDto> purchaseSaleDtos = promotionPlan.getPurchaseSaleDtos() == null ? new ArrayList<>() : promotionPlan.getPurchaseSaleDtos();

        Map<String, List<DictDataVo>> dictTypeCodeMap = dictDataVoService.findByDictTypeCodeList(Arrays.asList(PromotionPlanConstant.DISCOUNTS2, PromotionPlanConstant.TPM_SALES_MANAGEMENT_REIMBURSEMENT2));
        Map<String, DictDataVo> deliveryDiscountMap = dictTypeCodeMap.get(PromotionPlanConstant.DISCOUNTS2).stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        Map<String, DictDataVo> deliveryReimburseMap = dictTypeCodeMap.get(PromotionPlanConstant.TPM_SALES_MANAGEMENT_REIMBURSEMENT2).stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        List<String> oneD = deliveryDiscountMap.get(PromotionPlanConstant.ONE).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> twoD = deliveryDiscountMap.get(PromotionPlanConstant.TWO).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> oneR = deliveryReimburseMap.get(PromotionPlanConstant.ONE).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> twoR = deliveryReimburseMap.get(PromotionPlanConstant.TWO).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());

        //折扣	折扣=单品折扣+分摊折扣（费用申请页中手工增加的结案形式为“红字发票”的费用合计后进行分摊）
        //分摊折扣=【费用申请中手工添加或者导入的同样客户的费用行中结案形式为“红字发票”的行申请金额汇总*当月送货中预计销售额/当月送货中预计销售额汇总】
        //单品折扣逻辑如下：
        //1、如果平台=京东商城，单品折扣=【同一个产品的当月销售中的京东采购返】+【（该客户当月销售里面有产品，但是当月送货没有产品的的行上的“京东采购返”汇总）*(当月送货中预计销售额/当月送货中预计销售额汇总)】
        //2、如果平台=天猫超市，单品折扣=【同一个产品的当月送货页面的采购返点】+【当月销售的（产品促销+新客专享+老客留存+大日期+高周转+仓间不均+达人佣金（抖音）+平台毛保+销售返点）】+【（该客户当月销售里面有产品，但是当月送货没有产品的的行上的“产品促销+新客专享+老客留存+大日期+高周转+仓间不均+达人佣金（抖音）+平台毛保+销售返点”汇总）*(当月送货中预计销售额/当月送货中预计销售额汇总)】
        //
        //3、其他情况：
        //单品折扣=当月销售的【产品促销+新客专享+老客留存+大日期+高周转+仓间不均+达人佣金（抖音）】

        //销管报销（元）	销管报销=单品报销金额+分摊的报销金额（费用申请页中手工增加的结案形式为“报销”的费用分摊金额）
        //分摊报销=【费用申请中手工添加或者导入的同一个客户的费用行中结案形式为“报销”的行申请金额汇总*当月送货中预计销售额/当月送货中预计销售额汇总】
        //单品报销金额细化逻辑如下：
        //1、如果平台=天猫超市，单品报销=【【该产品当月送货中的渠道推广费】+ 当月销售中平台服务费汇总*(当月送货中预计销售额/当月送货中预计销售额汇总)/1.06
        //2、如果平台=京东商城，单品报销=【【当月销售的（产品促销+新客专享+老客留存+大日期+达人佣金（抖音）+高周转+仓间不均+平台毛保+销售返点）】+【（该客户当月销售里面有产品，但是当月送货没有产品的行上的“产品促销+新客专享+老客留存+大日期+达人佣金（抖音）+高周转+仓间不均+平台毛保+销售返点”汇总）*(当月送货中预计销售额/当月送货中预计销售额汇总)】】/1.06
        //3、其他平台：
        //单品报销=当月销售中的（平台服务费+平台返点费用+平台佣金扣点）/1.06

        //其他费用中的（行政费用规划+人力成本规划）*该产品在当月送货页面的预计折前销售额合计/当月送货中所有行的预计折前销售额合计

        //物流费用（元）= 【用行上的客户匹配运费价格表的运费率*当月销售中的预计折前销售额】+【其他费用录入中的（物流费用-规划）*该产品在当月销售页面的预计折前销售额/预计折前销售额合计】

        //红字发票汇总
        BigDecimal redInvoice = BigDecimal.ZERO;
        //报销汇总
        BigDecimal reimburse = BigDecimal.ZERO;
        //当月送货中预计销售额汇总
        BigDecimal estimatedAmountTotal = currentMonthDeliveryDtos.stream().map(e -> bdNull(e.getEstimatedAmount()))
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //采销库存中费用池汇总
        BigDecimal feeTotal = purchaseSaleDtos.stream().map(e -> bdNull(e.getFeePoolDifference())
                .add(bdNull(e.getFeePoolPut()))
                .add(bdNull(e.getFeePoolGrossProtection()))
                .add(bdNull(e.getFeePoolSaleCommission()))
                .add(bdNull(e.getFeePoolPurchaseRebate()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        //其他费用中人力+行政汇总
        BigDecimal adminHumanTotal = BigDecimal.ZERO;
        //物流规划汇总
        BigDecimal logisticsTotal = BigDecimal.ZERO;
        for (OtherExpensesDto dto : otherExpensesDtos) {
            adminHumanTotal = adminHumanTotal.add(bdNull(dto.getAdminAmountPlan())
                    .add(bdNull(dto.getHumanAmountPlan())));
            logisticsTotal = logisticsTotal.add(bdNull(dto.getLogisticsAmountPlan()));
        }

        Validate.isTrue(BigDecimal.ZERO.compareTo(estimatedAmountTotal) < 0, "当月送货预计销售额汇总必须大于0");

        for (GeneralExpensesDto dto : generalExpensesDtos) {
            if (Boolean.TRUE.equals(dto.getBeGenerate())) {
                continue;
            }
            if (PromotionPlanConstant.RED_INVOICE.equals(dto.getAuditWayName())) {
                redInvoice = redInvoice.add(dto.getApplyAmount());
            }
            if (PromotionPlanConstant.REIMBURSE.equals(dto.getAuditWayName())) {
                reimburse = reimburse.add(dto.getApplyAmount());
            }
        }

        //当月销售当月销售中平台服务费汇总
        BigDecimal plateformServiceSum = BigDecimal.ZERO;
        if (twoR.contains(promotionPlan.getPlatformName())) {
            plateformServiceSum = newCurrentMonthSaleDtos.stream().map(e -> bdNull(e.getPlatformService())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }

        //获取当月销售里面有产品，但是当月送货没有产品的数据
        Set<String> productSet = currentMonthDeliveryDtos.stream().map(e -> e.getProductCode()).collect(Collectors.toSet());
        List<CurrentMonthSaleDto> subCurrentMonthSaleDtos = Lists.newArrayList();
        Iterator<CurrentMonthSaleDto> iterator = newCurrentMonthSaleDtos.iterator();
        while (iterator.hasNext()){
            CurrentMonthSaleDto e = iterator.next();
            if (!productSet.contains(e.getProductCode())){
                subCurrentMonthSaleDtos.add(e);
                iterator.remove();
            }
        }
        //不同产品
        BigDecimal discountSub = BigDecimal.ZERO;
        BigDecimal saleReimburseSub = BigDecimal.ZERO;
        Map<String, BigDecimal> map = new HashMap<>();
        map.put("discount", discountSub);
        map.put("saleReimburse", saleReimburseSub);
        for (CurrentMonthSaleDto dto : subCurrentMonthSaleDtos) {
            sumDiscountSaleReimburse(map, dto, promotionPlan.getPlatformName(), oneD, twoD, oneR, twoR);
        }
        discountSub = map.get("discount");
        saleReimburseSub = map.get("saleReimburse");
        for (CurrentMonthDeliveryDto cdd : currentMonthDeliveryDtos) {
            BigDecimal discount = BigDecimal.ZERO;
            BigDecimal saleReimburse = BigDecimal.ZERO;
            Map<String, BigDecimal> mapSale = new HashMap<>();
            mapSale.put("discount", discount);
            mapSale.put("saleReimburse", saleReimburse);

            //分摊比例
            BigDecimal ratio = cdd.getEstimatedAmount().divide(estimatedAmountTotal, 6, BigDecimal.ROUND_HALF_UP);

            //相同产品
            for (CurrentMonthSaleDto dto : newCurrentMonthSaleDtos) {
                if (!cdd.getProductCode().equals(dto.getProductCode())) {
                    continue;
                }
                sumDiscountSaleReimburse(mapSale, dto, promotionPlan.getPlatformName(), oneD, twoD, oneR, twoR);
            }
            discount = mapSale.get("discount");
            saleReimburse = mapSale.get("saleReimburse");
            BigDecimal plateformService = BigDecimal.ZERO;
            if (twoD.contains(promotionPlan.getPlatformName())) {
                //同一个产品的当月送货页面的采购返点
                BigDecimal deliveryPurchase = bdNull(cdd.getPurchaseRebate());
                discount = discount.add(deliveryPurchase);
            }
            if (twoR.contains(promotionPlan.getPlatformName())) {
                //当月送货中的渠道推广费
                saleReimburse = saleReimburse.add(bdNull(cdd.getChannelPromotionFee()));
                plateformService = plateformServiceSum.multiply(ratio).divide(new BigDecimal(1.06), 2, BigDecimal.ROUND_HALF_UP);
            }
            //销管报销/1.06
            saleReimburse = saleReimburse.divide(new BigDecimal(1.06), 2, BigDecimal.ROUND_HALF_UP);
            BigDecimal saleReimburseSubNew = saleReimburseSub.divide(new BigDecimal(1.06), 2, BigDecimal.ROUND_HALF_UP);
            log.info("========================================当月送货重新计算损益");
            log.info("产品编码：" + cdd.getProductCode());
            log.info("当条送货的比例ratio：" + ratio);
            log.info("总的红字发票redInvoice：" + redInvoice);
            log.info("相同产品的单品折扣discount：" + discount);
            log.info("不同产品的当月销售总折扣discountSub：" + discountSub);
            cdd.setDiscount(discount.add(
                    redInvoice.multiply(ratio))
                    .add(discountSub.multiply(ratio)).setScale(2, BigDecimal.ROUND_HALF_UP));

            log.info("相同产品的单品报销saleReimburse：" + saleReimburse);
            log.info("当前比例平台服务费/1.06plateformService：" + plateformService);
            log.info("报销汇总reimburse：" + reimburse);
            log.info("采销库存中费用池汇总feeTotal：" + feeTotal);
            log.info("不同产品的当月销售总报销saleReimburseSubNew：" + saleReimburseSubNew);
            log.info("========================================当月送货重新计算损益");
            cdd.setSaleReimburse(saleReimburse.add(plateformService).add(
                    (reimburse.add(feeTotal)).divide(new BigDecimal("1.06"), 2, BigDecimal.ROUND_HALF_UP).multiply(ratio))
                    .add(saleReimburseSubNew.multiply(ratio)).setScale(2, BigDecimal.ROUND_HALF_UP));
            cdd.setAdminHuman(adminHumanTotal.multiply(ratio).setScale(2, BigDecimal.ROUND_HALF_UP));

            cdd.setLogistics(getLogistics(promotionPlan, logisticsTotal, cdd.getEstimatedAmount(), ratio, cdd.getCustomerCode(), cdd.getStartDate(), "delivery"));
        }


        currentMonthDeliveryDtos.forEach(e -> currentMonthDeliveryService.calculationFee(e, promotionPlan.getPlatformName()));
        promotionPlan.setCurrentMonthDeliveryDtos(currentMonthDeliveryDtos);
    }

    /**
     * 计算物流费用
     *
     * @param promotionPlan
     * @param otherLogisticsSum
     * @param estimatedAmount
     * @param ratio
     * @param customerCode
     * @param startDate
     * @param type
     * @return
     */
    private BigDecimal getLogistics(PromotionPlanDto promotionPlan, BigDecimal otherLogisticsSum, BigDecimal estimatedAmount, BigDecimal ratio,
                                    String customerCode, Date startDate, String type) {
        BigDecimal logistics = BigDecimal.ZERO;
        if ("sale".equals(type)) {
            //查询运费价格管理运费费率
            TpmFreightChargeMaintenanceDto fcmDto = new TpmFreightChargeMaintenanceDto();
            fcmDto.setCustomerCode(customerCode);
            fcmDto.setPlatformCode(promotionPlan.getPlatformCode());
            fcmDto.setSalesOrgCode(promotionPlan.getSalesOrgCode());
            fcmDto.setEffectiveDate(startDate);
            log.info("=======运费价格管理运费费率请求参数：" + JSONObject.toJSONString(fcmDto));
            Page<TpmFreightChargeMaintenanceVo> voPage = tpmFreightChargeMaintenanceService.findByConditions(null, fcmDto);
            log.info("=======运费价格管理运费费率返回参数：" + JSONArray.toJSONString(voPage));
            if (voPage.getTotal() > 0) {
                logistics = voPage.getRecords().get(0).getPrice().multiply(bdNull(estimatedAmount)).setScale(2, BigDecimal.ROUND_HALF_UP);
            }
        }
        return logistics.add(otherLogisticsSum.multiply(ratio)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 汇总计算当月销售折扣与报销
     *
     * @param map
     * @param dto
     * @param platformName
     */
    private void sumDiscountSaleReimburse(Map<String, BigDecimal> map, CurrentMonthSaleDto dto, String platformName,
                                          List<String> oneD, List<String> twoD, List<String> oneR, List<String> twoR) {
        BigDecimal discount = map.get("discount");
        BigDecimal saleReimburse = map.get("saleReimburse");
        //单品折扣（折扣）
        BigDecimal discountSingleD;
        //单品折扣（销管报销）
        BigDecimal discountSingleR = BigDecimal.ZERO;
        if (oneD.contains(platformName)) {
            discountSingleD = bdNull(dto.getJd());
        } else if (twoD.contains(platformName)) {
            discountSingleD = bdNull(dto.getProductPromotion())
                    .add(bdNull(dto.getNewCustomer()))
                    .add(bdNull(dto.getOldCustomer()))
                    .add(bdNull(dto.getLargeDateProcess()))
                    .add(bdNull(dto.getHighTurnover()))
                    .add(bdNull(dto.getUneven()))
                    .add(bdNull(dto.getTiktokMaster()))
                    .add(bdNull(dto.getPlatformGrossProtection()))
                    .add(bdNull(dto.getSaleCommission()));
        } else {
            discountSingleD = bdNull(dto.getProductPromotion())
                    .add(bdNull(dto.getNewCustomer()))
                    .add(bdNull(dto.getOldCustomer()))
                    .add(bdNull(dto.getLargeDateProcess()))
                    .add(bdNull(dto.getHighTurnover()))
                    .add(bdNull(dto.getUneven()))
                    .add(bdNull(dto.getTiktokMaster()));
        }

        if (oneR.contains(platformName)) {
            discountSingleR = bdNull(dto.getProductPromotion())
                    .add(bdNull(dto.getNewCustomer()))
                    .add(bdNull(dto.getOldCustomer()))
                    .add(bdNull(dto.getLargeDateProcess()))
                    .add(bdNull(dto.getHighTurnover()))
                    .add(bdNull(dto.getUneven()))
                    .add(bdNull(dto.getTiktokMaster()))
                    .add(bdNull(dto.getPlatformGrossProtection()))
                    .add(bdNull(dto.getSaleCommission()));
        } else if (twoR.contains(platformName)) {

        } else {
            discountSingleR = bdNull(dto.getPlatformService())
                    .add(bdNull(dto.getPlatformRebate()))
                    .add(bdNull(dto.getPlatformCommission()));
        }

        discount = discount.add(discountSingleD);
        saleReimburse = saleReimburse.add(discountSingleR);
        map.put("discount", discount);
        map.put("saleReimburse", saleReimburse);
    }

    private BigDecimal bdNull(BigDecimal b) {
        return b == null ? BigDecimal.ZERO : b;
    }

    /**
     * vo转换
     *
     * @param cahchResult
     * @return
     */
    List<PromotionPlanResultVoStr> voChange(LinkedHashMap<String, PromotionPlanResultVo> cahchResult) {
        List<PromotionPlanResultVo> values = new ArrayList<>(cahchResult.values());
        List<PromotionPlanResultVoStr> strVoList = new ArrayList<>();
        cahchResult.forEach((k, v) -> {
            PromotionPlanResultVoStr strVo = new PromotionPlanResultVoStr()
                    .setProjectCode(v.getProjectCode())
                    .setProjectName(v.getProjectName());
            if (k.equals(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.PUT_RATE.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()) ||
                    k.equals(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode())) {
                strVo.setPlan(v.getPlan().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setPlanTotal(v.getPlanTotal().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setContemporaneous(bdNull(v.getContemporaneous()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setContemporaneousTotal(bdNull(v.getContemporaneousTotal()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setBudget(bdNull(v.getBudget()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setBudgetTotal(bdNull(v.getBudgetTotal()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setPlanVsContemporaneous(v.getPlanVsContemporaneous().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setPlanVsBudget(v.getPlanVsBudget().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setActualPlan(v.getActualPlan().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setActualPlanVsBudget(v.getActualPlanVsBudget().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%");
            } else {
                strVo.setPlan((v.getPlan() == null ? BigDecimal.ZERO : v.getPlan()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setPlanTotal((v.getPlanTotal() == null ? BigDecimal.ZERO : v.getPlanTotal()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setContemporaneous((v.getContemporaneous() == null ? BigDecimal.ZERO : v.getContemporaneous()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setContemporaneousTotal((v.getContemporaneousTotal() == null ? BigDecimal.ZERO : v.getContemporaneousTotal()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setBudget((v.getBudget() == null ? BigDecimal.ZERO : v.getBudget()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setBudgetTotal((v.getBudgetTotal() == null ? BigDecimal.ZERO : v.getBudgetTotal()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setPlanVsContemporaneous((v.getPlanVsContemporaneous() == null ? BigDecimal.ZERO : v.getPlanVsContemporaneous()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setPlanVsBudget((v.getPlanVsBudget() == null ? BigDecimal.ZERO : v.getPlanVsBudget()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setActualPlan((v.getActualPlan() == null ? BigDecimal.ZERO : v.getActualPlan()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setActualPlanVsBudget((v.getActualPlanVsBudget() == null ? BigDecimal.ZERO : v.getActualPlanVsBudget()).setScale(3, RoundingMode.HALF_UP).toString());
            }
            strVoList.add(strVo);
        });
        return strVoList;
    }

    /**
     * 结果呈现计算
     *
     * @param promotionPlan
     * @param currentMonthSaleDtos
     * @param currentMonthDeliveryDtos
     * @param purchaseSaleDtos
     * @param generalExpensesDtos
     * @param otherExpensesDtos
     * @param businessModel
     * @return
     */
    public LinkedHashMap<String, PromotionPlanResultVo> getStoreResult(PromotionPlanDto promotionPlan, List<CurrentMonthSaleDto> currentMonthSaleDtos, List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos,
                                                                       List<PurchaseSaleDto> purchaseSaleDtos, List<GeneralExpensesDto> generalExpensesDtos, List<OtherExpensesDto> otherExpensesDtos, String businessModel, String type) {

        currentMonthSaleDtos = promotionPlan.getCurrentMonthSaleDtos() == null ? new ArrayList<>() : promotionPlan.getCurrentMonthSaleDtos();
        currentMonthDeliveryDtos = promotionPlan.getCurrentMonthDeliveryDtos() == null ? new ArrayList<>() : promotionPlan.getCurrentMonthDeliveryDtos();
        purchaseSaleDtos = promotionPlan.getPurchaseSaleDtos() == null ? new ArrayList<>() : promotionPlan.getPurchaseSaleDtos();
        generalExpensesDtos = promotionPlan.getGeneralExpensesDtos() == null ? new ArrayList<>() : promotionPlan.getGeneralExpensesDtos();
        otherExpensesDtos = promotionPlan.getOtherExpensesDtos() == null ? new ArrayList<>() : promotionPlan.getOtherExpensesDtos();

        return result(promotionPlan, currentMonthSaleDtos, currentMonthDeliveryDtos, purchaseSaleDtos, generalExpensesDtos, otherExpensesDtos, businessModel, type, promotionPlan.getPlatformName());
    }

    /**
     * 当前缓存结果
     *
     * @param promotionPlan
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyPurchase
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     * @return
     */
    public LinkedHashMap<String, PromotionPlanResultVo> getCahchResult(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther, String type) {
        String businessModel = createValidate(promotionPlan);

        //获取明细缓存
        getCacheList2(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
        List<CurrentMonthSaleDto> currentMonthSaleDtos = promotionPlan.getCurrentMonthSaleDtos() == null ? new ArrayList<>() : promotionPlan.getCurrentMonthSaleDtos();
        List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos = promotionPlan.getCurrentMonthDeliveryDtos() == null ? new ArrayList<>() : promotionPlan.getCurrentMonthDeliveryDtos();
        List<PurchaseSaleDto> purchaseSaleDtos = promotionPlan.getPurchaseSaleDtos() == null ? new ArrayList<>() : promotionPlan.getPurchaseSaleDtos();
        List<GeneralExpensesDto> generalExpensesDtos = promotionPlan.getGeneralExpensesDtos() == null ? new ArrayList<>() : promotionPlan.getGeneralExpensesDtos();
        List<OtherExpensesDto> otherExpensesDtos = promotionPlan.getOtherExpensesDtos() == null ? new ArrayList<>() : promotionPlan.getOtherExpensesDtos();

        return result(promotionPlan, currentMonthSaleDtos, currentMonthDeliveryDtos, purchaseSaleDtos, generalExpensesDtos, otherExpensesDtos, businessModel, type, promotionPlan.getPlatformName());
    }

    /**
     * 计算结果
     *
     * @param promotionPlan
     * @param currentMonthSaleDtos
     * @param currentMonthDeliveryDtos
     * @param purchaseSaleDtos
     * @param generalExpensesDtos
     * @param otherExpensesDtos
     * @param businessModel
     * @return
     */
    public LinkedHashMap<String, PromotionPlanResultVo> result(PromotionPlanDto promotionPlan, List<CurrentMonthSaleDto> currentMonthSaleDtos, List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos,
                                                               List<PurchaseSaleDto> purchaseSaleDtos, List<GeneralExpensesDto> generalExpensesDtos, List<OtherExpensesDto> otherExpensesDtos,
                                                               String businessModel, String type, String platformName) {
        LinkedHashMap<String, PromotionPlanResultVo> map = createPromotionPlanResultVoList(promotionPlan, type);

        resultPlan(currentMonthSaleDtos, currentMonthDeliveryDtos, purchaseSaleDtos, generalExpensesDtos, otherExpensesDtos, businessModel, map, type, platformName);
        resultProfitLoss(promotionPlan, businessModel, map, type);

        return map;
    }

    /**
     * 损益计算
     *
     * @param promotionPlan
     * @param businessModel
     * @param map
     */
    public void resultProfitLoss(PromotionPlanDto promotionPlan, String businessModel, LinkedHashMap<String, PromotionPlanResultVo> map, String type) {
        String month = DateUtil.format(promotionPlan.getStartDate(), "yyyy-MM");

        ActualProfitLossVo dtoA = new ActualProfitLossVo();
        BudgetProfitLossVo dtoB = new BudgetProfitLossVo();

        String customerCode;
        if (PromotionPlanConstant.FX.equals(businessModel)) {
            dtoA.setDepartmentCode(PromotionPlanConstant.FXYWB_CODE);
            dtoB.setDepartmentCode(PromotionPlanConstant.FXYWB_CODE);
            Validate.notBlank(promotionPlan.getCustomerProfitLossCode(), "所属预算客户必填！");
            customerCode = promotionPlan.getCustomerProfitLossCode();
        } else {
            customerCode = promotionPlan.getCustomerCode();
        }
        dtoA.setCustomerCode(customerCode);
        dtoB.setCustomerCode(customerCode);

        String[] split = month.split("-");
        String year = split[0];
        String yearBefore = String.valueOf(Integer.valueOf(split[0]) - 1);
        List<ActualProfitLossVo> aList = new ArrayList<>();
        List<BudgetProfitLossVo> bList = new ArrayList<>();

        if (StringUtils.isNotBlank(type)) {
            dtoA.setType(type);
            dtoB.setType(type);
            aList = actualProfitLossService.findProfitLoss(dtoA, getMonthList(yearBefore, split[1]));
            bList = budgetProfitLossService.findProfitLoss(dtoB, getMonthList(year, split[1]));
        }

        sumProfitLoss(aList, map, PromotionPlanConstant.ACTUAL, yearBefore + "-" + split[1], businessModel);
        sumProfitLoss(bList, map, PromotionPlanConstant.BUDGET, month, businessModel);
    }

    /**
     * 获取所属年份所有年月
     *
     * @param year
     * @param month
     * @return
     */
    private List<String> getMonthList(String year, String month) {
        List<String> monthList = new ArrayList<>();
        int monthInt = Integer.parseInt(month);
        for (int i = 1; i <= monthInt; i++) {
            if (i < 10) {
                monthList.add(year + "-0" + i);
            } else {
                monthList.add(year + "-" + i);
            }
        }
        return monthList;
    }

    /**
     * 损益汇总
     *
     * @param list
     * @param map
     * @param type
     * @param <T>
     */
    public <T> void sumProfitLoss(List<T> list, LinkedHashMap<String, PromotionPlanResultVo> map, String type, String month, String businessModel) {
        //吨数（吨）	销量（吨）
        //折前销售额（千元）	销售额
        //折后含税销售额（千元）	销售额-折扣
        //GMV（千元）	GMV（千元）
        //价格力度	价格力度
        //净收入（千元）	净收入+其他业务收入
        //成本（千元）	直接材料
        //净利润（千元）	净利润
        //折扣费用（千元）	销售费用_销管折扣(含税)
        //报销费用（千元）	销售费用_销管报销(含税)
        //消费者费用（千元）	消费者费用（千元）
        //渠道费用（千元）	渠道费用（千元）
        //投放费用（千元）	投放费用（千元）
        //平台运营费用（千元）	平台运营费用（千元）
        //费用池（千元）	费用池（千元）
        //市场费用（千元）	销售费用_市场报销（含税）
        //物流费用（千元）	运输装卸费用+销售费用_仓储费用
        //行政管理费用（千元）	销售费用_行政性费用+管理费用+研发费用
        //人力成本（千元）	销售费用_行政性费用(人力成本)+管理费用(人力成本)+研发费用(人力成本)

        //毛利率	（同期净收入-同期成本）/同期净收入
        //折扣费用率	折扣费用/折后含税销售额
        //报销费用率	同期报销费用/同期折后含税销售额
        //消费者费用率	同期消费者费用/同期折后含税销售额
        //渠道费用率	同期渠道费用/同期折后含税销售额
        //投放费用率	同期投放费用/同期折后含税销售额
        //平台运营费用率	同期平台运营费用/同期折后含税销售额
        //专项费用率	采销：（同期消费者费用+同期渠道费用+同期投放费用+同期平台运营费用+同期费用池）/同期折后含税销售额，其他：（同期消费者费用+同期渠道费用+同期投放费用+同期平台运营费用）/同期折后含税销售额
        //物流费用率	同期物流费用/同期净收入
        //物流费用单吨（元/吨）	同期物流费用*1000/吨数
        //净利率	同期净利润/同期净收入

        //吨数（吨）
        BigDecimal ton = BigDecimal.ZERO;
        //折前销售额（千元）
        BigDecimal discountBeforeSale = BigDecimal.ZERO;
        //折后销售额（千元）
        BigDecimal discountAfterSale = BigDecimal.ZERO;
        //GMV
        BigDecimal gmv = BigDecimal.ZERO;
        //价格力度
        BigDecimal intensity = BigDecimal.ZERO;
        //净收入（千元）
        BigDecimal netIncome = BigDecimal.ZERO;
        //成本（千元）
        BigDecimal cost = BigDecimal.ZERO;
        //净利润（千元）
        BigDecimal netProfit = BigDecimal.ZERO;
        //折扣费用（千元）
        BigDecimal discount = BigDecimal.ZERO;
        //报销费用（千元）
        BigDecimal reimbursement = BigDecimal.ZERO;
        //消费者费用（千元）
        BigDecimal consumer = BigDecimal.ZERO;
        //渠道费用（千元）
        BigDecimal channel = BigDecimal.ZERO;
        //投放费用（千元）
        BigDecimal put = BigDecimal.ZERO;
        //平台运营费用（千元）
        BigDecimal platformOperate = BigDecimal.ZERO;
        //费用池（千元）
        BigDecimal feePool = BigDecimal.ZERO;
        //市场费用（千元）
        BigDecimal market = BigDecimal.ZERO;
        //物流费用（千元）
        BigDecimal logistics = BigDecimal.ZERO;
        //行政管理费用（千元）
        BigDecimal admin = BigDecimal.ZERO;
        //人力成本（千元）
        BigDecimal human = BigDecimal.ZERO;

        List<ProfitLossVo> voList = (List<ProfitLossVo>) list;
        Map<String, List<ProfitLossVo>> mapMonth = voList.stream().collect(Collectors.groupingBy(e -> e.getYearMonthly()));

        List<ProfitLossVo> profitLossMonth = mapMonth.get(month);
        if (!CollectionUtils.isEmpty(profitLossMonth)) {
            for (ProfitLossVo vo : profitLossMonth) {
                ton = ton.add(bdNull(vo.getSalesTon()));
                discountBeforeSale = discountBeforeSale.add(bdNull(vo.getSaleAmount()));
                discountAfterSale = discountAfterSale.add(bdNull(vo.getSaleAmount())
                        .subtract(bdNull(vo.getDiscountSub())));
                gmv = gmv.add(bdNull(vo.getGmv()));
                intensity = intensity.add(bdNull(vo.getIntensity()));
                netIncome = netIncome.add(bdNull(vo.getNetIncome())
                        .add(bdNull(vo.getOthersAdd())));
                cost = cost.add(bdNull(vo.getDirectMaterial()));
                netProfit = netProfit.add(bdNull(vo.getNetProfit()));
                discount = discount.add(bdNull(vo.getSaleFeeSaleDiscount()));
                reimbursement = reimbursement.add(bdNull(vo.getSaleFeeReimburse()));
                consumer = consumer.add(bdNull(vo.getConsumer()));
                channel = channel.add(bdNull(vo.getChannel()));
                put = put.add(bdNull(vo.getPut()));
                platformOperate = platformOperate.add(bdNull(vo.getPlatformOperate()));
                feePool = feePool.add(bdNull(vo.getFeePool()));
                market = market.add(bdNull(vo.getSaleFeeMarketReimburseSub()));
                logistics = logistics.add(bdNull(vo.getTransportHandling())
                        .add(bdNull(vo.getSaleFeeInventory())));
                admin = admin.add(bdNull(vo.getSaleFeeAdmin())
                        .add(bdNull(vo.getManage()))
                        .add(bdNull(vo.getDevelopment())));
                human = human.add(bdNull(vo.getSaleFeeAdminHuman())
                        .add(bdNull(vo.getManageHuman()))
                        .add(bdNull(vo.getDevelopmentHuman())));
            }
            if (PromotionPlanConstant.BUDGET.equals(type)) {
                map.get(PromotionPlanResultProjectEnum.TON.getCode()).setBudget(ton);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setBudget(discountBeforeSale);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setBudget(discountAfterSale);
                map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setBudget(gmv);
                map.get(PromotionPlanResultProjectEnum.INTENSITY.getCode()).setBudget(intensity.divide(new BigDecimal(100), 3, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setBudget(netIncome);
                map.get(PromotionPlanResultProjectEnum.COST.getCode()).setBudget(cost);
                map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setBudget(netProfit);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setBudget(discount);
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setBudget(reimbursement);
                map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setBudget(consumer);
                map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setBudget(channel);
                map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setBudget(put);
                map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setBudget(platformOperate);
                map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setBudget(feePool);
                map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setBudget(market);
                map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setBudget(logistics);
                map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setBudget(admin);
                map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setBudget(human);

                map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setBudget(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        (netIncome.subtract(cost)).divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        discount.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        reimbursement.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        consumer.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        channel.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        put.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        platformOperate.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                BigDecimal specialCost = BigDecimal.ZERO;
                if (PromotionPlanConstant.CX.equals(businessModel)) {
                    specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                            (consumer.add(channel).add(put).add(platformOperate)).add(feePool).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
                } else {
                    specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                            (consumer.add(channel).add(put).add(platformOperate)).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
                }
                map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setBudget(specialCost);
                map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setBudget(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        logistics.divide(discountBeforeSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setBudget(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        logistics.divide(ton, 2, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setBudget(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        netProfit.divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
            } else {
                map.get(PromotionPlanResultProjectEnum.TON.getCode()).setContemporaneous(ton);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setContemporaneous(discountBeforeSale);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setContemporaneous(discountAfterSale);
                map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setContemporaneous(gmv);
                map.get(PromotionPlanResultProjectEnum.INTENSITY.getCode()).setContemporaneous(intensity.divide(new BigDecimal(100), 3, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setContemporaneous(netIncome);
                map.get(PromotionPlanResultProjectEnum.COST.getCode()).setContemporaneous(cost);
                map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setContemporaneous(netProfit);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setContemporaneous(discount);
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setContemporaneous(reimbursement);
                map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setContemporaneous(consumer);
                map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setContemporaneous(channel);
                map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setContemporaneous(put);
                map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setContemporaneous(platformOperate);
                map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setContemporaneous(feePool);
                map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setContemporaneous(market);
                map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setContemporaneous(logistics);
                map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setContemporaneous(admin);
                map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setContemporaneous(human);

                map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setContemporaneous(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        (netIncome.subtract(cost)).divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        discount.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        reimbursement.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        consumer.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        channel.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        put.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        platformOperate.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
                BigDecimal specialCost = BigDecimal.ZERO;
                if (PromotionPlanConstant.CX.equals(businessModel)) {
                    specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                            (consumer.add(channel).add(put).add(platformOperate)).add(feePool).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
                } else {
                    specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                            (consumer.add(channel).add(put).add(platformOperate)).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
                }
                map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setContemporaneous(specialCost);
                map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setContemporaneous(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        logistics.divide(discountBeforeSale, 4, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setContemporaneous(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        logistics.divide(ton, 2, BigDecimal.ROUND_HALF_UP));
                map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setContemporaneous(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        netProfit.divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
            }
        }

        //移除当月
        if (!CollectionUtils.isEmpty(profitLossMonth)) {
            voList.removeAll(profitLossMonth);
        }

        for (ProfitLossVo vo : voList) {
            ton = ton.add(bdNull(vo.getSalesTon()));
            discountBeforeSale = discountBeforeSale.add(bdNull(vo.getSaleAmount()));
            discountAfterSale = discountAfterSale.add(bdNull(vo.getSaleAmount())
                    .subtract(bdNull(vo.getDiscountSub())));
            gmv = gmv.add(bdNull(vo.getGmv()));
            intensity = intensity.add(bdNull(vo.getIntensity()));
            netIncome = netIncome.add(bdNull(vo.getNetIncome())
                    .add(bdNull(vo.getOthersAdd())));
            cost = cost.add(bdNull(vo.getDirectMaterial()));
            netProfit = netProfit.add(bdNull(vo.getNetProfit()));
            discount = discount.add(bdNull(vo.getSaleFeeSaleDiscount()));
            reimbursement = reimbursement.add(bdNull(vo.getSaleFeeReimburse()));
            consumer = consumer.add(bdNull(vo.getConsumer()));
            channel = channel.add(bdNull(vo.getChannel()));
            put = put.add(bdNull(vo.getPut()));
            platformOperate = platformOperate.add(bdNull(vo.getPlatformOperate()));
            feePool = feePool.add(bdNull(vo.getFeePool()));
            market = market.add(bdNull(vo.getSaleFeeMarketReimburseSub()));
            logistics = logistics.add(bdNull(vo.getTransportHandling())
                    .add(bdNull(vo.getSaleFeeInventory())));
            admin = admin.add(bdNull(vo.getSaleFeeAdmin())
                    .add(bdNull(vo.getManage()))
                    .add(bdNull(vo.getDevelopment())));
            human = human.add(bdNull(vo.getSaleFeeAdminHuman())
                    .add(bdNull(vo.getManageHuman()))
                    .add(bdNull(vo.getDevelopmentHuman())));
        }

        if (PromotionPlanConstant.BUDGET.equals(type)) {
            map.get(PromotionPlanResultProjectEnum.TON.getCode()).setBudgetTotal(ton);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setBudgetTotal(discountBeforeSale);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setBudgetTotal(discountAfterSale);
            map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setBudgetTotal(gmv);
            map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setBudgetTotal(netIncome);
            map.get(PromotionPlanResultProjectEnum.COST.getCode()).setBudgetTotal(cost);
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setBudgetTotal(netProfit);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setBudgetTotal(discount);
            map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setBudgetTotal(reimbursement);
            map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setBudgetTotal(consumer);
            map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setBudgetTotal(channel);
            map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setBudgetTotal(put);
            map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setBudgetTotal(platformOperate);
            map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setBudgetTotal(feePool);
            map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setBudgetTotal(market);
            map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setBudgetTotal(logistics);
            map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setBudgetTotal(admin);
            map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setBudgetTotal(human);

            map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setBudgetTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    (netIncome.subtract(cost)).divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    discount.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    reimbursement.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    consumer.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    channel.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    put.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    platformOperate.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            BigDecimal specialCost = BigDecimal.ZERO;
            if (PromotionPlanConstant.CX.equals(businessModel)) {
                specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        (consumer.add(channel).add(put).add(platformOperate)).add(feePool).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
            } else {
                specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        (consumer.add(channel).add(put).add(platformOperate)).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
            }
            map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setBudgetTotal(specialCost);
            map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setBudgetTotal(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    logistics.divide(discountBeforeSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setBudgetTotal(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    logistics.divide(ton, 2, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setBudgetTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    netProfit.divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
        } else {
            map.get(PromotionPlanResultProjectEnum.TON.getCode()).setContemporaneousTotal(ton);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setContemporaneousTotal(discountBeforeSale);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setContemporaneousTotal(discountAfterSale);
            map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setContemporaneousTotal(gmv);
            map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setContemporaneousTotal(netIncome);
            map.get(PromotionPlanResultProjectEnum.COST.getCode()).setContemporaneousTotal(cost);
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setContemporaneousTotal(netProfit);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setContemporaneousTotal(discount);
            map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setContemporaneousTotal(reimbursement);
            map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setContemporaneousTotal(consumer);
            map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setContemporaneousTotal(channel);
            map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setContemporaneousTotal(put);
            map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setContemporaneousTotal(platformOperate);
            map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setContemporaneousTotal(feePool);
            map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setContemporaneousTotal(market);
            map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setContemporaneousTotal(logistics);
            map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setContemporaneousTotal(admin);
            map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setContemporaneousTotal(human);

            map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setContemporaneousTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    (netIncome.subtract(cost)).divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    discount.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    reimbursement.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    consumer.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    channel.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    put.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    platformOperate.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
            BigDecimal specialCost = BigDecimal.ZERO;
            if (PromotionPlanConstant.CX.equals(businessModel)) {
                specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        (consumer.add(channel).add(put).add(platformOperate).add(feePool)).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
            } else {
                specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                        (consumer.add(channel).add(put).add(platformOperate)).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
            }
            map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setContemporaneousTotal(specialCost);
            map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setContemporaneousTotal(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    logistics.divide(discountBeforeSale, 4, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setContemporaneousTotal(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    logistics.divide(ton, 2, BigDecimal.ROUND_HALF_UP));
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setContemporaneousTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    netProfit.divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
        }

    }

    /**
     * 规划计算
     *
     * @param currentMonthSaleDtos
     * @param currentMonthDeliveryDtos
     * @param purchaseSaleDtos
     * @param generalExpensesDtos
     * @param otherExpensesDtos
     * @param businessModel
     * @param map
     */
    public void resultPlan(List<CurrentMonthSaleDto> currentMonthSaleDtos, List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos,
                           List<PurchaseSaleDto> purchaseSaleDtos, List<GeneralExpensesDto> generalExpensesDtos, List<OtherExpensesDto> otherExpensesDtos, String businessModel,
                           LinkedHashMap<String, PromotionPlanResultVo> map, String type, String platformName) {
        //吨数（吨）
        BigDecimal ton = BigDecimal.ZERO;
        //折前销售额（千元）
        BigDecimal discountBeforeSale = BigDecimal.ZERO;
        //折后销售额（千元）
        BigDecimal discountAfterSale = BigDecimal.ZERO;
        //GMV
        BigDecimal gmv = BigDecimal.ZERO;
        //价格力度
        BigDecimal intensity = BigDecimal.ZERO;
        //价格力度计算用
        BigDecimal intensityTemp = BigDecimal.ZERO;
        //猫超卡
        BigDecimal tmall = BigDecimal.ZERO;
        //净收入（千元）
        BigDecimal netIncome = BigDecimal.ZERO;
        //成本（千元）
        BigDecimal cost = BigDecimal.ZERO;
        //净利润（千元）
        BigDecimal netProfit = BigDecimal.ZERO;
        //折扣费用（千元）
        BigDecimal discount = BigDecimal.ZERO;
        //报销费用（千元）
        BigDecimal reimbursement = BigDecimal.ZERO;
        //消费者费用（千元）
        BigDecimal consumer = BigDecimal.ZERO;
        //渠道费用（千元）
        BigDecimal channel = BigDecimal.ZERO;
        //投放费用（千元）
        BigDecimal put = BigDecimal.ZERO;
        //平台运营费用（千元）
        BigDecimal platformOperate = BigDecimal.ZERO;
        //费用池（千元）
        BigDecimal feePool = BigDecimal.ZERO;
        //市场费用（千元）
        BigDecimal market = BigDecimal.ZERO;
        //物流费用（千元）
        BigDecimal logistics = BigDecimal.ZERO;
        //行政管理费用（千元）
        BigDecimal admin = BigDecimal.ZERO;
        //人力成本（千元）
        BigDecimal human = BigDecimal.ZERO;


        BigDecimal feePoolDifference = BigDecimal.ZERO;
        BigDecimal feePoolSaleCommission = BigDecimal.ZERO;
        BigDecimal feePoolGrossProtection = BigDecimal.ZERO;
        BigDecimal feePoolPut = BigDecimal.ZERO;
        BigDecimal feePoolPurchaseRebate = BigDecimal.ZERO;


        //费用申请
        BigDecimal consumerRD = BigDecimal.ZERO;
        BigDecimal channelRD = BigDecimal.ZERO;
        BigDecimal putRD = BigDecimal.ZERO;
        BigDecimal platformOperateRD = BigDecimal.ZERO;
        BigDecimal consumerOther = BigDecimal.ZERO;
        BigDecimal channelOther = BigDecimal.ZERO;
        BigDecimal putOther = BigDecimal.ZERO;
        BigDecimal platformOperateOther = BigDecimal.ZERO;
        //采购返点
        BigDecimal purchaseRebate = BigDecimal.ZERO;
        //销售返点
        BigDecimal saleCommission = BigDecimal.ZERO;
        for (GeneralExpensesDto dto : generalExpensesDtos) {
            if (PromotionPlanConstant.CONSUMER.equals(dto.getBudgetItemName1())) {
                if (PromotionPlanConstant.RED_INVOICE.equals(dto.getAuditWayName()) || PromotionPlanConstant.DISCOUNT.equals(dto.getAuditWayName())) {
                    consumerRD = consumerRD.add(dto.getApplyAmount());
                } else {
                    consumerOther = consumerOther.add(dto.getApplyAmount());
                }
            } else if (PromotionPlanConstant.CHANNEL.equals(dto.getBudgetItemName1())) {
                if (PromotionPlanConstant.RED_INVOICE.equals(dto.getAuditWayName()) || PromotionPlanConstant.DISCOUNT.equals(dto.getAuditWayName())) {
                    channelRD = channelRD.add(dto.getApplyAmount());
                } else {
                    channelOther = channelOther.add(dto.getApplyAmount());
                }
                if ("天猫超市".equals(platformName)) {
                    if ("采购返点".equals(dto.getBudgetItemName3())) {
                        purchaseRebate = purchaseRebate.add(dto.getApplyAmount());
                    } else if ("销售返点".equals(dto.getBudgetItemName3())) {
                        saleCommission = saleCommission.add(dto.getApplyAmount());
                    }
                }
            } else if (PromotionPlanConstant.PUT.equals(dto.getBudgetItemName1())) {
                if (PromotionPlanConstant.RED_INVOICE.equals(dto.getAuditWayName()) || PromotionPlanConstant.DISCOUNT.equals(dto.getAuditWayName())) {
                    putRD = putRD.add(dto.getApplyAmount());
                } else {
                    putOther = putOther.add(dto.getApplyAmount());
                }
            } else if (PromotionPlanConstant.PLATFORM_OPERATE.equals(dto.getBudgetItemName1())) {
                if (PromotionPlanConstant.RED_INVOICE.equals(dto.getAuditWayName()) || PromotionPlanConstant.DISCOUNT.equals(dto.getAuditWayName())) {
                    platformOperateRD = platformOperateRD.add(dto.getApplyAmount());
                } else {
                    platformOperateOther = platformOperateOther.add(dto.getApplyAmount());
                }
            }
            if ("猫超卡".equals(dto.getActivityFormName())) {
                tmall = tmall.add(dto.getApplyAmount());
            }
        }

        //当月销售公共计算
        for (CurrentMonthSaleDto dto : currentMonthSaleDtos) {
            if (Objects.isNull(dto.getCombinationQuantity())) {
                dto.setCombinationQuantity(BigDecimal.ZERO);
            }
            if (Objects.isNull(dto.getActivityBasePrice())) {
                dto.setActivityBasePrice(BigDecimal.ZERO);
            }
            if (Objects.isNull(dto.getEstimatedSalesBox())) {
                dto.setEstimatedSalesBox(BigDecimal.ZERO);
            }
            if (Objects.isNull(dto.getStandardRetailPrice())) {
                dto.setStandardRetailPrice(BigDecimal.ZERO);
            }

            gmv = gmv.add(dto.getCombinationQuantity()
                    .multiply(dto.getActivityBasePrice())
                    .multiply(dto.getEstimatedSalesBox()));

            intensityTemp = intensityTemp
                    .add(dto.getStandardRetailPrice()
                            .multiply(dto.getCombinationQuantity())
                            .multiply(dto.getEstimatedSalesBox()));
            logistics = logistics.add(dto.getLogistics() == null ? BigDecimal.ZERO : dto.getLogistics());
        }
        //预计销量（箱）销量*活动底价*组合数量/1000
        map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setPlan(gmv.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
        //价格力度 猫超：（GMV-费用申请中的猫超卡）/(零售价*组合数量*预计销量）。其他：GMV/(零售价*组合数量*预计销量汇总）
        map.get(PromotionPlanResultProjectEnum.INTENSITY.getCode()).setPlan(intensityTemp.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                (gmv.subtract(tmall)).divide(intensityTemp, 4, BigDecimal.ROUND_HALF_UP));
        //物流费用（千元）
        map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setPlan(logistics.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
        //采销
        if (PromotionPlanConstant.CX.equals(businessModel)) {
            if (PromotionPlanConstant.PAPER.equals(type)) {
                for (CurrentMonthDeliveryDto dto : currentMonthDeliveryDtos) {
                    ton = ton.add(dto.getEstimatedSalesTon() == null ? BigDecimal.ZERO : dto.getEstimatedSalesTon());
                    discountBeforeSale = discountBeforeSale.add(dto.getEstimatedAmount() == null ? BigDecimal.ZERO : dto.getEstimatedAmount());
                    netIncome = netIncome.add(dto.getNetIncome() == null ? BigDecimal.ZERO : dto.getNetIncome());

                    if (Objects.isNull(dto.getCombinationQuantity())) {
                        dto.setCombinationQuantity(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(dto.getEstimatedSalesBox())) {
                        dto.setEstimatedSalesBox(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(dto.getTaxRate())) {
                        dto.setTaxRate(BigDecimal.ZERO);
                    }

                    cost = cost.add(
                            (dto.getCostPrice() == null ? BigDecimal.ZERO : dto.getCostPrice()).multiply(dto.getCombinationQuantity()).multiply(dto.getEstimatedSalesBox())
                                    .divide(BigDecimal.ONE.add(bdNull(dto.getTaxRate())), 4, BigDecimal.ROUND_HALF_UP)
                    );
                    netProfit = netProfit.add(dto.getNetProfit() == null ? BigDecimal.ZERO : dto.getNetProfit());
                    if (Objects.isNull(dto.getDiscount())) {
                        dto.setDiscount(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(dto.getSaleReimburse())) {
                        dto.setSaleReimburse(BigDecimal.ZERO);
                    }
                    discount = discount.add(dto.getDiscount());
                    reimbursement = reimbursement.add(dto.getSaleReimburse());
                }
            } else {
                for (CurrentMonthSaleDto dto : currentMonthSaleDtos) {
                    ton = ton.add(dto.getEstimatedSalesTon() == null ? BigDecimal.ZERO : dto.getEstimatedSalesTon());
                    discountBeforeSale = discountBeforeSale.add(dto.getEstimatedAmountBefore() == null ? BigDecimal.ZERO : dto.getEstimatedAmountBefore());
                    netIncome = netIncome.add(dto.getNetIncome() == null ? BigDecimal.ZERO : dto.getNetIncome());
                    if (Objects.isNull(dto.getCombinationQuantity())) {
                        dto.setCombinationQuantity(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(dto.getEstimatedSalesBox())) {
                        dto.setEstimatedSalesBox(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(dto.getTaxRate())) {
                        dto.setTaxRate(BigDecimal.ZERO);
                    }
                    cost = cost.add(
                            (dto.getCostPrice() == null ? BigDecimal.ZERO : dto.getCostPrice()).multiply(dto.getCombinationQuantity()).multiply(dto.getEstimatedSalesBox())
                                    .divide(BigDecimal.ONE.add(bdNull(dto.getTaxRate())), 4, BigDecimal.ROUND_HALF_UP)
                    );
                    netProfit = netProfit.add(dto.getNetProfit() == null ? BigDecimal.ZERO : dto.getNetProfit());
                    if (Objects.isNull(dto.getDiscount())) {
                        dto.setDiscount(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(dto.getSaleReimburse())) {
                        dto.setSaleReimburse(BigDecimal.ZERO);
                    }
                    discount = discount.add(dto.getDiscount());
                    reimbursement = reimbursement.add(dto.getSaleReimburse());
                }
            }
            //当月送货中预计销量（吨）合计
            map.get(PromotionPlanResultProjectEnum.TON.getCode()).setPlan(ton);
            //当月送货中预计折前销售额（元）合计/1000
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setPlan(discountBeforeSale.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //（当月送货中的预计销售额-折扣）汇总/1000
            discountAfterSale = discountBeforeSale.subtract(discount);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setPlan(discountAfterSale.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //净收入-合计
            map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setPlan(netIncome.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //成本价*组合数量*预计销量（箱）/(1+税率)
            map.get(PromotionPlanResultProjectEnum.COST.getCode()).setPlan(cost.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //净利润-合计
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setPlan(netProfit.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));

            for (PurchaseSaleDto dto : purchaseSaleDtos) {
                feePoolDifference = feePoolDifference.add(bdNull(dto.getFeePoolDifference()));
                feePoolSaleCommission = feePoolSaleCommission.add(bdNull(dto.getFeePoolSaleCommission()));
                feePoolGrossProtection = feePoolGrossProtection.add(bdNull(dto.getFeePoolGrossProtection()));
                feePoolPut = feePoolPut.add(bdNull(dto.getFeePoolPut()));
                feePoolPurchaseRebate = feePoolPurchaseRebate.add(bdNull(dto.getFeePoolPurchaseRebate()));
            }

            if (PromotionPlanConstant.PAPER.equals(type)) {
                //（费用池-补差、费用池-销售返、费用池-毛保、费用池-投放合计）合计/1.06
                feePool = feePool.add(feePoolDifference)
                        .add(feePoolSaleCommission)
                        .add(feePoolGrossProtection)
                        .add(feePoolPut);
            }
            map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setPlan(feePool.divide(new BigDecimal("1.06"), 2, BigDecimal.ROUND_HALF_UP).divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //自营模式、分销模式
        } else if (PromotionPlanConstant.ZY.equals(businessModel) || PromotionPlanConstant.FX.equals(businessModel)) {
            for (CurrentMonthSaleDto dto : currentMonthSaleDtos) {
                ton = ton.add(dto.getEstimatedSalesTon() == null ? BigDecimal.ZERO : dto.getEstimatedSalesTon());
                discountBeforeSale = discountBeforeSale.add(dto.getEstimatedAmountBefore() == null ? BigDecimal.ZERO : dto.getEstimatedAmountBefore());
                netIncome = netIncome.add(dto.getNetIncome() == null ? BigDecimal.ZERO : dto.getNetIncome());
                cost = cost.add(
                        (dto.getCostPrice() == null ? BigDecimal.ZERO : dto.getCostPrice()).multiply(dto.getCombinationQuantity()).multiply(dto.getEstimatedSalesBox())
                                .divide(BigDecimal.ONE.add(bdNull(dto.getTaxRate())), 4, BigDecimal.ROUND_HALF_UP)
                );
                netProfit = netProfit.add(dto.getNetProfit() == null ? BigDecimal.ZERO : dto.getNetProfit());
                if (Objects.isNull(dto.getDiscount())) {
                    dto.setDiscount(BigDecimal.ZERO);
                }
                if (Objects.isNull(dto.getSaleReimburse())) {
                    dto.setSaleReimburse(BigDecimal.ZERO);
                }
                discount = discount.add(dto.getDiscount());
                reimbursement = reimbursement.add(dto.getSaleReimburse());
            }
            //当月销售中预计销量（吨）合计
            map.get(PromotionPlanResultProjectEnum.TON.getCode()).setPlan(ton);
            //预计折前销售额（元）合计/1000
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setPlan(discountBeforeSale.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //（当月销售中的折前销售额-折扣）/1000
            discountAfterSale = discountBeforeSale.subtract(discount);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setPlan(discountAfterSale.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //净收入-合计
            map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setPlan(netIncome.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //成本价*组合数量*预计销量（箱）/(1+税率)
            map.get(PromotionPlanResultProjectEnum.COST.getCode()).setPlan(cost.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
            //净利润-合计
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setPlan(netProfit.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));


        } else {
            throw new RuntimeException("业务模式【" + businessModel + "】不正确");
        }
        //业务模式=采销，取当月送货中所有行"折扣"汇总/1000
        //其他业务模式，取当月销售中所有行"折扣"汇总/1000
        map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setPlan(discount.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
        //业务模式=采销，当月送货中所有行销管报销汇总/1000
        //其他业务模式，取当月销售中所有行"销管报销"汇总/1000
        map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setPlan(reimbursement.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));

        //费用申请中一级预算项目为“消费者费用”下的——活动形式的结案方式为（红字发票/折扣）申请金额合计+【活动形式的结案方式为（报销）申请金额合计-费用池_补差金额】/1.06
        consumer = consumerRD.add(
                (consumerOther.subtract(feePoolDifference)).divide(new BigDecimal("1.06"), 2, BigDecimal.ROUND_HALF_UP)
        );
        map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setPlan(consumer.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
        //猫超：费用申请中一级预算项目为“渠道费用”下的——活动形式的结案方式为（红字发票/折扣）申请金额合计-（采购返点+销售返点）+【活动形式的结案方式为（报销）申请金额合计-费用池_渠道金额】/1.06
        //其他：费用申请中一级预算项目为“渠道费用”下的——活动形式的结案方式为（红字发票/折扣）申请金额合计+【活动形式的结案方式为（报销）申请金额合计-费用池_渠道金额】/1.06
        //费用池_渠道=费用池_销售返+费用池_采购返+费用池_毛保
        channel = channelRD.add(
                (channelOther.subtract(
                        (feePoolSaleCommission.add(feePoolPurchaseRebate).add(feePoolGrossProtection))
                )).divide(new BigDecimal("1.06"), 2, BigDecimal.ROUND_HALF_UP)
        );
        if (PromotionPlanConstant.FRONT.equals(type)) {
            channel = channel.subtract(purchaseRebate).subtract(saleCommission);
        }
        map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setPlan(channel.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
        //费用申请中一级预算项目为“投放费用”下的——活动形式的结案方式为（红字发票/折扣）申请金额合计+【活动形式的结案方式为（报销）申请金额合计-费用池_投放金额】/1.06
        put = putRD.add(
                (putOther.subtract(feePoolPut)).divide(new BigDecimal("1.06"), 2, BigDecimal.ROUND_HALF_UP)
        );
        map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setPlan(put.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
        //费用申请中一级预算项目为“平台运营费用”下的——活动形式的结案方式为（红字发票/折扣）申请金额合计+活动形式的结案方式为（报销）申请金额合计/1.06
        platformOperate = platformOperateRD.add(
                platformOperateOther.divide(new BigDecimal("1.06"), 2, BigDecimal.ROUND_HALF_UP)
        );
        map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setPlan(platformOperate.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));

        if (!CollectionUtils.isEmpty(otherExpensesDtos)) {
            //其他费用
            for (OtherExpensesDto dto : otherExpensesDtos) {
                market = market.add(dto.getMarketAmountPlan() == null ? BigDecimal.ZERO : dto.getMarketAmountPlan());
                admin = admin.add(dto.getAdminAmountPlan() == null ? BigDecimal.ZERO : dto.getAdminAmountPlan());
                human = human.add(dto.getHumanAmountPlan() == null ? BigDecimal.ZERO : dto.getHumanAmountPlan());
            }
        }
        //市场费用-规划（千元）
        map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setPlan(market.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
        //行政管理费用（千元）
        map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setPlan(admin.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));
        //人力成本（千元）
        map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setPlan(human.divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP));

        //毛利率 （规划净收入-规划成本）/规划净收入
        map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setPlan(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                (netIncome.subtract(cost)).divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
        //折扣费用率 规划折扣费用/规划折后含税销售额
        map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                discount.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //报销费用率 规划报销费用/规划折后含税销售额
        map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).getPlan().divide(map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).getPlan(), 4, BigDecimal.ROUND_HALF_UP));
        //消费者费用率 规划消费者费用/规划折后含税销售额
        map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                consumer.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //渠道费用率 规划渠道费用/规划折后含税销售额
        map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                channel.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //投放费用率 规划投放费用/规划折后含税销售额
        map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                put.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //平台运营费用率 规划平台运营费用/规划折后含税销售额
        map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                platformOperate.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        //专项费用率 采销：（规划消费者费用+规划渠道费用+规划投放费用+规划平台运营费用+规划费用池）/规划折后含税销售额，其他：（规划消费者费用+规划渠道费用+规划投放费用+规划平台运营费用）/规划折后含税销售额
        BigDecimal specialCost;
        if (PromotionPlanConstant.CX.equals(businessModel)) {
            specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    (consumer.add(channel).add(put).add(platformOperate)).add(feePool.divide(new BigDecimal("1.06"), 2, BigDecimal.ROUND_HALF_UP)).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
        } else {
            specialCost = discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                    (consumer.add(channel).add(put).add(platformOperate)).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP);
        }
        map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setPlan(specialCost);
        //物流费用率 规划物流费用/规划折前销售额
        map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setPlan(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                logistics.divide(discountBeforeSale, 4, BigDecimal.ROUND_HALF_UP));
        //物流费用单吨（元/吨） 规划物流费用/吨数
        map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setPlan(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                logistics.divide(ton, 2, BigDecimal.ROUND_HALF_UP));
        //净利率 规划净利润/规划净收入
        map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setPlan(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                netProfit.divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
    }

    /**
     * 创建项目列
     *
     * @return
     */
    private LinkedHashMap<String, PromotionPlanResultVo> createPromotionPlanResultVoList(PromotionPlanDto promotionPlan, String type) {
        LinkedHashMap<String, PromotionPlanResultVo> map = new LinkedHashMap<>();
        List<HashMap<String, String>> enumListMap = getEnumListMap();
        enumListMap.forEach(e -> {
            PromotionPlanResultVo vo = new PromotionPlanResultVo(
                    promotionPlan.getPromotionPlanCode(),
                    promotionPlan.getPromotionPlanName(),
                    promotionPlan.getStartDate(),
                    promotionPlan.getEndDate(),
                    e.get("code"),
                    e.get("name"),
                    type
            );
            vo.setTenantCode(TenantUtils.getTenantCode());
            map.put(e.get("code"), vo);
        });
        return map;
    }

    /**
     * 枚举转list
     *
     * @param
     * @return
     */
    private List<HashMap<String, String>> getEnumListMap() {
        List<HashMap<String, String>> list = new ArrayList<>();
        for (PromotionPlanResultProjectEnum ppEnum : EnumSet.allOf(PromotionPlanResultProjectEnum.class)) {
            HashMap<String, String> map = new HashMap<>();
            map.put("name", ppEnum.getName());
            map.put("code", ppEnum.getCode());
            list.add(map);
        }

        return list;
    }

    /**
     * 预算处理
     *
     * @param promotionPlan
     * @param budgetOperationType
     */
    public void monthBudgetHandle(PromotionPlanDto promotionPlan, String budgetOperationType) {
        List<GeneralExpensesDto> dtoList = generalExpensesRepository.findByPlanCode(promotionPlan.getPromotionPlanCode());
        //月度预算处理
        List<GeneralExpensesDto> monthDtoList = dtoList.stream().filter(e -> StringUtils.isNotBlank(e.getMonthBudgetCode())).collect(Collectors.toList());
        //商务政策处理
        List<GeneralExpensesDto> policyDtoList = dtoList.stream().filter(e -> StringUtils.isNotBlank(e.getCommercePolicyCode())).collect(Collectors.toList());


        //预算处理
        List<MonthBudgetBusinessPolicyQueryVo> monthBudgetVoList = new ArrayList<>();
        List<CurrentMonthSaleDto> saleList = currentMonthSaleRepository.findByPlanCode(promotionPlan.getPromotionPlanCode());
        if (!CollectionUtils.isEmpty(monthDtoList)) {
            monthBudgetVoList = getMonthBudgetHandle(monthDtoList, saleList);
        }
        boolean budgetLock = false;
        boolean policyLock = false;
        List<String> monthCodeList = null;
        List<String> businessPolicyCodeList = null;
        try {
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
                monthCodeList = monthBudgetVoList.stream()
                        .map(MonthBudgetVo::getMonthBudgetCode)
                        .distinct().collect(Collectors.toList());
                //预算退回或占用
                budgetLock = monthBudgetLockService.lock(monthCodeList, TimeUnit.MINUTES, 3);
                Validate.isTrue(budgetLock, "预算正在操作中，请稍后重试！");
                monthBudgetVoList.forEach(e -> monthBudgetService.operateBudget(e.getMonthBudgetCode(),
                        e.getFeeRatio(), e.getUsedAmount(), budgetOperationType, e.getBusinessCode()));
                //商务政策处理
            } else if (!CollectionUtils.isEmpty(policyDtoList)) {
                businessPolicyCodeList = policyDtoList.stream()
                        .map(GeneralExpensesDto::getCommercePolicyCode)
                        .distinct()
                        .collect(Collectors.toList());
                List<BusinessPolicyVo> policyList = businessPolicyService.findBusinessPolicyByCode(new HashSet<>(businessPolicyCodeList));
                policyLock = businessPolicyLockService.lock(businessPolicyCodeList, TimeUnit.MINUTES, 3);
                Validate.isTrue(policyLock, "商务政策正在操作中，请稍后重试！");
                for (BusinessPolicyVo policy : policyList) {
                    for (GeneralExpensesDto dto : policyDtoList) {
                        if (dto.getCommercePolicyCode().equals(policy.getBusinessPolicyCode())) {
                            //申请金额退回或占用
                            if (BudgetOperationTypeEnum.USE.getCode().equals(budgetOperationType)) {
                                BigDecimal subtract = policy.getApplyAmount().subtract(dto.getApplyAmount());
                                Validate.isTrue(subtract.compareTo(BigDecimal.ZERO) >= 0, "申请金额大于商务政策【" + policy.getBusinessPolicyCode() + "】的申请金额");
                                policy.setAlreadyUseAmount(Optional.ofNullable(policy.getAlreadyUseAmount()).orElse(BigDecimal.ZERO).add(dto.getApplyAmount()));
                            } else {
                                policy.setAlreadyUseAmount(Optional.ofNullable(policy.getAlreadyUseAmount()).orElse(BigDecimal.ZERO).subtract(dto.getApplyAmount()));
                            }
                            break;
                        }
                    }
                }
                businessPolicyService.updateBusinessPolicyApplyAmount(policyList);
            }
        } finally {
            if (budgetLock
                    && CollectionUtil.isNotEmpty(monthCodeList)) {
                monthBudgetLockService.unLock(monthCodeList);
            }
            if (policyLock
                    && CollectionUtil.isNotEmpty(businessPolicyCodeList)) {
                businessPolicyLockService.unlock(businessPolicyCodeList);
            }
        }
    }

    /**
     * 流程处理
     *
     * @param dto
     * @param processBusiness
     */
    private void submitApprovalHandle(PromotionPlanDto dto, ProcessBusinessDto processBusiness) {
        processBusiness.setBusinessNo(dto.getPromotionPlanCode());
        JSONObject jsonObject = JsonUtils.toJSONObject(dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(PromotionPlanConstant.PROMOTION_PLAN_PROCESS);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);

        PromotionPlanEntity entity = new PromotionPlanEntity();
        entity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        entity.setProcessNo(processBusinessVo.getProcessNo());
        entity.setId(dto.getId());
        this.promotionPlanRepository.updateById(entity);
    }

    /**
     * 添加费用申请列表
     *
     * @param generateGeneralDtos
     * @param amount
     */
    public <T> void addGeneralCopy(List<GeneralExpensesDto> generateGeneralDtos, T dto, BigDecimal amount, String name) {
        if (amount != null && amount.compareTo(BigDecimal.ZERO) > 0) {
            GeneralExpensesDto generate = nebulaToolkitService.copyObjectByWhiteList(dto, GeneralExpensesDto.class, HashSet.class, ArrayList.class);
            generate.setApplyAmount(amount);
            generate.setBeGenerate(Boolean.TRUE);
            generate.setId(UUID.randomUUID().toString().replace("-", ""));
            generate.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            generate.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            ActivityTypeVo activityTypeVo = activityTypeService.getActivityTypeByActivityTypeName(name);
            Validate.isTrue(!CollectionUtils.isEmpty(activityTypeVo.getActivityTypeRelationDtoList()), "【" + name + "】活动类型关联为空");
            generate.setActivityTypeCode(activityTypeVo.getActivityTypeCode());
            generate.setActivityTypeName(activityTypeVo.getActivityTypeName());
            ActivityTypeRelationDto activityTypeRelationDto = activityTypeVo.getActivityTypeRelationDtoList().stream().filter(o -> o.getBusinessUnitCode().equals(BusinessUnitEnum.ONLINE.getCode())).findFirst().orElse(null);
            Validate.notNull(activityTypeRelationDto, "活动类型编码【" + name + "】,在活动分类管理中，未维护业务单元为" + BusinessUnitEnum.ONLINE.getCode() + "的关联信息数据！");
            Validate.notEmpty(activityTypeRelationDto.getActivityTypeFormDtoList(), "活动类型编码【" + name + "】，在活动分类管理中,未维护业务单元为" + BusinessUnitEnum.ONLINE.getCode() + "的关联活动形式数据！");
            List<ActivityTypeFormDto> activityTypeFormDtoList = activityTypeRelationDto.getActivityTypeFormDtoList();
            ActivityTypeFormDto activityTypeFormDto = activityTypeFormDtoList.stream().filter(e -> name.equals(e.getActivityFormName())).findFirst().orElse(null);
            Validate.notNull(activityTypeFormDto, "【" + name + "】的活动形式未维护");
            generate.setActivityFormCode(activityTypeFormDto.getActivityFormCode());
            generate.setActivityFormName(activityTypeFormDto.getActivityFormName());
            generate.setYearMonthLy(DateUtil.format(generate.getStartDate(), "yyyy-MM"));
            generateGeneralDtos.add(generate);
        }
    }

    /**
     * 添加费用申请列表
     *
     * @param generateGeneralDtos
     * @param amount
     */
    public void addGeneral(List<GeneralExpensesDto> generateGeneralDtos, PromotionPlanDto promotionPlan, BigDecimal amount, String typeCode, String fromCode,
                           String customerCode, String customerName) {
        addGeneral(generateGeneralDtos, promotionPlan, amount, typeCode, fromCode, customerCode, customerName, null, null);
    }

    public void addGeneral(List<GeneralExpensesDto> generateGeneralDtos, PromotionPlanDto promotionPlan, BigDecimal amount, String typeCode, String fromCode,
                           String customerCode, String customerName, String channelCode, String channelName) {
        if (amount.compareTo(BigDecimal.ZERO) != 0) {
            GeneralExpensesDto generate = new GeneralExpensesDto();
            generate.setApplyAmount(amount);
            generate.setStartDate(promotionPlan.getStartDate());
            generate.setEndDate(promotionPlan.getEndDate());
            generate.setCustomerCode(customerCode);
            generate.setCustomerName(customerName);
            generate.setBeGenerate(Boolean.TRUE);
            generate.setId(UUID.randomUUID().toString().replace("-", ""));
            generate.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            generate.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            ActivityTypeVo activityTypeVo = activityTypeService.getActivityTypeByActivityTypeCode(typeCode);
            Validate.notNull(activityTypeVo, "活动类型编码【" + typeCode + "】，未找到对应的活动类型");
            Validate.isTrue(!CollectionUtils.isEmpty(activityTypeVo.getActivityTypeRelationDtoList()), "【" + typeCode + "】活动分类管理中，未维护关联信息");
            generate.setActivityTypeCode(activityTypeVo.getActivityTypeCode());
            generate.setActivityTypeName(activityTypeVo.getActivityTypeName());
            ActivityTypeRelationDto activityTypeRelationDto = activityTypeVo.getActivityTypeRelationDtoList().stream().filter(o -> o.getBusinessUnitCode().equals(BusinessUnitEnum.ONLINE.getCode())).findFirst().orElse(null);
            Validate.notNull(activityTypeRelationDto, "活动类型编码【" + typeCode + "】,在活动分类管理中，未维护业务单元为" + BusinessUnitEnum.ONLINE.getCode() + "的关联信息数据！");
            Validate.notEmpty(activityTypeRelationDto.getActivityTypeFormDtoList(), "活动类型编码【" + typeCode + "】，在活动分类管理中,未维护业务单元为" + BusinessUnitEnum.ONLINE.getCode() + "的关联活动形式数据！");
            List<ActivityTypeFormDto> activityTypeFormDtoList = activityTypeRelationDto.getActivityTypeFormDtoList();
            Validate.isTrue(!CollectionUtils.isEmpty(activityTypeFormDtoList), "【" + typeCode + "】的活动形式未维护");
            ActivityTypeFormDto activityTypeFormDto = activityTypeFormDtoList.stream().filter(e -> fromCode.equals(e.getActivityFormCode())).findFirst().orElse(null);
            Validate.notNull(activityTypeFormDto, "活动类型编码【" + typeCode + "】，在活动分类管理,业务单元为" + BusinessUnitEnum.ONLINE.getCode() + "的关联活动形式数据上，未关联【" + fromCode + "】的活动形式");
            generate.setActivityFormCode(activityTypeFormDto.getActivityFormCode());
            generate.setActivityFormName(activityTypeFormDto.getActivityFormName());
            generate.setYearMonthLy(DateUtil.format(generate.getStartDate(), "yyyy-MM"));
            generate.setChannelCode(channelCode);
            generate.setChannelName(channelName);
            generateGeneralDtos.add(generate);
        }
    }

    /**
     * 创建验证
     *
     * @param promotionPlan
     */
    private String createValidate(PromotionPlanDto promotionPlan) {
        Validate.notNull(promotionPlan, "新增时，对象信息不能为空！");
        return commonValidate(promotionPlan);
    }

    /**
     * 修改验证
     *
     * @param promotionPlan
     */
    private String updateValidate(PromotionPlanDto promotionPlan) {
        Validate.notNull(promotionPlan, "修改时，对象信息不能为空！");
        Validate.notBlank(promotionPlan.getId(), "修改时，id不能为空！");
        return commonValidate(promotionPlan);
    }

    /**
     * 通用校验
     *
     * @param promotionPlan
     */
    private String commonValidate(PromotionPlanDto promotionPlan) {

        Validate.notBlank(promotionPlan.getPromotionPlanName(), "促销规划名称，不能为空！");
        Validate.notNull(promotionPlan.getStartDate(), "促销规划时间，不能为空！");
        Validate.notNull(promotionPlan.getEndDate(), "促销规划时间，不能为空！");
        Validate.notBlank(promotionPlan.getBusinessModelCode(), "业务模式，不能为空！");
        Validate.notBlank(promotionPlan.getSalesOrgCode(), "销售机构，不能为空！");
//        Validate.notBlank(promotionPlan.getSalesDepartmentCode(), "销售部门，不能为空！");
        Validate.notBlank(promotionPlan.getBusinessFormatCode(), "业态，不能为空！");

        return getBusinessModelName(promotionPlan.getBusinessModelCode());
    }

    /**
     * 获取业务模式名称
     *
     * @param code
     * @return
     */
    private String getBusinessModelName(String code) {
        Validate.notBlank(code, "业务模式，不能为空！");
        DictDataVo dictDataVo = dictDataVoService.findByDictTypeCode(PromotionPlanConstant.BUSINESS_MODEL).stream().filter(e ->
                code.equals(e.getDictCode())).findFirst().orElse(null);
        Validate.notNull(dictDataVo, "数据字典：业务模式，未维护");
        return dictDataVo.getDictValue();
    }

    /**
     * 明细校验
     */
    public void detailsValidate(PromotionPlanDto promotionPlan, String businessModel) {
        //不同业务模式的校验
        if (PromotionPlanConstant.CX.equals(businessModel)) {
            Validate.notBlank(promotionPlan.getCustomerCode(), "客户，不能为空！");
            Validate.notBlank(promotionPlan.getPlatformCode(), "平台，不能为空！");
            deliveryValidate(promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPlatformName());
            purchaseValidate(promotionPlan.getPurchaseSaleDtos());
        } else if (PromotionPlanConstant.ZY.equals(businessModel)) {
            Validate.notBlank(promotionPlan.getCustomerCode(), "客户，不能为空！");
            Validate.notBlank(promotionPlan.getPlatformCode(), "平台，不能为空！");
        } else if (PromotionPlanConstant.FX.equals(businessModel)) {
        } else {
            throw new RuntimeException("业务模式【" + businessModel + "】不正确");
        }
        expensesValidate(promotionPlan.getGeneralExpensesDtos());
        saleValidate(promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getPlatformName());
        otherValidate(promotionPlan.getOtherExpensesDtos());
    }

    /**
     * 费用申请
     *
     * @param dtos
     */
    public void expensesValidate(List<GeneralExpensesDto> dtos) {
        Validate.isTrue(!CollectionUtils.isEmpty(dtos), "费用申请列表不能为空");

        dtos.forEach(e -> {
            Validate.notBlank(e.getActivityTypeCode(), "活动类型编码，不能为空！");
            Validate.notBlank(e.getActivityFormCode(), "活动形式编码，不能为空！");
            Validate.notNull(e.getStartDate(), "开始时间，不能为空！");
            Validate.notNull(e.getEndDate(), "结束时间，不能为空！");
            Validate.notBlank(e.getCustomerCode(), "客户，不能为空！");
            Validate.notNull(e.getApplyAmount(), "申请金额，不能为空！");
            Validate.notBlank(e.getAuditWayCode(), "结案方式，不能为空！");
            Validate.notBlank(e.getAuditConditionType(), "核销条件，不能为空！");
            Validate.notBlank(e.getYearMonthLy(), "费用归属年月，不能为空！");
            Validate.isTrue((StringUtils.isNotBlank(e.getCommercePolicyCode()) || StringUtils.isNotBlank(e.getMonthBudgetCode()))
                    && !(StringUtils.isNotBlank(e.getCommercePolicyCode()) && StringUtils.isNotBlank(e.getMonthBudgetCode())), "商务政策和预算有且只能填写一项");
        });

    }

    /**
     * 当月销售
     *
     * @param dtos
     */
    public void saleValidate(List<CurrentMonthSaleDto> dtos, String platformName) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(e -> {
            Validate.notBlank(e.getCustomerCode(), "客户，不能为空！");
            Validate.notBlank(e.getProductBrandCode(), "品牌，不能为空！");
            Validate.notBlank(e.getProductName(), "产品名称，不能为空！");
            Validate.notBlank(e.getProductCode(), "产品编码，不能为空！");
            Validate.notNull(e.getTaxRate(), "税率，不能为空！");
            Validate.notNull(e.getRatio(), "系数，不能为空！");
            Validate.notNull(e.getStandardRetailPrice(), "标准零售价，不能为空！");
            Validate.notNull(e.getPlatformSupplyPrice(), "平台供货价，不能为空！");
            Validate.notNull(e.getActivityBasePrice(), "活动底价，不能为空！");
            Validate.notNull(e.getCombinationQuantity(), "组合数量，不能为空！");
            Validate.notBlank(e.getPromotionTypeCode(), "促销类型，不能为空！");
            Validate.notNull(e.getEstimatedSalesBox(), "预计销量（箱），不能为空！");

            //预计折前销售额（元）：自动计算：组合数量*平台供货价*预计销量（箱）
            e.setEstimatedAmountBefore(e.getCombinationQuantity().multiply(e.getPlatformSupplyPrice()).multiply(e.getEstimatedSalesBox()).setScale(2, RoundingMode.HALF_UP));
            //京东采购返（元）	"IF平台=“京东商城”才计算该字段，逻辑为：平台供货价*预计销量（箱）*组合数量*0.06"
            if ("京东商城".equals(platformName)) {
                e.setJd(e.getEstimatedAmountBefore().multiply(new BigDecimal("0.06")).setScale(2, RoundingMode.HALF_UP));
            }
        });
    }

    /**
     * 当月送货
     *
     * @param dtos
     */
    public void deliveryValidate(List<CurrentMonthDeliveryDto> dtos, String platformName) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(e -> {
            Validate.notBlank(e.getCustomerCode(), "客户，不能为空！");
            Validate.notBlank(e.getProductBrandCode(), "品牌，不能为空！");
            Validate.notBlank(e.getProductName(), "产品名称，不能为空！");
            Validate.notBlank(e.getProductCode(), "产品编码，不能为空！");
            Validate.notNull(e.getTaxRate(), "税率，不能为空！");
            Validate.notNull(e.getRatio(), "系数，不能为空！");
            Validate.notNull(e.getStandardRetailPrice(), "标准零售价，不能为空！");
            Validate.notNull(e.getPlatformSupplyPrice(), "平台供货价，不能为空！");
            Validate.notNull(e.getCombinationQuantity(), "组合数量，不能为空！");
            Validate.notNull(e.getEstimatedSalesBox(), "预计销量（箱），不能为空！");
            Validate.notNull(e.getEstimatedSalesTon(), "预计销量（吨），不能为空！");

            currentMonthDeliveryService.calculationFee(e, platformName);
        });
    }

    /**
     * 采销库存
     *
     * @param dtos
     */
    public void purchaseValidate(List<PurchaseSaleDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(e -> {
            Validate.notBlank(e.getProductBrandCode(), "品牌，不能为空！");
            Validate.notBlank(e.getProductName(), "产品名称，不能为空！");
            Validate.notBlank(e.getProductCode(), "产品编码，不能为空！");
            Validate.notNull(e.getStandardRetailPrice(), "标准零售价，不能为空！");
            Validate.notNull(e.getSupplyPrice(), "供货价，不能为空！");
            Validate.notNull(e.getPromotionPrice(), "促销售价，不能为空！");
            Validate.notNull(e.getMonthInventoryEnd(), "本月期末库存，不能为空！");
        });
    }

    /**
     * 其他费用
     *
     * @param dtos
     */
    public void otherValidate(List<OtherExpensesDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(e -> {
            Validate.notNull(e.getAdminAmountBudget(), "行政管理费用-预算，不能为空！");
            Validate.notNull(e.getAdminAmountPlan(), "行政管理费用-规划，不能为空！");
            Validate.notNull(e.getHumanAmountBudget(), "人力成本-预算，不能为空！");
            Validate.notNull(e.getHumanAmountPlan(), "人力成本-规划，不能为空！");
            Validate.notNull(e.getMarketAmountBudget(), "市场费用-预算，不能为空！");
            Validate.notNull(e.getMarketAmountPlan(), "市场费用-规划，不能为空！");
        });
    }

    @Override
    public List<CurrentMonthSaleVo> findCustomerProductMonthSaleSumList(CurrentMonthSaleDto dto) {
        return currentMonthSaleRepository.findCustomerProductMonthSaleSumList(dto);
    }
}

