package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.DateUtils;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanTableForm;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanResultRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanTableFormRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanResultProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanTableFormService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.*;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 平台维度电商的促销规划一览汇总表
 *
 * @author: cyj
 * @date: 2023/2/14 10:38
 */
@Slf4j
@Service("promotionPlanTableFormService")
public class PromotionPlanTableFormServiceImpl implements PromotionPlanTableFormService {

    @Autowired(required = false)
    private PromotionPlanResultRepository promotionPlanResultRepository;

    @Autowired(required = false)
    private PromotionPlanTableFormRepository promotionPlanTableFormRepository;

    @Autowired(required = false)
    private ActualProfitLossService actualProfitLossService;

    @Autowired(required = false)
    private BudgetProfitLossService budgetProfitLossService;

    @Autowired(required = false)
    private PromotionPlanRepository promotionPlanRepository;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createDataSummary(String date) {
        if (StringUtils.isEmpty(date)){
            date = DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        }
        List<PromotionPlanParamVo> planResultList = new ArrayList<>();
        planResultList = promotionPlanResultRepository.getAllByDate(date,PromotionPlanConstant.PAPER,ProcessStatusEnum.PASS.getDictCode());
        if (CollectionUtils.isEmpty(planResultList)) {
            log.info("本次未查询到数据，请求结束!");
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();

        log.info("开始构建数据，查询数据量为:{}", planResultList.size());
        //销售部门+平台+年月
        Map<String, List<PromotionPlanParamVo>> groupMap = planResultList.stream()
                .filter(vo -> StringUtils.isNotEmpty(vo.getOrgCode())
                        && StringUtils.isNotEmpty(vo.getStartDate())
                        && StringUtils.isNotEmpty(vo.getPlatformCode()))
                .collect(Collectors.groupingBy(vo -> StringUtils.join(vo.getOrgCode()
                        , vo.getPlatformCode(), vo.getStartDate().substring(0,7))));
        log.info("部门+平台+年月汇总后数据量为{}", groupMap.entrySet().size());
        List<PromotionPlanTableForm> list = new ArrayList<>();
        for (Map.Entry<String, List<PromotionPlanParamVo>> key : groupMap.entrySet()) {
            List<PromotionPlanParamVo> value = key.getValue();
            PromotionPlanParamVo promotionPlanParam = value.get(0);
            //项目编码
            Map<String, List<PromotionPlanParamVo>> projectMap = value.stream().filter(vo -> StringUtils.isNotEmpty(vo.getProjectCode())).collect(Collectors.groupingBy(PromotionPlanParamVo::getProjectCode));
            //净收入
            List<PromotionPlanParamVo> netIncome = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode())).orElse(new ArrayList<>());
            BigDecimal netIncomeContemporaneous = BigDecimal.ZERO;
            BigDecimal netIncomeBudget = BigDecimal.ZERO;
            BigDecimal netIncomePlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : netIncome) {
                if (StringUtils.equals(promotionPlanParamVo.getBusinessModelCode(),PromotionPlanConstant.FX_CODE)){
                    //同期净收入
                    netIncomeContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    //预算净收入
                    netIncomeBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                }else {
                    //同期净收入
                    netIncomeContemporaneous = netIncomeContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    //预算净收入
                    netIncomeBudget = netIncomeBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                //规划净收入
                netIncomePlan = netIncomePlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }
            //净收入达成:规划净收入/预算净收入
            BigDecimal incomeAchievement = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomeBudget) != 0) {
                incomeAchievement = netIncomePlan.divide(netIncomeBudget, 6, BigDecimal.ROUND_HALF_UP);
            }
            //VS同期（净收入）:规划净收入-同期净收入
            BigDecimal vsContemporaneous = netIncomePlan.subtract(netIncomeContemporaneous);
            //VS预算（净收入）:规划净收入-预算净收入
            BigDecimal vsBudget = netIncomePlan.subtract(netIncomeBudget);

            //折扣费用
            List<PromotionPlanParamVo> disCount = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode())).orElse(new ArrayList<>());
            BigDecimal disCountContemporaneous = BigDecimal.ZERO;
            BigDecimal disCountBudget = BigDecimal.ZERO;
            BigDecimal disCountPlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : disCount) {
                if (StringUtils.equals(promotionPlanParamVo.getBusinessModelCode(),PromotionPlanConstant.FX_CODE)){
                    //同期折扣费用
                    disCountContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    //预算折扣费用
                    disCountBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                }else {
                    //同期折扣费用
                    disCountContemporaneous = disCountContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    //预算折扣费用
                    disCountBudget = disCountBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                //规划折扣费用
                disCountPlan = disCountPlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }

            //报销费用
            List<PromotionPlanParamVo> reimbursement = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode())).orElse(new ArrayList<>());
            BigDecimal reimbursementContemporaneous = BigDecimal.ZERO;
            BigDecimal reimbursementBudget = BigDecimal.ZERO;
            BigDecimal reimbursementPlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : reimbursement) {
                if (StringUtils.equals(promotionPlanParamVo.getBusinessModelCode(),PromotionPlanConstant.FX_CODE)){
                    //同期报销费用
                    reimbursementContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    //预算报销费用
                    reimbursementBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                }else {
                    //同期报销费用
                    reimbursementContemporaneous = reimbursementContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    //预算报销费用
                    reimbursementBudget = reimbursementBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                //规划报销费用
                reimbursementPlan = reimbursementPlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }

            //折后含税销售额
            List<PromotionPlanParamVo> discountAfterSale = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode())).orElse(new ArrayList<>());
            BigDecimal discountAfterSaleContemporaneous = BigDecimal.ZERO;
            BigDecimal discountAfterSaleBudget = BigDecimal.ZERO;
            BigDecimal discountAfterSalePlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : discountAfterSale) {
                if (StringUtils.equals(promotionPlanParamVo.getBusinessModelCode(),PromotionPlanConstant.FX_CODE)){
                    //同期折后含税销售额
                    discountAfterSaleContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    //预算折后含税销售额
                    discountAfterSaleBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                }else {
                    //同期折后含税销售额
                    discountAfterSaleContemporaneous = discountAfterSaleContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    //预算折后含税销售额
                    discountAfterSaleBudget = discountAfterSaleBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                //规划折后含税销售额
                discountAfterSalePlan = discountAfterSalePlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }

            //同期专项费用率 : （同期折扣费用+同期报销费用）/同期折后含税销售额
            BigDecimal contemporaneousSpecialExpenseRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(discountAfterSaleContemporaneous) != 0) {
                contemporaneousSpecialExpenseRate = (disCountContemporaneous.add(reimbursementContemporaneous)).divide(discountAfterSaleContemporaneous, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            //预算专项费用率 : （预算折扣费用+预算报销费用）/预算折后含税销售额
            BigDecimal budgetSpecialExpenseRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(discountAfterSaleBudget) != 0) {
                budgetSpecialExpenseRate = (disCountBudget.add(reimbursementBudget)).divide(discountAfterSaleBudget, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            //规划专项费用率 : （规划折扣费用+规划报销费用）/规划折后含税销售额
            BigDecimal planSpecialExpenseRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(discountAfterSalePlan) != 0) {
                planSpecialExpenseRate = (disCountPlan.add(reimbursementPlan)).divide(discountAfterSalePlan, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }

            //VS同期（费用率） : 规划费用率-同期费用率
            BigDecimal expenseRateVsContemporaneous = planSpecialExpenseRate.subtract(contemporaneousSpecialExpenseRate);
            //VS预算（费用率） : 规划费用率-预算费用率
            BigDecimal expenseRateVsBudget = planSpecialExpenseRate.subtract(budgetSpecialExpenseRate);

            //净利润
            List<PromotionPlanParamVo> netProfit = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode())).orElse(new ArrayList<>());
            BigDecimal netProfitContemporaneous = BigDecimal.ZERO;
            BigDecimal netProfitBudget = BigDecimal.ZERO;
            BigDecimal netProfitPlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : netProfit) {
                if (StringUtils.equals(promotionPlanParamVo.getBusinessModelCode(),PromotionPlanConstant.FX_CODE)){
                    //同期净利润
                    netProfitContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    //预算净利润
                    netProfitBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                }else {
                    //同期净利润
                    netProfitContemporaneous = netProfitContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    //预算净利润
                    netProfitBudget = netProfitBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));

                }
                //规划净利润
                netProfitPlan = netProfitPlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }

            //预算净利率 : 预算净利润/预算净收入
            BigDecimal budgetProfitMargin = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomeBudget) != 0) {
                budgetProfitMargin = netProfitBudget.divide(netIncomeBudget, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            //规划净利率 : 规划净利润/规划净收入
            BigDecimal plannedProfitMargin = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomePlan) != 0) {
                plannedProfitMargin = netProfitPlan.divide(netIncomePlan, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }

            //净利率达成 : 规划净利润/预算净利润
            BigDecimal profitMarginReached = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(budgetProfitMargin) != 0) {
                profitMarginReached = plannedProfitMargin.divide(budgetProfitMargin, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }

            log.info("开始构建数据!");
            PromotionPlanTableForm promotionPlanTableForm = new PromotionPlanTableForm();
            promotionPlanTableForm.setOnlyKey(key.getKey());
            promotionPlanTableForm.setTenantCode(tenantCode);
            promotionPlanTableForm.setDelFlag(delFlag);
            promotionPlanTableForm.setSalesDepartmentCode(promotionPlanParam.getSalesDepartmentCode());
            promotionPlanTableForm.setSalesDepartmentName(promotionPlanParam.getSalesDepartmentName());
            promotionPlanTableForm.setOrgCode(promotionPlanParam.getOrgCode());
            promotionPlanTableForm.setOrgName(promotionPlanParam.getOrgName());
            promotionPlanTableForm.setPlatformCode(promotionPlanParam.getPlatformCode());
            promotionPlanTableForm.setPlatformName(promotionPlanParam.getPlatformName());
            promotionPlanTableForm.setYearAndMonth(promotionPlanParam.getStartDate().substring(0,7));
            promotionPlanTableForm.setNetIncomeContemporaneous(netIncomeContemporaneous);
            promotionPlanTableForm.setNetIncomeBudget(netIncomeBudget);
            promotionPlanTableForm.setNetIncomePlan(netIncomePlan);
            promotionPlanTableForm.setIncomeAchievement(incomeAchievement);
            promotionPlanTableForm.setVsContemporaneous(vsContemporaneous);
            promotionPlanTableForm.setVsBudget(vsBudget);
            promotionPlanTableForm.setContemporaneousSpecialExpenseRate(contemporaneousSpecialExpenseRate);
            promotionPlanTableForm.setBudgetSpecialExpenseRate(budgetSpecialExpenseRate);
            promotionPlanTableForm.setPlanSpecialExpenseRate(planSpecialExpenseRate);
            promotionPlanTableForm.setExpenseRateVsContemporaneous(expenseRateVsContemporaneous);
            promotionPlanTableForm.setExpenseRateVsBudget(expenseRateVsBudget);
            promotionPlanTableForm.setBudgetNetProfit(netProfitBudget);
            promotionPlanTableForm.setPlannedNetProfit(netProfitPlan);
            promotionPlanTableForm.setContemporaneousNetProfit(netProfitContemporaneous);
            promotionPlanTableForm.setBudgetProfitMargin(budgetProfitMargin);
            promotionPlanTableForm.setPlannedProfitMargin(plannedProfitMargin);
            promotionPlanTableForm.setProfitMarginReached(profitMarginReached);
            promotionPlanTableForm.setLevelCode(PromotionPlanConstant.PLATFORM);
            list.add(promotionPlanTableForm);
        }

        //部门维度
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(date,DateUtil.DEFAULT_YEAR_MONTH_DAY));
        //去年一月
        calendar.add(Calendar.YEAR,-1);
        //去年当月
        String lastYearNowMonth =  DateUtil.format(calendar.getTime(),DateUtil.DEFAULT_DATE_ALL_PATTERN);
        calendar.set(Calendar.MONTH,0);
        calendar.set(Calendar.DATE,1);
        String lastYearOneMonth =  DateUtil.format(calendar.getTime(),DateUtil.DEFAULT_DATE_ALL_PATTERN);
        //当月一日
        String nowDate = DateUtil.getFirstDayOfMonth(date);
        //促销规划
        PromotionPlanDto promotionPlanDto = new PromotionPlanDto();
        promotionPlanDto.setStartDateStr(nowDate);
        promotionPlanDto.setEndDateStr(nowDate);
        promotionPlanDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        List<PromotionPlanVo> promotionPlanVoList = Optional.ofNullable(this.promotionPlanRepository.findByDateConditions(promotionPlanDto)).orElse(new ArrayList<>());
        if (CollectionUtil.isEmpty(promotionPlanVoList)){
            return;
        }

        //查损益表-实际
        ActualProfitLossVo dto = new ActualProfitLossVo();
        dto.setType(PromotionPlanConstant.PAPER);
        dto.setBeginDate(lastYearOneMonth.substring(0,7));
        dto.setEndDate(nowDate.substring(0,7));
        List<ActualProfitLossVo> profitLoss = Optional.ofNullable(this.actualProfitLossService.findProfitLossByDto(dto)).orElse(new ArrayList<>());
        log.info("部门维度查询损益表-实际的数据量为:{}", profitLoss.size());
        Map<String, List<ActualProfitLossVo>> actualProfitLossMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(profitLoss)) {
            actualProfitLossMap = profitLoss.stream().filter(vo -> StringUtils.isNotEmpty(vo.getDepartmentCode())).collect(Collectors.groupingBy(ActualProfitLossVo::getDepartmentCode));
        }
        //损益表-预算
        BudgetProfitLossVo budgetDto = new BudgetProfitLossVo();
        budgetDto.setType(PromotionPlanConstant.PAPER);
        budgetDto.setBeginDate(lastYearOneMonth.substring(0,7));
        budgetDto.setEndDate(nowDate.substring(0,7));
        List<BudgetProfitLossVo> profitLossByDto = Optional.ofNullable(this.budgetProfitLossService.findProfitLossByDto(budgetDto)).orElse(new ArrayList<>());
        log.info("部门维度查询损益表-预算的数据量为:{}", profitLossByDto.size());
        Map<String, List<BudgetProfitLossVo>> budgetProfitLossMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(profitLossByDto)) {
            budgetProfitLossMap = profitLossByDto.stream().filter(vo -> StringUtils.isNotEmpty(vo.getDepartmentCode())).collect(Collectors.groupingBy(BudgetProfitLossVo::getDepartmentCode));
        }
        Map<String, List<PromotionPlanTableForm>> planMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(list)){
            planMap = Optional.ofNullable(list.stream().collect(Collectors.groupingBy(PromotionPlanTableForm::getOrgCode))).orElse(new HashMap<>());
        }

        //规划
        //部门+年月
        Map<String, List<PromotionPlanParamVo>> planSalesDepartmentMap = planResultList.stream()
                .filter(vo -> StringUtils.isNotEmpty(vo.getOrgCode()))
                .collect(Collectors.groupingBy(vo -> StringUtils.join(vo.getOrgCode())));

        for (PromotionPlanVo promotionPlanVo : promotionPlanVoList) {
            String salesDepartmentCode = promotionPlanVo.getOrgCode();
            List<ActualProfitLossVo> actualProfitLossVos = actualProfitLossMap.get(salesDepartmentCode);
            List<BudgetProfitLossVo> budgetProfitLossVos = budgetProfitLossMap.get(salesDepartmentCode);
            List<PromotionPlanParamVo> promotionPlanParamVos = planSalesDepartmentMap.get(salesDepartmentCode);
            PromotionPlanTableForm promotionPlanTableForm = new PromotionPlanTableForm();
            promotionPlanTableForm.setId(null);
            BigDecimal netIncomeContemporaneous = BigDecimal.ZERO;
            BigDecimal netIncomeBudget = BigDecimal.ZERO;
            BigDecimal netIncomePlan = BigDecimal.ZERO;
            BigDecimal disCountContemporaneous = BigDecimal.ZERO;
            BigDecimal disCountBudget = BigDecimal.ZERO;
            BigDecimal disCountPlan = BigDecimal.ZERO;
            BigDecimal reimbursementContemporaneous = BigDecimal.ZERO;
            BigDecimal reimbursementBudget = BigDecimal.ZERO;
            BigDecimal reimbursementPlan = BigDecimal.ZERO;
            BigDecimal salesContemporaneous = BigDecimal.ZERO;
            BigDecimal salesBudget = BigDecimal.ZERO;
            BigDecimal salesPlan = BigDecimal.ZERO;
            BigDecimal disCountSubContemporaneous = BigDecimal.ZERO;
            BigDecimal disCountSubBudget = BigDecimal.ZERO;
            BigDecimal netProfitContemporaneous = BigDecimal.ZERO;
            BigDecimal netProfitBudget = BigDecimal.ZERO;
            BigDecimal netProfitPlan = BigDecimal.ZERO;
            BigDecimal othersAddContemporaneous = BigDecimal.ZERO;
            BigDecimal othersAddBudget = BigDecimal.ZERO;
            if (CollectionUtil.isNotEmpty(actualProfitLossVos)){
                Map<String, List<ActualProfitLossVo>> actualProfitLossYearMonthMap = actualProfitLossVos.stream().collect(Collectors.groupingBy(ActualProfitLossVo::getYearMonthly));
                List<ActualProfitLossVo> lastYearMonthNowList = Optional.ofNullable(actualProfitLossYearMonthMap.get(lastYearNowMonth.substring(0, 7))).orElse(new ArrayList<>());
                //同期净收入
                netIncomeContemporaneous = netIncomeContemporaneous.add(lastYearMonthNowList.stream().map(ActualProfitLossVo::getNetIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //同期折扣费用
                disCountContemporaneous = disCountContemporaneous.add(lastYearMonthNowList.stream().map(ActualProfitLossVo::getSaleFeeSaleDiscount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //同期报销费用
                reimbursementContemporaneous = reimbursementContemporaneous.add(lastYearMonthNowList.stream().map(ActualProfitLossVo::getSaleFeeReimburse).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //同期销售额
                salesContemporaneous = salesContemporaneous.add(lastYearMonthNowList.stream().map(ActualProfitLossVo::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //同期折扣
                disCountSubContemporaneous = disCountSubContemporaneous.add(lastYearMonthNowList.stream().map(ActualProfitLossVo::getDiscountSub).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //同期净利润
                netProfitContemporaneous = netProfitContemporaneous.add(lastYearMonthNowList.stream().map(ActualProfitLossVo::getNetProfit).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //其他业务收入
                othersAddContemporaneous = othersAddContemporaneous.add(lastYearMonthNowList.stream().map(ActualProfitLossVo::getOthersAdd).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            //同期净收入 = 净收入+其他业务收入
            netIncomeContemporaneous = netIncomeContemporaneous.add(othersAddContemporaneous);
            if (CollectionUtil.isNotEmpty(budgetProfitLossVos)){
                Map<String, List<BudgetProfitLossVo>> budgetProfitLossVosYearMonthMap = budgetProfitLossVos.stream().collect(Collectors.groupingBy(BudgetProfitLossVo::getYearMonthly));
                List<BudgetProfitLossVo> yearMonthNowList = Optional.ofNullable(budgetProfitLossVosYearMonthMap.get(nowDate.substring(0, 7))).orElse(new ArrayList<>());
                //预算净收入
                netIncomeBudget = netIncomeBudget.add(yearMonthNowList.stream().map(BudgetProfitLossVo::getNetIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //预算折扣费用
                disCountBudget = disCountBudget.add(yearMonthNowList.stream().map(BudgetProfitLossVo::getSaleFeeSaleDiscount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //预算报销费用
                reimbursementBudget = reimbursementBudget.add(yearMonthNowList.stream().map(BudgetProfitLossVo::getSaleFeeReimburse).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //预算销售额
                salesBudget = salesBudget.add(yearMonthNowList.stream().map(BudgetProfitLossVo::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //预算折扣
                disCountBudget = disCountBudget.add(yearMonthNowList.stream().map(BudgetProfitLossVo::getDiscountSub).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //预算净利润
                netProfitBudget = netProfitBudget.add(yearMonthNowList.stream().map(BudgetProfitLossVo::getNetProfit).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //其他业务收入
                othersAddBudget = othersAddBudget.add(yearMonthNowList.stream().map(BudgetProfitLossVo::getOthersAdd).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            //预算净收入 = 净收入+其他业务收入
            netIncomeBudget = netIncomeBudget.add(othersAddBudget);
            if (CollectionUtil.isNotEmpty(list)){
                List<PromotionPlanTableForm> planTableFormList = Optional.ofNullable(planMap.get(salesDepartmentCode)).orElse(new ArrayList<>());
                //规划净收入
                netIncomePlan = netIncomePlan.add(planTableFormList.stream().map(PromotionPlanTableForm::getNetIncomePlan).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //规划净利润
                netProfitPlan = netProfitPlan.add(planTableFormList.stream().map(PromotionPlanTableForm::getPlannedNetProfit).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            if (CollectionUtil.isNotEmpty(promotionPlanParamVos)){
                Map<String, List<PromotionPlanParamVo>> yearMonthMap = promotionPlanParamVos.stream().collect(Collectors.groupingBy(vo -> vo.getStartDate().substring(0, 7)));
                List<PromotionPlanParamVo> promotionPlanParamVoList = Optional.ofNullable(yearMonthMap.get(nowDate.substring(0, 7))).orElse(new ArrayList<>());
                List<PromotionPlanParamVo> DISCOUNT_AFTER_SALE = promotionPlanParamVoList.stream().filter(vo -> StringUtils.equals(vo.getProjectCode(), PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode())).collect(Collectors.toList());
                List<PromotionPlanParamVo> DISCOUNT = promotionPlanParamVoList.stream().filter(vo -> StringUtils.equals(vo.getProjectCode(), PromotionPlanResultProjectEnum.DISCOUNT.getCode())).collect(Collectors.toList());
                List<PromotionPlanParamVo> REIMBURSEMENT = promotionPlanParamVoList.stream().filter(vo -> StringUtils.equals(vo.getProjectCode(), PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode())).collect(Collectors.toList());
                //规划折扣
                disCountPlan = disCountPlan.add(DISCOUNT.stream().map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //规划报销
                reimbursementPlan = reimbursementPlan.add(REIMBURSEMENT.stream().map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                //规划销售额
                salesPlan = salesPlan.add(DISCOUNT_AFTER_SALE.stream().map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
               }
            //净收入达成:规划净收入/预算净收入
            BigDecimal incomeAchievement = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomeBudget) != 0) {
                incomeAchievement = netIncomePlan.divide(netIncomeBudget, 6, BigDecimal.ROUND_HALF_UP);
            }
            //VS同期（净收入）:规划净收入-同期净收入
            BigDecimal vsContemporaneous = netIncomePlan.subtract(netIncomeContemporaneous);
            //VS预算（净收入）:规划净收入-预算净收入
            BigDecimal vsBudget = netIncomePlan.subtract(netIncomeContemporaneous);
            //同期专项费用率 : （同期折扣费用+同期报销费用）/同期折后含税销售额  同期折后含税销售额:销售额-折扣
            BigDecimal contemporaneousSpecialExpenseRate = BigDecimal.ZERO;
            BigDecimal discountAfterSaleContemporaneous = salesContemporaneous.subtract(disCountSubContemporaneous);
            if (BigDecimal.ZERO.compareTo(discountAfterSaleContemporaneous) != 0) {
                contemporaneousSpecialExpenseRate = (disCountContemporaneous.add(reimbursementContemporaneous)).divide(discountAfterSaleContemporaneous, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            //预算专项费用率 : （预算折扣费用+预算报销费用）/预算折后含税销售额
            BigDecimal budgetSpecialExpenseRate = BigDecimal.ZERO;
            BigDecimal discountAfterSaleBudget = salesBudget.subtract(disCountSubBudget);
            if (BigDecimal.ZERO.compareTo(discountAfterSaleBudget) != 0) {
                budgetSpecialExpenseRate = (disCountBudget.add(reimbursementBudget)).divide(discountAfterSaleBudget, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            //规划专项费用率 : （规划折扣费用+规划报销费用）/规划折后含税销售额
            BigDecimal planSpecialExpenseRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(salesPlan) != 0) {
                planSpecialExpenseRate = (disCountPlan.add(reimbursementPlan)).divide(salesPlan, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            //VS同期（费用率） : 规划费用率-同期费用率
            BigDecimal expenseRateVsContemporaneous = planSpecialExpenseRate.subtract(contemporaneousSpecialExpenseRate);
            //VS预算（费用率） : 规划费用率-预算费用率
            BigDecimal expenseRateVsBudget = planSpecialExpenseRate.subtract(budgetSpecialExpenseRate);
            //预算净利率 : 预算净利润/预算净收入
            BigDecimal budgetProfitMargin = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomeBudget) != 0) {
                budgetProfitMargin = netProfitBudget.divide(netIncomeBudget, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            //规划净利率 : 规划净利润/规划净收入
            BigDecimal plannedProfitMargin = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomePlan) != 0) {
                plannedProfitMargin = netProfitPlan.divide(netIncomePlan, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            //净利率达成 : 规划净利润/预算净利润
            BigDecimal profitMarginReached = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(budgetProfitMargin) != 0) {
                profitMarginReached = plannedProfitMargin.divide(budgetProfitMargin, 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            log.info("开始构建数据!");
            promotionPlanTableForm.setOnlyKey(salesDepartmentCode + nowDate.substring(0,7));
            promotionPlanTableForm.setTenantCode(tenantCode);
            promotionPlanTableForm.setDelFlag(delFlag);
            promotionPlanTableForm.setSalesDepartmentCode(promotionPlanVo.getSalesDepartmentCode());
            promotionPlanTableForm.setSalesDepartmentName(promotionPlanVo.getSalesDepartmentName());
            promotionPlanTableForm.setOrgCode(promotionPlanVo.getOrgCode());
            promotionPlanTableForm.setOrgName(promotionPlanVo.getOrgName());
            promotionPlanTableForm.setYearAndMonth(nowDate.substring(0,7));
            promotionPlanTableForm.setNetIncomeContemporaneous(netIncomeContemporaneous);
            promotionPlanTableForm.setNetIncomeBudget(netIncomeBudget);
            promotionPlanTableForm.setNetIncomePlan(netIncomePlan);
            promotionPlanTableForm.setIncomeAchievement(incomeAchievement);
            promotionPlanTableForm.setVsContemporaneous(vsContemporaneous);
            promotionPlanTableForm.setVsBudget(vsBudget);
            promotionPlanTableForm.setContemporaneousSpecialExpenseRate(contemporaneousSpecialExpenseRate);
            promotionPlanTableForm.setBudgetSpecialExpenseRate(budgetSpecialExpenseRate);
            promotionPlanTableForm.setPlanSpecialExpenseRate(planSpecialExpenseRate);
            promotionPlanTableForm.setExpenseRateVsContemporaneous(expenseRateVsContemporaneous);
            promotionPlanTableForm.setExpenseRateVsBudget(expenseRateVsBudget);
            promotionPlanTableForm.setBudgetNetProfit(netProfitBudget);
            promotionPlanTableForm.setPlannedNetProfit(netProfitPlan);
            promotionPlanTableForm.setContemporaneousNetProfit(netProfitContemporaneous);
            promotionPlanTableForm.setBudgetProfitMargin(budgetProfitMargin);
            promotionPlanTableForm.setPlannedProfitMargin(plannedProfitMargin);
            promotionPlanTableForm.setProfitMarginReached(profitMarginReached);
            promotionPlanTableForm.setLevelCode(PromotionPlanConstant.DEPARTMENT);
            list.add(promotionPlanTableForm);
        }

        log.info("构建数据完成,开始插入数据到数据库!");
        if (!CollectionUtils.isEmpty(list)) {
            List<PromotionPlanTableForm> updateList = new ArrayList<>();
            List<PromotionPlanTableForm> saveList = new ArrayList<>();
            List<String> onlyKeys = list.stream().map(PromotionPlanTableForm::getOnlyKey).distinct().collect(Collectors.toList());
            List<PromotionPlanTableForm> byOnlyKey = this.promotionPlanTableFormRepository.findByOnlyKey(onlyKeys, tenantCode, delFlag);
            if (CollectionUtils.isEmpty(byOnlyKey)) {
                saveList.addAll(list);
            } else {
                Map<String, String> map = byOnlyKey.stream().collect(Collectors.toMap(PromotionPlanTableForm::getOnlyKey, PromotionPlanTableForm::getId, (a, b) -> a));
                for (PromotionPlanTableForm promotionPlanTableForm : list) {
                    String id = map.get(promotionPlanTableForm.getOnlyKey());
                    if (StringUtils.isNotEmpty(id)) {
                        promotionPlanTableForm.setId(id);
                        updateList.add(promotionPlanTableForm);
                    } else {
                        saveList.add(promotionPlanTableForm);
                    }
                }
            }

            //保存
            if (!CollectionUtils.isEmpty(updateList)) {
                this.promotionPlanTableFormRepository.updateBatchById(updateList);
            }
            if (!CollectionUtils.isEmpty(saveList)) {
                this.promotionPlanTableFormRepository.saveBatch(saveList);
            }
        }
        log.info("数据入库完成!");
    }

    @Override
    public List<PromotionPlanTableFormVo> findByPlatformLevelByDepartmentId(String id) {
        Validate.notNull(id,"未传入id!");
        PromotionPlanTableForm promotionPlanTableForm = this.promotionPlanTableFormRepository.getById(id);
        Validate.notNull(promotionPlanTableForm,"未获取到部门数据!");
        String salesDepartmentCode = promotionPlanTableForm.getOrgCode();
        String yearAndMonth = promotionPlanTableForm.getYearAndMonth();
        List<PromotionPlanTableFormVo> list = this.promotionPlanTableFormRepository.findByPlatformLevelByDepartmentId(salesDepartmentCode,PromotionPlanConstant.DEPARTMENT,yearAndMonth);
        return list;
    }
}
