package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import cn.hutool.core.date.DatePattern;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanResult;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanResultRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanResultProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanWholeSummaryProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanWholeSummaryDetailService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.*;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * @author: yaoyongming
 * @date: 2023/9/11 16:14
 */
@Slf4j
@Service("promotionPlanWholeSummaryDetailService")
public class PromotionPlanWholeSummaryDetailServiceImpl implements PromotionPlanWholeSummaryDetailService {

    @Autowired(required = false)
    private ActualProfitLossService actualProfitLossService;

    @Autowired(required = false)
    private BudgetProfitLossService budgetProfitLossService;

    @Autowired(required = false)
    private PromotionPlanResultRepository promotionPlanResultRepository;

    /**
     * 计算指定年月一览表
     *
     * @param yearMonthLy
     * @return
     */
    @Override
    public List<PromotionPlanWholeSummaryDetailVo> calculationResult(String yearMonthLy) {
        List<PromotionPlanWholeSummaryDetailVo> list = new ArrayList<>();
        LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map = createPromotionPlanResultVoList(yearMonthLy);

        resultProfitLoss(map, yearMonthLy);
        resultPlan(map, yearMonthLy);

        int index = 0;
        for (String  k : map.keySet()) {
            PromotionPlanWholeSummaryDetailVo v = map.get(k);
            v.setPlanVsContemporaneous(bdNull(v.getPlan()).subtract(bdNull(v.getContemporaneous())));
            v.setPlanVsBudget(bdNull(v.getPlan()).subtract(bdNull(v.getBudget())));
            v.setActualPlan(bdNull(v.getActualSub1()).add(bdNull(v.getPlan())));
            v.setActualPlanLast(bdNull(v.getActualSub2()).add(bdNull(v.getPlanSub1())).add(bdNull(v.getPlan())));
            v.setActualPlanVsBudget(bdNull(v.getActualPlan()).subtract(bdNull(v.getBudgetTotal())));
            v.setUseProgress(v.getBudgetTotalYear() == null ? BigDecimal.ZERO : v.getActualPlan().divide(v.getBudgetTotalYear(), 6, RoundingMode.HALF_UP));
            v.setSortIndex(index);
            list.add(v);
            index++;
        }

        return list;
    }

    public void resultPlan(LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map, String yearMonthLy) {
        //当前年份1月至当月数据合计
        String[] split = yearMonthLy.split("-");
        String year = split[0];
        int month = Integer.valueOf(split[1]);
        String startStr = year+ "-01-01";
        String endStr = DateUtil.formatDate(DateUtil.getLastDayOfMonth(DateUtil.strToDate(yearMonthLy + "-01", DateUtil.date_yyyy_MM_dd)));
        List<PromotionPlanResultVo> planResultList = promotionPlanResultRepository.getAllByStartDateAndEndSum(startStr, endStr,PromotionPlanConstant.PAPER, ProcessStatusEnum.PASS.getDictCode());
        if (CollectionUtils.isEmpty(planResultList)) {
            return;
        }
        LinkedHashMap<String, Map<String, BigDecimal>> planMap = planResultList.stream().sorted(Comparator.comparing(PromotionPlanResultVo::getYearMonthLy)).collect(
                Collectors.groupingBy(e -> e.getYearMonthLy(), LinkedHashMap::new, Collectors.toMap(PromotionPlanResultVo::getProjectCode, PromotionPlanResultVo::getPlan)));

        //毛利处理
        planMap.forEach((k, v) ->
                v.put(PromotionPlanWholeSummaryProjectEnum.GROSS.getCode(), v.get(PromotionPlanWholeSummaryProjectEnum.NET_INCOME.getCode()).subtract(v.get(PromotionPlanWholeSummaryProjectEnum.COST.getCode()))));

        Map<String, BigDecimal> thisMonth = planMap.get(yearMonthLy);
        setMapRate(thisMonth);
        setMap(map, thisMonth, PromotionPlanConstant.PLAN);

        if (month > 1) {
            String monthStr = month > 10 ? String.valueOf(month-1) : "0" + (month-1);
            Map<String, BigDecimal> lastMonth = planMap.get(year + "-" + monthStr);
            setMapRate(lastMonth);
            setMap(map, lastMonth, PromotionPlanConstant.PLAN_LAST);
        }

        Map<String, BigDecimal> monthTotal = new HashMap<>();
        for (String k : planMap.keySet()) {
            sumMap(planMap.get(k), monthTotal);
        }
        setMapRate(monthTotal);
        setMap(map, monthTotal, PromotionPlanConstant.PLAN_TOTAL);
    }

    /**
     * 计算损益
     *
     * @param map
     * @param yearMonthLy
     */
    public void resultProfitLoss(LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map, String yearMonthLy) {

        ActualProfitLossVo dtoA = new ActualProfitLossVo();
        BudgetProfitLossVo dtoB = new BudgetProfitLossVo();

        dtoA.setType(PromotionPlanConstant.PAPER);
        dtoB.setType(PromotionPlanConstant.PAPER);

        String[] split = yearMonthLy.split("-");
        String year = split[0];
        String yearBefore = String.valueOf(Integer.valueOf(split[0]) - 1);
        List<String> aMonthList = new ArrayList<>();
        aMonthList.addAll(getMonthList(yearBefore, split[1]));
        if (Integer.valueOf(split[1]) - 1 > 0) {
            aMonthList.addAll(getMonthList(year, String.valueOf(Integer.valueOf(split[1]) - 1)));
        }
        List<ActualProfitLossVo> aList = actualProfitLossService.findProfitLoss(dtoA, aMonthList);
        List<BudgetProfitLossVo> bList = budgetProfitLossService.findProfitLoss(dtoB, getMonthList(year, "12"));

        sumProfitLoss(aList, map,PromotionPlanConstant.ACTUAL, yearBefore + "-" + split[1], Integer.valueOf(split[1]) - 1);
        sumProfitLoss(bList, map,PromotionPlanConstant.BUDGET, yearMonthLy, 1);
    }

    /**
     * 损益汇总
     *
     * @param list
     * @param map
     * @param type
     * @param <T>
     */
    public <T> void sumProfitLoss(List<T> list, LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map, String type, String month, int mm) {
        //折前销售额（千元）	销售额
        //折后含税销售额（千元）	销售额-折扣
        //GMV（千元）	GMV（千元）
        //净收入（千元）	净收入+其他业务收入
        //成本（千元）	直接材料
        //净利润（千元）	净利润
        //折扣费用（千元）	销售费用_销管折扣(含税)
        //报销费用（千元）	销售费用_销管报销(含税)
        //消费者费用（千元）	消费者费用（千元）
        //渠道费用（千元）	渠道费用（千元）
        //投放费用（千元）	投放费用（千元）
        //平台运营费用（千元）	平台运营费用（千元）
        //费用池（千元）	费用池（千元）
        //物流费用（千元）	运输装卸费用+销售费用_仓储费用
        //行政管理费用（千元）	销售费用_行政性费用+管理费用+研发费用
        //毛利（千元）  同期净收入-同期成本

        //毛利率	（同期净收入-同期成本）/同期净收入
        //折扣费用率	折扣费用/折后含税销售额
        //报销费用率	同期报销费用/同期折后含税销售额
        //消费者费用率	同期消费者费用/同期折后含税销售额
        //渠道费用率	同期渠道费用/同期折后含税销售额
        //投放费用率	同期投放费用/同期折后含税销售额
        //平台运营费用率	同期平台运营费用/同期折后含税销售额
        //专项费用率	（折扣费用+报销费用）/折后含税销售额
        //物流费用率	同期物流费用/同期折前销售额
        //净利率	同期净利润/同期净收入

        List<ProfitLossVo> voList = (List<ProfitLossVo>) list;
        LinkedHashMap<String, List<ProfitLossVo>> mapMonth = voList.stream().sorted(Comparator.comparing(ProfitLossVo::getYearMonthly)).collect(
                Collectors.groupingBy(e -> e.getYearMonthly(), LinkedHashMap::new, Collectors.toList()));

        LinkedHashMap<String, Map<String, BigDecimal>> monthMapFee = new LinkedHashMap<>();
        for (String k : mapMonth.keySet()) {
            List<ProfitLossVo> monthVolist = mapMonth.get(k);
            //折前销售额（千元）
            BigDecimal discountBeforeSale = BigDecimal.ZERO;
            //折后销售额（千元）
            BigDecimal discountAfterSale = BigDecimal.ZERO;
            //GMV
            BigDecimal gmv = BigDecimal.ZERO;
            //净收入（千元）
            BigDecimal netIncome = BigDecimal.ZERO;
            //成本（千元）
            BigDecimal cost = BigDecimal.ZERO;
            //净利润（千元）
            BigDecimal netProfit = BigDecimal.ZERO;
            //折扣费用（千元）
            BigDecimal discount = BigDecimal.ZERO;
            //报销费用（千元）
            BigDecimal reimbursement = BigDecimal.ZERO;
            //消费者费用（千元）
            BigDecimal consumer = BigDecimal.ZERO;
            //渠道费用（千元）
            BigDecimal channel = BigDecimal.ZERO;
            //投放费用（千元）
            BigDecimal put = BigDecimal.ZERO;
            //平台运营费用（千元）
            BigDecimal platformOperate = BigDecimal.ZERO;
            //费用池（千元）
            BigDecimal feePool = BigDecimal.ZERO;
            //物流费用（千元）
            BigDecimal logistics = BigDecimal.ZERO;
            //行政管理费用（千元）
            BigDecimal admin = BigDecimal.ZERO;
            //毛利（千元）
            BigDecimal gross = BigDecimal.ZERO;

            Map<String, BigDecimal> mapFee = new HashMap();
            for (ProfitLossVo vo : monthVolist) {
                discountBeforeSale = discountBeforeSale.add(bdNull(vo.getSaleAmount()));
                discountAfterSale = discountAfterSale.add(bdNull(vo.getSaleAmount())
                        .subtract(bdNull(vo.getDiscountSub())));
                gmv = gmv.add(bdNull(vo.getGmv()));
                netIncome = netIncome.add(bdNull(vo.getNetIncome())
                        .add(bdNull(vo.getOthersAdd())));
                cost = cost.add(bdNull(vo.getDirectMaterial()));
                netProfit = netProfit.add(bdNull(vo.getNetProfit()));
                discount = discount.add(bdNull(vo.getSaleFeeSaleDiscount()));
                reimbursement = reimbursement.add(bdNull(vo.getSaleFeeReimburse()));
                consumer = consumer.add(bdNull(vo.getConsumer()));
                channel = channel.add(bdNull(vo.getChannel()));
                put = put.add(bdNull(vo.getPut()));
                platformOperate = platformOperate.add(bdNull(vo.getPlatformOperate()));
                feePool = feePool.add(bdNull(vo.getFeePool()));
                logistics = logistics.add(bdNull(vo.getTransportHandling())
                        .add(bdNull(vo.getSaleFeeInventory())));
                admin = admin.add(bdNull(vo.getSaleFeeAdmin())
                        .add(bdNull(vo.getManage()))
                        .add(bdNull(vo.getDevelopment())));
                gross = gross.add(bdNull(vo.getNetIncome())
                        .add(bdNull(vo.getOthersAdd()))
                        .subtract(bdNull(vo.getDirectMaterial())));
            }

            mapFee.put(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_BEFORE_SALE.getCode(), discountBeforeSale);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_AFTER_SALE.getCode(), discountAfterSale);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.GMV.getCode(), gmv);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.NET_INCOME.getCode(), netIncome);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.COST.getCode(), cost);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT.getCode(), netProfit);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.DISCOUNT.getCode(), discount);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT.getCode(), reimbursement);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.CONSUMER.getCode(), consumer);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.CHANNEL.getCode(), channel);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.PUT.getCode(), put);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE.getCode(), platformOperate);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.FEE_POOL.getCode(), feePool);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.LOGISTICS.getCode(), logistics);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.ADMIN.getCode(), admin);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.GROSS.getCode(), gross);

            monthMapFee.put(k, mapFee);
        }

        //汇总
        int monthInt = Integer.valueOf(month.replace("-", ""));
        //累计
        Map<String, BigDecimal> mapTotal = new HashMap<>();
        //剩余累计预算
        Map<String, BigDecimal> mapSubBudget = new HashMap<>();
        //当年实际-1
        Map<String, BigDecimal> mapSubActual = new HashMap<>();
        //当年实际-2
        Map<String, BigDecimal> mapSubActual2 = new HashMap<>();
        for (String k : monthMapFee.keySet()) {
            int kInt = Integer.valueOf(k.replace("-", ""));
            String[] split = k.split("-");
            if (kInt <= monthInt) {
                sumMap(monthMapFee.get(k), mapTotal);
            } else {
                if (PromotionPlanConstant.BUDGET.equals(type)) {
                    sumMap(monthMapFee.get(k), mapSubBudget);
                } else {
                    if (mm == 0) {
                        continue;
                    }
                    if (Integer.valueOf(split[1]) >= mm) {
                        sumMap(monthMapFee.get(k), mapSubActual);
                        continue;
                    }
                    sumMap(monthMapFee.get(k), mapSubActual);
                    sumMap(monthMapFee.get(k), mapSubActual2);
                }
            }

        }

        Map<String, BigDecimal> thisMonth = monthMapFee.get(month);
        setMapRate(thisMonth);
        setMapRate(mapTotal);
        if (PromotionPlanConstant.BUDGET.equals(type)) {
            setMap(map, thisMonth, PromotionPlanConstant.BUDGET);
            setMap(map, mapTotal, PromotionPlanConstant.BUDGET_TOTAL);
            sumMap(mapTotal, mapSubBudget);
            setMapRate(mapTotal);
            setMap(map, mapTotal, PromotionPlanConstant.BUDGET_YEAR);
        } else {
            setMap(map, thisMonth, PromotionPlanConstant.ACTUAL);
            setMap(map, mapTotal, PromotionPlanConstant.ACTUAL_TOTAL);
            setMap(map, mapSubActual, PromotionPlanConstant.ACTUAL_SUB1);
            setMap(map, mapSubActual2, PromotionPlanConstant.ACTUAL_SUB2);
        }

    }


    /**
     * 创建项目列
     *
     * @return
     */
    private LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> createPromotionPlanResultVoList(String month) {
        LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map = new LinkedHashMap<>();
        List<HashMap<String, String>> enumListMap = getEnumListMap();
        enumListMap.forEach(e -> {
            PromotionPlanWholeSummaryDetailVo vo = new PromotionPlanWholeSummaryDetailVo();
            vo.setTenantCode(TenantUtils.getTenantCode());
            vo.setYearMonthLy(month);
            vo.setProjectCode(e.get("code"));
            vo.setProjectName(e.get("name"));
            map.put(e.get("code"), vo);
        });
        return map;
    }

    /**
     * 保存到map
     *
     * @param dataMap
     * @param thisMonth
     * @param type
     */
    private void setMap(LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> dataMap, Map<String, BigDecimal> thisMonth, String type) {
        if (thisMonth == null || thisMonth.isEmpty()) {
            return;
        }
        for (PromotionPlanWholeSummaryProjectEnum ppEnum : EnumSet.allOf(PromotionPlanWholeSummaryProjectEnum.class)) {
            String k = ppEnum.getCode();
            switch (type) {
                case PromotionPlanConstant.BUDGET :
                    dataMap.get(k).setBudget(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.ACTUAL :
                    dataMap.get(k).setContemporaneous(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.BUDGET_TOTAL :
                    dataMap.get(k).setBudgetTotal(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.ACTUAL_TOTAL :
                    dataMap.get(k).setContemporaneousTotal(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.BUDGET_YEAR :
                    dataMap.get(k).setBudgetTotalYear(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.ACTUAL_SUB1 :
                    dataMap.get(k).setActualSub1(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.ACTUAL_SUB2 :
                    dataMap.get(k).setActualSub2(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.PLAN :
                    dataMap.get(k).setPlan(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.PLAN_LAST :
                    dataMap.get(k).setPlanSub1(thisMonth.get(ppEnum.getCode()));
                    break;
                case PromotionPlanConstant.PLAN_TOTAL:
                    dataMap.get(k).setPlanTotal(thisMonth.get(ppEnum.getCode()));
                    break;
                default:
            }
        }
    }

    /**
     * 汇总计算
     *
     * @param thisMonth
     * @param mapTotal
     */
    private void sumMap(Map<String, BigDecimal> thisMonth, Map<String, BigDecimal> mapTotal) {
        for (PromotionPlanWholeSummaryProjectEnum ppEnum : EnumSet.allOf(PromotionPlanWholeSummaryProjectEnum.class)) {
            String k = ppEnum.getCode();
            if (k.equals(PromotionPlanWholeSummaryProjectEnum.GROSS_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.CONSUMERT_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.CHANNEL_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.PUT_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.SPECIAL_COST.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.LOGISTICS_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT_RATE.getCode())) {
                continue;
            }
            if (!mapTotal.containsKey(k)) {
                mapTotal.put(k, BigDecimal.ZERO);
            }
            mapTotal.put(ppEnum.getCode(), mapTotal.get(k).add(thisMonth.get(ppEnum.getCode())));
        }
    }

    /**
     * 计算费用率
     *
     * @param thisMonth
     */
    private void setMapRate(Map<String, BigDecimal> thisMonth) {
        if (thisMonth == null || thisMonth.isEmpty()) {
            return;
        }
        //折前销售额（千元）
        BigDecimal discountBeforeSale = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_BEFORE_SALE.getCode());
        //折后销售额（千元）
        BigDecimal discountAfterSale = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_AFTER_SALE.getCode());
        //净收入（千元）
        BigDecimal netIncome = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.NET_INCOME.getCode());
        //成本（千元）
        BigDecimal cost = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.COST.getCode());
        //净利润（千元）
        BigDecimal netProfit = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT.getCode());
        //折扣费用（千元）
        BigDecimal discount = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.DISCOUNT.getCode());
        //报销费用（千元）
        BigDecimal reimbursement = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT.getCode());
        //消费者费用（千元）
        BigDecimal consumer = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.CONSUMER.getCode());
        //渠道费用（千元）
        BigDecimal channel = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.CHANNEL.getCode());
        //投放费用（千元）
        BigDecimal put = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.PUT.getCode());
        //平台运营费用（千元）
        BigDecimal platformOperate = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE.getCode());
        //物流费用（千元）
        BigDecimal logistics = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.LOGISTICS.getCode());

        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.GROSS_RATE.getCode(), netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                (netIncome.subtract(cost)).divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                discount.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                reimbursement.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.CONSUMERT_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                consumer.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.CHANNEL_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                channel.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.PUT_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                put.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                platformOperate.divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.SPECIAL_COST.getCode(), discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : 
                discount.add(reimbursement).divide(discountAfterSale, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.LOGISTICS_RATE.getCode(), discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                logistics.divide(discountBeforeSale, 4, BigDecimal.ROUND_HALF_UP));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT_RATE.getCode(), netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO :
                netProfit.divide(netIncome, 4, BigDecimal.ROUND_HALF_UP));
    }

    /**
     * 枚举转list
     *
     * @param
     * @return
     */
    private List<HashMap<String, String>> getEnumListMap() {
        List<HashMap<String, String>> list = new ArrayList<>();
        for (PromotionPlanWholeSummaryProjectEnum ppEnum : EnumSet.allOf(PromotionPlanWholeSummaryProjectEnum.class)) {
            HashMap<String, String> map = new HashMap<>();
            map.put("name", ppEnum.getName());
            map.put("code", ppEnum.getCode());
            list.add(map);
        }

        return list;
    }



    /**
     * vo转换
     *
     * @param cahchResult
     * @return
     */
    @Override
    public List<PromotionPlanWholeSummaryDetailStrVo> voChange(LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> cahchResult) {
        List<PromotionPlanWholeSummaryDetailStrVo> strVoList = new ArrayList<>();
        cahchResult.forEach((k, v) -> {
            PromotionPlanWholeSummaryDetailStrVo strVo = new PromotionPlanWholeSummaryDetailStrVo()
                    .setProjectName(v.getProjectName());
            if (k.equals(PromotionPlanWholeSummaryProjectEnum.GROSS_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.CONSUMERT_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.CHANNEL_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.PUT_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.SPECIAL_COST.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.LOGISTICS_RATE.getCode()) ||
                    k.equals(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT_RATE.getCode())) {
                strVo.setPlan(v.getPlan().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setPlanTotal(v.getPlanTotal().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setContemporaneous(bdNull(v.getContemporaneous()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setContemporaneousTotal(bdNull(v.getContemporaneousTotal()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setBudget(bdNull(v.getBudget()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setBudgetTotal(bdNull(v.getBudgetTotal()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setPlanVsContemporaneous(v.getPlanVsContemporaneous().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setPlanVsBudget(v.getPlanVsBudget().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setActualPlan(v.getActualPlan().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setActualPlanLast(v.getActualPlanLast().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%")
                        .setActualPlanVsBudget(v.getActualPlanVsBudget().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%");
            } else {
                strVo.setPlan((v.getPlan() == null ? BigDecimal.ZERO : v.getPlan()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setPlanTotal((v.getPlanTotal() == null ? BigDecimal.ZERO : v.getPlanTotal()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setContemporaneous((v.getContemporaneous() == null ? BigDecimal.ZERO : v.getContemporaneous()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setContemporaneousTotal((v.getContemporaneousTotal() == null ? BigDecimal.ZERO : v.getContemporaneousTotal()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setBudget((v.getBudget() == null ? BigDecimal.ZERO : v.getBudget()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setBudgetTotal((v.getBudgetTotal() == null ? BigDecimal.ZERO : v.getBudgetTotal()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setPlanVsContemporaneous((v.getPlanVsContemporaneous() == null ? BigDecimal.ZERO : v.getPlanVsContemporaneous()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setPlanVsBudget((v.getPlanVsBudget() == null ? BigDecimal.ZERO : v.getPlanVsBudget()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setActualPlan((v.getActualPlan() == null ? BigDecimal.ZERO : v.getActualPlan()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setActualPlanLast((v.getActualPlanLast() == null ? BigDecimal.ZERO : v.getActualPlanLast()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setActualPlanVsBudget((v.getActualPlanVsBudget() == null ? BigDecimal.ZERO : v.getActualPlanVsBudget()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setBudgetTotalYear((v.getBudgetTotalYear() == null ? BigDecimal.ZERO : v.getBudgetTotalYear()).setScale(3, RoundingMode.HALF_UP).toString())
                        .setUseProgress(bdNull(v.getUseProgress()).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP) + "%");
            }
            strVoList.add(strVo);
        });
        return strVoList;
    }

    /**
     * 获取所属年份所有年月
     *
     * @param year
     * @param month
     * @return
     */
    private List<String> getMonthList(String year, String month) {
        List<String> monthList = new ArrayList<>();
        int monthInt = Integer.parseInt(month);
        for (int i = 1; i <= monthInt; i++) {
            if (i < 10) {
                monthList.add(year + "-0" + i);
            } else {
                monthList.add(year + "-" + i);
            }
        }
        return monthList;
    }

    private BigDecimal bdNull(BigDecimal b) {
        return b == null ? BigDecimal.ZERO : b;
    }
}
