package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanWholeSummary;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanWholeSummaryDetail;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanWholeSummaryDetailRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanWholeSummaryRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanWholeSummaryDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanWholeSummaryProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanWholeSummaryDetailService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanWholeSummaryService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanWholeSummaryDetailStrVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanWholeSummaryDetailVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: yaoyongming
 * @date: 2023/9/11 16:14
 */
@Slf4j
@Service("promotionPlanWholeSummaryService")
public class PromotionPlanWholeSummaryServiceImpl implements PromotionPlanWholeSummaryService {

    @Autowired(required = false)
    private PromotionPlanWholeSummaryRepository promotionPlanWholeSummaryRepository;
    @Autowired(required = false)
    private PromotionPlanWholeSummaryDetailRepository promotionPlanWholeSummaryDetailRepository;
    @Autowired(required = false)
    private PromotionPlanWholeSummaryDetailService promotionPlanWholeSummaryDetailService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required = false)
    private FileHandleService fileHandleService;

    @Value("${venus.file.fileRoot}")
    public String fileRoot;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void createPromotionPlanWholeSummary(String yearMonthLy) {
        if (StringUtils.isBlank(yearMonthLy)) {
            //默认获取上一月的数据
            yearMonthLy = DateUtil.getDateStrByFormat(DateUtil.dateAddMonth(new Date(), -1), DateUtil.DEFAULT_YEAR_MONTH);
        }
        PromotionPlanWholeSummary entity = promotionPlanWholeSummaryRepository.findByYearMonth(yearMonthLy);
        if (entity != null) {
            promotionPlanWholeSummaryDetailRepository.deleteYearMonth(yearMonthLy);
            promotionPlanWholeSummaryRepository.deleteYearMonth(yearMonthLy);
//            fileHandleService.deleteFiles(new String[]{entity.getFileCode()});
        }

        List<PromotionPlanWholeSummaryDetailVo> promotionPlanWholeSummaryDetailVos = promotionPlanWholeSummaryDetailService.calculationResult(yearMonthLy);

        PromotionPlanWholeSummary newEntity = new PromotionPlanWholeSummary();
        newEntity.setTenantCode(TenantUtils.getTenantCode());
        newEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newEntity.setYearMonthLy(yearMonthLy);
        newEntity.setWholeSummaryName(yearMonthLy + "促销规划整体一览表");
        newEntity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());

        FileDto fileDto = toExcel(promotionPlanWholeSummaryDetailVos, newEntity.getWholeSummaryName());

        newEntity.setFileCode(fileDto.getFileCode());
        newEntity.setOriginalFileName(fileDto.getOriginalFileName());
        promotionPlanWholeSummaryRepository.save(newEntity);
        if (CollectionUtils.isNotEmpty(promotionPlanWholeSummaryDetailVos)) {
            Collection<PromotionPlanWholeSummaryDetail> details = nebulaToolkitService.copyCollectionByWhiteList(promotionPlanWholeSummaryDetailVos, PromotionPlanWholeSummaryDetailVo.class, PromotionPlanWholeSummaryDetail.class, LinkedHashSet.class, ArrayList.class);

            promotionPlanWholeSummaryDetailRepository.saveBatch(details);
        }
    }

    /**
     * 提交审批
     *
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void submitApproval(PromotionPlanWholeSummaryDto dto) {
        Validate.isTrue(Objects.nonNull(dto.getProcessBusiness()), "流程参数不能为空");
        PromotionPlanWholeSummary entity = promotionPlanWholeSummaryRepository.getById(dto.getId());
        Validate.notNull(entity, "未找到对应的一览表数据");
        PromotionPlanWholeSummaryDto wholeSummaryDto = nebulaToolkitService.copyObjectByWhiteList(entity, PromotionPlanWholeSummaryDto.class, HashSet.class, ArrayList.class);

        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(wholeSummaryDto.getWholeSummaryName());
        JSONObject jsonObject = JsonUtils.toJSONObject(wholeSummaryDto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(PromotionPlanConstant.PROMOTION_PLAN_PROCESS);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);

        entity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        entity.setProcessNo(processBusinessVo.getProcessNo());
        this.promotionPlanWholeSummaryRepository.saveOrUpdate(entity);
    }

    /**
     * 根据年月获取一览表明细
     *
     * @param yearMonthLy
     * @return
     */
    @Override
    public List<PromotionPlanWholeSummaryDetailStrVo> getPromotionPlanWholeSummaryDetail(String yearMonthLy) {
        List<PromotionPlanWholeSummaryDetail> details = promotionPlanWholeSummaryDetailRepository.findByYearMonth(yearMonthLy);
        List<PromotionPlanWholeSummaryDetailVo> voList = (List<PromotionPlanWholeSummaryDetailVo>) nebulaToolkitService.copyCollectionByWhiteList(details, PromotionPlanWholeSummaryDetail.class, PromotionPlanWholeSummaryDetailVo.class, LinkedHashSet.class, ArrayList.class);

        LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map = voList.stream().collect(Collectors.toMap(e -> e.getProjectCode(), Function.identity(), (o, n) -> n, LinkedHashMap::new));
        return promotionPlanWholeSummaryDetailService.voChange(map);
    }

    /**
     * 转换为Excel，并上传服务器
     *
     * @param voList
     * @return
     */
    public FileDto toExcel(List<PromotionPlanWholeSummaryDetailVo> voList, String wholeSummaryName) {
        FileDto fileDto = new FileDto();
        LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map = voList.stream().collect(Collectors.toMap(e -> e.getProjectCode(), Function.identity(), (o, n) -> n, LinkedHashMap::new));

        List<PromotionPlanWholeSummaryDetailStrVo> voStrList = promotionPlanWholeSummaryDetailService.voChange(map);

        log.info("生成excel：创建开始");
        File dir = new File(fileRoot);
        if (!dir.exists()) {
            log.info("生成excel：新建目录");
            dir.mkdirs();
        }
        String excelName = wholeSummaryName + System.currentTimeMillis() + ".xlsx";
        String fileName = fileRoot + "/" +  excelName;
        //文件流会自动关闭
        EasyExcel.write(fileName, PromotionPlanWholeSummaryDetailStrVo.class)
                .sheet(wholeSummaryName)
                .doWrite(voStrList);

        File file = new File(fileName);
        // 上传到文件服务器
        byte[] fileByte = new byte[(int) file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int read = fileInputStream.read(fileByte);
            OrdinaryFileVo ordinaryFileVo = fileHandleService.fileUpload("default", TenantUtils.getTenantCode(), null,
                    excelName, fileByte);
            Validate.notNull(ordinaryFileVo, "一览表excel文件生成失败!!! 名称：[%s]", wholeSummaryName);
            fileDto.setFileCode(ordinaryFileVo.getId());
            fileDto.setOriginalFileName(ordinaryFileVo.getOriginalFileName());
        } catch (IOException e) {
            log.info("生成excel：上传异常：" + e.getMessage());
            throw new RuntimeException(e);
        } finally {
            if (Objects.nonNull(fileInputStream)) {
                try {
                    fileInputStream.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        log.info("上传文件信息：" + JSONObject.toJSONString(fileDto));

        // 删除文件
        boolean delete = file.delete();
        if (delete) {
            log.info("文件删除成功,{}", file.getName());
        } else {
            log.error("文件删除失败,{}", file.getName());
        }
        return fileDto;
    }

}
