package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanCostProgressDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanCostProgressService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressExportsVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author: yaoyongming
 * @date: 2023/8/14 14:03
 */
@Component
@Slf4j
public class PromotionPlanCostProgressExportsProcess implements ExportProcess<PromotionPlanCostProgressExportsVo> {

    @Autowired(required = false)
    private PromotionPlanCostProgressService promotionPlanCostProgressService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    
    /**
     * 获取当前任务需要导出数据总记录数(用于拆分子任务)
     * 存在多租户问题，建议尽快变更
     *
     * @param params 自定义参数
     * @return
     */
    @Override
    public Integer getTotal(Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        Pageable pageable = PageRequest.of(1, 1);
        PromotionPlanCostProgressDto dto = convertParams(params);
        Page<PromotionPlanCostProgressVo> pageResult = this.promotionPlanCostProgressService.findCostProgressByConditions(pageable, dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    /**
     * 数据处理（最终处理）
     *
     * @param vo     导出任务处理器实体信息
     * @param params 扩展参数
     * @return
     */
    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      销售费用批复表导出[{}]    <=====", JSON.toJSONString(vo));
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        PromotionPlanCostProgressDto dto = convertParams(params);
        Page<PromotionPlanCostProgressVo> pageResult = this.promotionPlanCostProgressService.findCostProgressByConditions(pageable, dto);
        if (CollectionUtils.isEmpty(pageResult.getRecords())) {
            return new JSONArray();
        }
        List<PromotionPlanCostProgressVo> records = pageResult.getRecords();
        adjustData(records);
        Collection<PromotionPlanCostProgressExportsVo> data = this.nebulaToolkitService.copyCollectionByWhiteList(records, PromotionPlanCostProgressVo.class, PromotionPlanCostProgressExportsVo.class, LinkedHashSet.class, ArrayList.class);
        //TODO 按照配置导出字段过滤
        return JSON.parseArray(JSON.toJSONString(data, SerializerFeature.WriteDateUseDateFormat));
    }

    /**
     * 导出业务编码
     *
     * @return
     */
    @Override
    public String getBusinessCode() {
        return "PROMOTION_PLAN_COST_PROGRESS_EXPORT";
    }

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    /**
     * 获取参数
     *
     * @param params
     * @return
     */
    private PromotionPlanCostProgressDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), PromotionPlanCostProgressDto.class);
    }

    /**
     * 调整数据
     *
     * @param data
     */
    private void adjustData(Collection<PromotionPlanCostProgressVo> data) {
        //  转换数据字典值
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(
                PromotionPlanConstant.BUSINESS_MODEL));
        for (PromotionPlanCostProgressVo vo : data) {
            vo.setBusinessModelCode(this.findDictValue(mapDict, PromotionPlanConstant.BUSINESS_MODEL, String.valueOf(vo.getBusinessModelCode())));
        }
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }

    /**
     * 导出业务名称
     *
     * @return
     */
    @Override
    public String getBusinessName() {
        return "TPM费用进度监控导出";
    }
}
