package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanTableFormRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanTableFormDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanTableFormExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Class PromotionPlanTableFormProcess
 * @Description 平台维度电商的促销规划一览汇总表导出
 * @Author : cyj
 * @Date: 2023/2/4  17:16
 */
@Component
public class PromotionPlanTableFormProcess implements ExportProcess<PromotionPlanTableFormExportVo> {

    @Autowired(required = false)
    private PromotionPlanTableFormRepository promotionPlanTableFormRepository;


    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        PromotionPlanTableFormDto dto = this.convertParams(params);
        Page<PromotionPlanTableFormExportVo> pageResult = this.promotionPlanTableFormRepository.findExportByConditions(new Page<>(0, 1), dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return ((int) (pageResult.getTotal()));
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
        //分页问题修改
        if(processVo.getPageNo() == null || processVo.getPageSize() ==null){
            throw new IllegalArgumentException("参数错误");
        }
        processVo.setPageNo(processVo.getPageNo()+1);
        PromotionPlanTableFormDto dto = this.convertParams(params);
        Page<PromotionPlanTableFormDto> pageable = new Page<>(processVo.getPageNo() + 1, this.getPageSize());
        Page<PromotionPlanTableFormExportVo> page = this.promotionPlanTableFormRepository.findExportByConditions(pageable, dto);
        return JSON.parseArray(JSON.toJSONString((page.getRecords())));
    }

    @Override
    public Class<PromotionPlanTableFormExportVo> findCrmExcelVoClass() {
        return PromotionPlanTableFormExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "TPM_PROMOTION_PLAN_TABLE_FORM";
    }

    @Override
    public String getBusinessName() {
        return "TPM-平台维度电商的促销规划一览汇总表导出";
    }

    /**
     * 转换参数
     *
     * @param params 传递参数
     * @return 转换结果
     */
    private PromotionPlanTableFormDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue,(a, b)->a));
        PromotionPlanTableFormDto dto = JSON.parseObject(JSON.toJSONString(map), PromotionPlanTableFormDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return dto;
    }
}
