package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PurchaseSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PurchaseSaleExportsVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PurchaseSaleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 采销库存导出
 *
 * @author: yaoyongming
 * @date: 2023/2/6 15:34
 */
@Slf4j
@Component
public class PurchaseSaleExportsProcess implements ExportProcess<PurchaseSaleExportsVo> {

    @Autowired(required = false)
    private PurchaseSaleService purchaseSaleService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    /**
     * 获取当前任务需要导出数据总记录数(用于拆分子任务)
     * 存在多租户问题，建议尽快变更
     *
     * @param params 自定义参数
     * @return
     */
    @Override
    public Integer getTotal(Map<String, Object> params) {
        log.info("=========获取采销库存导出总记录数");
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        log.info("=========cacheKey：" + params.get("cacheKey"));
        Integer total = purchaseSaleService.getTotal((String) params.get("cacheKey"));
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        log.info("=========total：" + total);
        return total;
    }

    /**
     * 数据处理（最终处理）
     *
     * @param vo     导出任务处理器实体信息
     * @param params 扩展参数
     * @return
     */
    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        log.info("=========开始采销库存导出");
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        Page<PurchaseSaleVo> cachePage = purchaseSaleService.findCachePageList(pageable, cacheKey, params.get("promotionPlanCode") == null ? null : (String) params.get("promotionPlanCode"));
        log.info("=========获取费用申请导出总记录数：" + cachePage.getSize());
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        Collection<PurchaseSaleExportsVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(cachePage.getRecords(), PurchaseSaleVo.class, PurchaseSaleExportsVo.class, LinkedHashSet.class, ArrayList.class);
        log.info("=========结束费用申请导出");
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    /**
     * 导出业务编码
     *
     * @return
     */
    @Override
    public String getBusinessCode() {
        return "TPM_PP_PURCHASE_SALE_EXPORT";
    }

    /**
     * 导出业务名称
     *
     * @return
     */
    @Override
    public String getBusinessName() {
        return "促销规划-采销库存导出";
    }

    /**
     * 获取对象转换实体
     *
     * @return
     */
    @Override
    public Class<PurchaseSaleExportsVo> findCrmExcelVoClass() {
        return PurchaseSaleExportsVo.class;
    }
}
