package com.biz.crm.tpm.business.promotion.plan.local.service.register;

import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionAllResult;
import com.biz.crm.tpm.business.promotion.plan.local.service.PromotionResultRegister;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanParamVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/7/26 15:12
 * @description discountAfterSaleRegister
 */
@Service
public class DiscountAfterSaleRegister extends PromotionResultRegister {
    @Override
    public String planResultCode() {
        return "discount_after_sale";
    }

    @Override
    public String planResultName() {
        return "折后含税销售额（千元）";
    }

    @Override
    public PromotionAllResult buildParam(String date, String projectCode, Map<String, List<ActualProfitLossVo>> actualProfitLossMap,
                                         Map<String, List<BudgetProfitLossVo>> budgetProfitLossMap,
                                         Map<String, List<PromotionPlanParamVo>> paramVoMap, List<ActualProfitLossVo> profitLoss,
                                         List<BudgetProfitLossVo> profitLossByDto, String yearMonthDate,
                                         List<PromotionPlanParamVo> paramVoList, String lastLastMonth, String lastMonth, String lastYearDate) {

        PromotionAllResult promotionAllResult = new PromotionAllResult();
        promotionAllResult.setId(StringUtils.join(date, projectCode));
        //同期 :在损益表-实际，取上一年对应月份所有该行字段数据之和
        List<ActualProfitLossVo> actualProfitLossVos = Optional.ofNullable(actualProfitLossMap.get(lastYearDate)).orElse(new ArrayList<>());
        promotionAllResult.setContemporaneous(Optional.ofNullable(actualProfitLossVos.stream().map(ActualProfitLossVo::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO));
        //预算 :在损益表-预算，取对应月份所有该行字段数据之和
        List<BudgetProfitLossVo> budgetProfitLossVos = Optional.ofNullable(budgetProfitLossMap.get(date)).orElse(new ArrayList<>());
        promotionAllResult.setBudget(Optional.ofNullable(budgetProfitLossVos.stream().map(BudgetProfitLossVo::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO));
        //规划 :取对应月所有促销规划求和汇总值。
        List<PromotionPlanParamVo> promotionPlanParamVos = Optional.ofNullable(paramVoMap.get(date)).orElse(new ArrayList<>());
        promotionAllResult.setPlan(Optional.ofNullable(promotionPlanParamVos.stream().filter(vo -> StringUtils.isNotEmpty(vo.getProjectCode()) && StringUtils.equals(vo.getProjectCode(), this.planResultCode())).map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO));
        //规划VS同期 : 规划列-同期列
        promotionAllResult.setPlanVsContemporaneous(promotionAllResult.getPlan().subtract(promotionAllResult.getContemporaneous()));
        //规划VS预算 : 规划列-预算列
        promotionAllResult.setPlanVsBudget(promotionAllResult.getPlan().subtract(promotionAllResult.getBudget()));
        //累计同期 : 在损益表-实际，取上一年1月到对应月份所有该行字段数据之和
        List<ActualProfitLossVo> lastYearActualProfitLoss = Optional.ofNullable(profitLoss.stream().filter(vo -> vo.getYearMonthly().compareTo(date) <= 0).collect(Collectors.toList())).orElse(new ArrayList<>());
        promotionAllResult.setContemporaneousTotal(Optional.ofNullable(lastYearActualProfitLoss.stream().map(ActualProfitLossVo::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO));
        //累计预算 : 在损益表-预算，取1到对应月份所有该行字段数据之和
        List<BudgetProfitLossVo> yearBudgetProfitLossVos = Optional.ofNullable(profitLossByDto.stream().filter(vo -> vo.getYearMonthly().compareTo(date) <= 0 && vo.getYearMonthly().compareTo(yearMonthDate) >= 0).collect(Collectors.toList())).orElse(new ArrayList<>());
        promotionAllResult.setBudgetTotal(Optional.ofNullable(yearBudgetProfitLossVos.stream().map(BudgetProfitLossVo::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO));
        //累计实际&规划（当月） : 取1到当月所有促销规划该位置数据之和汇总(eg：2023-07的促销规划，取2023-01到2023-06的实际+2023-07的规划)
        if (date.substring(2, 4).compareTo("02") >= 0) {
            List<PromotionPlanParamVo> paramVos = Optional.ofNullable(paramVoList.stream().filter(vo -> vo.getStartDate().substring(0, 4).compareTo(lastMonth) <= 0 && vo.getStartDate().substring(0, 4).compareTo(yearMonthDate) >= 0 && StringUtils.equals(vo.getProjectCode(), this.planResultCode())).collect(Collectors.toList())).orElse(new ArrayList<>());
            BigDecimal actual = Optional.ofNullable(paramVos.stream().map(PromotionPlanParamVo::getActualPlan).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
            BigDecimal plan = promotionAllResult.getPlan();
            promotionAllResult.setActualPlan(actual.add(plan));
        } else {
            promotionAllResult.setActualPlan(promotionAllResult.getPlan());
        }
        //累计实际&规划（当月+上月） : 取1到上月所有促销规划该位置数据之和汇总(eg：2023-07的促销规划，取2023-01到2023-05的实际+2023-06的规划+2023-07的规划)
        if (date.substring(2, 4).compareTo("03") >= 0) {
            List<PromotionPlanParamVo> paramVos = paramVoList.stream().filter(vo -> vo.getStartDate().substring(0, 4).compareTo(lastLastMonth) <= 0 && vo.getStartDate().substring(0, 4).compareTo(yearMonthDate) >= 0 &&  StringUtils.equals(vo.getProjectCode(), this.planResultCode())).collect(Collectors.toList());
            BigDecimal actual = Optional.ofNullable(paramVos.stream().map(PromotionPlanParamVo::getActualPlan).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
            List<PromotionPlanParamVo> lastPromotion = Optional.ofNullable(paramVoMap.get(lastMonth)).orElse(new ArrayList<>());
            BigDecimal lastPromotionPlan = Optional.ofNullable(lastPromotion.stream().filter(vo -> StringUtils.equals(vo.getProjectCode(), this.planResultCode())).map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
            List<PromotionPlanParamVo> lastLastPromotion = Optional.ofNullable(paramVoMap.get(lastLastMonth)).orElse(new ArrayList<>());
            BigDecimal lastLastMonthBudgetAmount = Optional.ofNullable(lastLastPromotion.stream().filter(vo -> StringUtils.equals(vo.getProjectCode(), this.planResultCode())).map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
            promotionAllResult.setActualPlanMonth(actual.add(lastPromotionPlan).add(lastLastMonthBudgetAmount));
        } else if (date.substring(2, 4).compareTo("02") == 0) {
            List<PromotionPlanParamVo> promotion = Optional.ofNullable(paramVoMap.get(date)).orElse(new ArrayList<>());
            BigDecimal lastPromotionPlan = Optional.ofNullable(promotion.stream().filter(vo -> StringUtils.equals(vo.getProjectCode(), this.planResultCode())).map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
            List<PromotionPlanParamVo> lastPromotion = Optional.ofNullable(paramVoMap.get(lastMonth)).orElse(new ArrayList<>());
            BigDecimal lastLastPromotionPlan = Optional.ofNullable(lastPromotion.stream().filter(vo -> StringUtils.equals(vo.getProjectCode(), this.planResultCode())).map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
            promotionAllResult.setActualPlanMonth(lastPromotionPlan.add(lastLastPromotionPlan));
        } else if (date.substring(2, 4).compareTo("01") == 0) {
            List<PromotionPlanParamVo> promotion = Optional.ofNullable(paramVoMap.get(date)).orElse(new ArrayList<>());
            BigDecimal lastPromotionPlan = Optional.ofNullable(promotion.stream().filter(vo -> StringUtils.equals(vo.getProjectCode(), this.planResultCode())).map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
            promotionAllResult.setActualPlanMonth(lastPromotionPlan);
        }
        //累计实际&规划vs累计预算 : 累计实际&规划-累计预算
        promotionAllResult.setActualPlan(promotionAllResult.getActualPlan().subtract(promotionAllResult.getBudgetTotal()));
        // TODO: 2023/7/26          //年预算累计

        //使用进度 : 累计实际&规划/累计预算
        if (BigDecimal.ZERO.compareTo(promotionAllResult.getBudgetTotal()) != 0) {
            promotionAllResult.setUseProgress(promotionAllResult.getActualPlan().divide(promotionAllResult.getBudgetTotal(), 6, BigDecimal.ROUND_HALF_UP));
        }
        return promotionAllResult;
    }
}
