package com.biz.crm.tpm.business.promotion.plan.local.workFlowListener;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanEntity;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanMqTagConstant;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * 促销规划流程回调
 *
 * @author: yaoyongming
 * @date: 2022/12/26 9:57
 */
@Component
@Slf4j
public class PromotionPlanProcessCallBackListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private PromotionPlanRepository promotionPlanRepository;
    @Autowired(required = false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    /**
     * 获取流程业务编号(默认为空)
     */
    @Override
    public String getBusinessCode() {
        return PromotionPlanConstant.PROMOTION_PLAN_PROCESS;
    }

    /**
     * 当流程开始后触发该事件
     *
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        String processStatus = dto.getProcessStatus();
        PromotionPlanEntity one = promotionPlanRepository.lambdaQuery()
                .eq(PromotionPlanEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(PromotionPlanEntity::getPromotionPlanCode, dto.getBusinessNo())
                .one();
        //校验回调实例
        Validate.notNull(one, "促销规划审批流程回调失败，未查询到当前实例");
        promotionPlanRepository.updateProcessStatusById(one.getId(), processStatus);
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            String businessNo = one.getPromotionPlanCode();
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic(PromotionPlanConstant.TPM_PROMOTION_PLAN_PASS_PUSH_DATAILED_FORECAST_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(PromotionPlanMqTagConstant.PROMOTION_PLAN_PASS_DETAILED_FORECAST);
            rocketMqProducer.sendMqMsg(mqMessageVo,10);
            //审批驳回    流程追回
        } else if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)
                || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            PromotionPlanDto promotionPlanDto = nebulaToolkitService.copyObjectByWhiteList(one, PromotionPlanDto.class, HashSet.class, ArrayList.class);
            promotionPlanService.rejectRecover(promotionPlanDto);
        }
    }
}
