package com.biz.crm.tpm.business.promotion.plan.local.workFlowListener;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanWholeSummary;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanWholeSummaryRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanWholeSummaryDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * @author: yaoyongming
 * @date: 2023/9/11 18:53
 */
@Component
@Slf4j
public class PromotionPlanWholeSummaryProcessCallBackListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private PromotionPlanWholeSummaryRepository promotionPlanWholeSummaryRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    
    /**
     * 获取流程业务编号(默认为空)
     */
    @Override
    public String getBusinessCode() {
        return PromotionPlanConstant.PROMOTION_PLAN_WHOLE_SUMMARY_PROCESS;
    }

    /**
     * 当流程开始后触发该事件
     *
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        String processStatus = dto.getProcessStatus();
        PromotionPlanWholeSummary one = promotionPlanWholeSummaryRepository.lambdaQuery()
                .eq(PromotionPlanWholeSummary::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(PromotionPlanWholeSummary::getWholeSummaryName, dto.getBusinessNo())
                .one();
        //校验回调实例
        Validate.notNull(one, "促销规划整体一览表审批流程回调失败，未查询到当前实例");
        PromotionPlanWholeSummary two = new PromotionPlanWholeSummary();
        two.setId(one.getId());
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            two.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            this.promotionPlanWholeSummaryRepository.updateById(two);
            //审批驳回
        } else if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
            PromotionPlanWholeSummaryDto promotionPlanDto = nebulaToolkitService.copyObjectByWhiteList(one, PromotionPlanWholeSummaryDto.class, HashSet.class, ArrayList.class);
            two.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
            this.promotionPlanWholeSummaryRepository.updateById(two);
            //流程追回
        } else if (ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            PromotionPlanWholeSummaryDto promotionPlanDto = nebulaToolkitService.copyObjectByWhiteList(one, PromotionPlanWholeSummaryDto.class, HashSet.class, ArrayList.class);
            two.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
            this.promotionPlanWholeSummaryRepository.updateById(two);
        }
    }
}
