/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthSaleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/currentMonthSale"})
@Api(tags={"\u4fc3\u9500\u89c4\u5212\uff1a\u5f53\u6708\u9500\u552e"})
public class CurrentMonthSaleController {
    private static final Logger log = LoggerFactory.getLogger(CurrentMonthSaleController.class);
    @Autowired(required=false)
    private CurrentMonthSaleService currentMonthSaleService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<CurrentMonthSaleVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="currentMonthSale", value="\u5f53\u6708\u9500\u552e\u5b9e\u4f53\u7c7b") CurrentMonthSaleDto currentMonthSale) {
        try {
            Page page = this.currentMonthSaleService.findByConditions(pageable, currentMonthSale);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u660e\u7ec6\u5217\u8868\u7f13\u5b58\u5206\u9875\u63a5\u53e3")
    @GetMapping(value={"findCachePageList"})
    public Result<Page<CurrentMonthSaleVo>> findCachePageList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="promotionPlanCode", value="\u4fc3\u9500\u89c4\u5212\u7f16\u7801") @RequestParam(required=false) String promotionPlanCode) {
        try {
            Page page = this.currentMonthSaleService.findCachePageList(pageable, cacheKey, promotionPlanCode);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u4e00\u884c\u63a5\u53e3\uff0c\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u540e\uff0c\u5728\u7f13\u5b58\u4e2d\u884c\u9996\u63d2\u5165\u4e00\u6761\u6570\u636e\u5e76\u8fd4\u56de\u7b2c\u4e00\u9875\u6570\u636e")
    @PostMapping(value={"addItemCache"})
    public Result<Page<CurrentMonthSaleVo>> addItemCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e") @RequestBody List<CurrentMonthSaleDto> itemList) {
        try {
            this.currentMonthSaleService.addItemCache(cacheKey, itemList);
            Page page = this.currentMonthSaleService.findCachePageList(pageable, cacheKey, null);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u590d\u5236\u884c\u63a5\u53e3\uff0c\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u540e\uff0c\u5728\u7f13\u5b58\u4e2d\u884c\u9996\u590d\u5236\u9009\u4e2d\u6570\u636e\u5e76\u8fd4\u56de\u7b2c\u4e00\u9875\u6570\u636e")
    @PostMapping(value={"copyItemListCache"})
    public Result<Page<CurrentMonthSaleVo>> copyItemListCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e\uff0c\u5305\u542b\u8981\u590d\u5236\u7684\u884c\u52fe\u9009\u4fe1\u606f") @RequestBody List<CurrentMonthSaleDto> itemList) {
        try {
            this.currentMonthSaleService.copyItemListCache(cacheKey, itemList);
            Page page = this.currentMonthSaleService.findCachePageList(pageable, cacheKey, null);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u5230\u7f13\u5b58\u5e76\u8fd4\u56de\u6307\u5b9a\u9875\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"saveCurrentPageCache"})
    public Result<Page<CurrentMonthSaleVo>> saveCurrentPageCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e") @RequestBody List<CurrentMonthSaleDto> saveList) {
        try {
            this.currentMonthSaleService.saveCurrentPageCache(cacheKey, saveList);
            Page page = this.currentMonthSaleService.findCachePageList(pageable, cacheKey, null);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u591a\u884c\u5220\u9664\u5e76\u8fd4\u56de\u6307\u5b9a\u9875\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"deleteCacheList"})
    public Result<Page<CurrentMonthSaleVo>> deleteCacheList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e\uff0c\u5305\u542b\u8981\u5220\u9664\u7684\u884c\u52fe\u9009\u4fe1\u606f") @RequestBody List<CurrentMonthSaleDto> itemList) {
        try {
            this.currentMonthSaleService.deleteCacheList(cacheKey, itemList);
            Page page = this.currentMonthSaleService.findCachePageList(pageable, cacheKey, null);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6e05\u7406\u7f13\u5b58\u63a5\u53e3")
    @PostMapping(value={"clearCache"})
    public Result clearCache(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            this.currentMonthSaleService.clearCache(cacheKey);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

