/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanCostProgressDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanForEventPrepaymentDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanSubmitDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthDeliveryService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanCostProgressService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthDeliveryVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthSaleVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanForEventPrepaymentVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanResultVoStr;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/promotionPlan"})
@Api(tags={"\u4fc3\u9500\u89c4\u5212"})
public class PromotionPlanController {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanController.class);
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private CurrentMonthSaleService currentMonthSaleService;
    @Autowired(required=false)
    private CurrentMonthDeliveryService currentMonthDeliveryService;
    @Autowired(required=false)
    private PromotionPlanCostProgressService promotionPlanCostProgressService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<PromotionPlanVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="promotionPlan", value="\u4fc3\u9500\u89c4\u5212\u5b9e\u4f53\u7c7b") PromotionPlanDto promotionPlan) {
        try {
            Page page = this.promotionPlanService.findByConditions(pageable, promotionPlan);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findById"})
    public Result<PromotionPlanVo> findById(@RequestParam(value="promotionPlanCode") @ApiParam(name="promotionPlanCode", value="\u4fc3\u9500\u89c4\u5212\u7f16\u7801", required=true) String promotionPlanCode) {
        try {
            PromotionPlanVo promotionPlan = this.promotionPlanService.findById(promotionPlanCode);
            return Result.ok((Object)promotionPlan);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByCode"})
    public Result<PromotionPlanVo> findByCode(@RequestParam(value="promotionPlanCode") @ApiParam(name="promotionPlanCode", value="\u4fc3\u9500\u89c4\u5212\u7f16\u7801", required=true) String promotionPlanCode) {
        try {
            PromotionPlanVo promotionPlan = this.promotionPlanService.findByCode(promotionPlanCode);
            return Result.ok((Object)promotionPlan);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="promotionPlan", value="\u4fc3\u9500\u89c4\u5212\u5b9e\u4f53\u7c7b") @RequestBody PromotionPlanDto promotionPlan, @ApiParam(name="cacheKeySale", value="\u5f53\u6708\u9500\u552e\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeySale, @ApiParam(name="cacheKeyDelivery", value="\u5f53\u6708\u9001\u8d27\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyDelivery, @ApiParam(name="cacheKeyPurchase", value="\u91c7\u9500\u5e93\u5b58\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyPurchase, @ApiParam(name="cacheKeyGeneral", value="\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyGeneral, @ApiParam(name="cacheKeyOther", value="\u5176\u4ed6\u8d39\u7528\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyOther) {
        try {
            this.promotionPlanService.create(promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="promotionPlan", value="\u4fc3\u9500\u89c4\u5212\u5b9e\u4f53\u7c7b") @RequestBody PromotionPlanDto promotionPlan, @ApiParam(name="cacheKeySale", value="\u5f53\u6708\u9500\u552e\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeySale, @ApiParam(name="cacheKeyDelivery", value="\u5f53\u6708\u9001\u8d27\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyDelivery, @ApiParam(name="cacheKeyPurchase", value="\u91c7\u9500\u5e93\u5b58\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyPurchase, @ApiParam(name="cacheKeyGeneral", value="\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyGeneral, @ApiParam(name="cacheKeyOther", value="\u5176\u4ed6\u8d39\u7528\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyOther) {
        try {
            this.promotionPlanService.update(promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.promotionPlanService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8d39\u7528\u7533\u8bf7")
    @GetMapping(value={"findByConditionsGeneral"})
    public Result<Page<GeneralExpensesVo>> findByConditionsGeneral(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="promotionPlan", value="\u4fc3\u9500\u89c4\u5212\u5b9e\u4f53\u7c7b") PromotionPlanDto promotionPlan) {
        try {
            Page page = this.promotionPlanService.findByConditionsGeneral(pageable, promotionPlan);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9884\u4f30\u8ba1\u7b97\u8d39\u7528")
    @PostMapping(value={"generateGeneralExpenses"})
    public Result<Page<GeneralExpensesVo>> generateGeneralExpenses(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="promotionPlan", value="\u4fc3\u9500\u89c4\u5212\u5b9e\u4f53\u7c7b") @RequestBody PromotionPlanDto promotionPlan, @ApiParam(name="cacheKeySale", value="\u5f53\u6708\u9500\u552e\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeySale, @ApiParam(name="cacheKeyDelivery", value="\u5f53\u6708\u9001\u8d27\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyDelivery, @ApiParam(name="cacheKeyPurchase", value="\u91c7\u9500\u5e93\u5b58\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyPurchase, @ApiParam(name="cacheKeyGeneral", value="\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyGeneral) {
        try {
            this.promotionPlanService.generateGeneralExpenses(promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral);
            Page page = this.generalExpensesService.findCachePageList(pageable, cacheKeyGeneral, null);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"submitApproval"})
    public Result<?> submitApproval(@ApiParam(name="promotionPlanSubmitDto", value="\u63d0\u4ea4\u5ba1\u6279dto") @RequestBody PromotionPlanSubmitDto promotionPlanSubmitDto) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            Validate.notNull((Object)promotionPlanSubmitDto.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01", (Object[])new Object[0]);
            lockKey = "promotion_plan:lock:approve:" + promotionPlanSubmitDto.getId();
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 3L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.promotionPlanService.submitApproval(promotionPlanSubmitDto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"submitAndSetPass"})
    public Result<?> submitAndSetPass(@ApiParam(name="promotionPlanSubmitDto", value="\u4fdd\u5b58\u5e76\u63d0\u4ea4\u5ba1\u6279dto") @RequestBody PromotionPlanSubmitDto promotionPlanSubmitDto, @ApiParam(name="cacheKeySale", value="\u5f53\u6708\u9500\u552e\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeySale, @ApiParam(name="cacheKeyDelivery", value="\u5f53\u6708\u9001\u8d27\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyDelivery, @ApiParam(name="cacheKeyPurchase", value="\u91c7\u9500\u5e93\u5b58\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyPurchase, @ApiParam(name="cacheKeyGeneral", value="\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyGeneral, @ApiParam(name="cacheKeyOther", value="\u5176\u4ed6\u8d39\u7528\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyOther) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            if (StringUtils.isNotBlank((CharSequence)promotionPlanSubmitDto.getId())) {
                lockKey = "promotion_plan:lock:approve:" + promotionPlanSubmitDto.getId();
                lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 3L);
                Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            this.promotionPlanService.submitAndSetPass(promotionPlanSubmitDto, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u9884\u7b97\u4fe1\u606f")
    @GetMapping(value={"getMonthBudget"})
    public Result<List<MonthBudgetBusinessPolicyQueryVo>> getMonthBudget(@ApiParam(name="cacheKeyGeneral", value="\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyGeneral, @ApiParam(name="cacheKeySale", value="\u5f53\u6708\u9500\u552e\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeySale, @ApiParam(name="promotionPlanCode", value="\u4fc3\u9500\u89c4\u5212\u7f16\u7801") @RequestParam(required=false) String promotionPlanCode) {
        try {
            List monthBudgetVoList = this.promotionPlanService.getMonthBudget(cacheKeyGeneral, cacheKeySale, promotionPlanCode);
            return Result.ok((Object)monthBudgetVoList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ed3\u679c\u8ba1\u7b97")
    @PostMapping(value={"calculationResult"})
    public Result<List<PromotionPlanResultVoStr>> calculationResult(@ApiParam(name="promotionPlan", value="\u7ed3\u679c\u8ba1\u7b97dto") @RequestBody PromotionPlanDto promotionPlan, @ApiParam(name="cacheKeySale", value="\u5f53\u6708\u9500\u552e\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeySale, @ApiParam(name="cacheKeyDelivery", value="\u5f53\u6708\u9001\u8d27\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyDelivery, @ApiParam(name="cacheKeyPurchase", value="\u91c7\u9500\u5e93\u5b58\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyPurchase, @ApiParam(name="cacheKeyGeneral", value="\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyGeneral, @ApiParam(name="cacheKeyOther", value="\u5176\u4ed6\u8d39\u7528\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyOther, @ApiParam(name="type", value="\u7ed3\u679c\u8ba1\u7b97\u7c7b\u578b") @RequestParam String type) {
        try {
            List resultVoList = this.promotionPlanService.calculationResult(promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther, type);
            return Result.ok((Object)resultVoList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5f53\u6708\u9500\u552e\u8ba1\u7b97\u6298\u6263\u3001\u9500\u7ba1\u62a5\u9500\u3001\u884c\u653f+\u4eba\u529b")
    @PostMapping(value={"calculationCurrentMonthSaleFee"})
    public Result<Page<CurrentMonthSaleVo>> calculationCurrentMonthSaleFee(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="promotionPlan", value="\u4fc3\u9500\u89c4\u5212\u5b9e\u4f53\u7c7b") @RequestBody PromotionPlanDto promotionPlan, @ApiParam(name="cacheKeySale", value="\u5f53\u6708\u9500\u552e\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeySale, @ApiParam(name="cacheKeyDelivery", value="\u5f53\u6708\u9001\u8d27\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyDelivery, @ApiParam(name="cacheKeyPurchase", value="\u91c7\u9500\u5e93\u5b58\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyPurchase, @ApiParam(name="cacheKeyGeneral", value="\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyGeneral, @ApiParam(name="cacheKeyOther", value="\u5176\u4ed6\u8d39\u7528\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyOther) {
        try {
            this.promotionPlanService.calculationCurrentMonthSaleFee(promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
            Page page = this.currentMonthSaleService.findCachePageList(pageable, cacheKeySale, promotionPlan.getPromotionPlanCode());
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5f53\u6708\u9001\u8d27\u8ba1\u7b97\u6298\u6263\u3001\u9500\u7ba1\u62a5\u9500\u3001\u884c\u653f+\u4eba\u529b")
    @PostMapping(value={"calculationCurrentMonthDeliveryFee"})
    public Result<Page<CurrentMonthDeliveryVo>> calculationCurrentMonthDeliveryFee(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="promotionPlan", value="\u4fc3\u9500\u89c4\u5212\u5b9e\u4f53\u7c7b") @RequestBody PromotionPlanDto promotionPlan, @ApiParam(name="cacheKeySale", value="\u5f53\u6708\u9500\u552e\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeySale, @ApiParam(name="cacheKeyDelivery", value="\u5f53\u6708\u9001\u8d27\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyDelivery, @ApiParam(name="cacheKeyPurchase", value="\u91c7\u9500\u5e93\u5b58\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyPurchase, @ApiParam(name="cacheKeyGeneral", value="\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyGeneral, @ApiParam(name="cacheKeyOther", value="\u5176\u4ed6\u8d39\u7528\u7f13\u5b58\u952e") @RequestParam(required=false) String cacheKeyOther) {
        try {
            this.promotionPlanService.calculationCurrentMonthDeliveryFee(promotionPlan, cacheKeySale, cacheKeyPurchase, cacheKeyDelivery, cacheKeyGeneral, cacheKeyOther);
            Page page = this.currentMonthDeliveryService.findCachePageList(pageable, cacheKeyDelivery, promotionPlan.getPromotionPlanCode());
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findPromotionPlanPageListForEventPrepayment"})
    @ApiOperation(value="\u6d3b\u52a8\u9884\u4ed8\u7535\u5546\u9009\u62e9\u6d3b\u52a8\u660e\u7ec6")
    public Result<Page<PromotionPlanForEventPrepaymentVo>> findPromotionPlanPageListForEventPrepayment(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="promotionPlanForEventPrepaymentVo", value="\u6d3b\u7ec6\u6848\u67e5\u8be2Vo") PromotionPlanForEventPrepaymentDto dto) {
        try {
            Page list = this.promotionPlanService.findPromotionPlanPageListForEventPrepayment(pageable, dto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8d39\u7528\u8fdb\u5ea6\u76d1\u63a7\u67e5\u8be2")
    @GetMapping(value={"findCostProgressByConditions"})
    public Result<Page<PromotionPlanCostProgressVo>> findCostProgressByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="promotionPlan", value="\u8d39\u7528\u8fdb\u5ea6\u76d1\u63a7\u67e5\u8be2dto") PromotionPlanCostProgressDto dto) {
        try {
            Page page = this.promotionPlanCostProgressService.findCostProgressByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

