/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanWholeSummaryDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanWholeSummaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/promotionPlanWholeSummary"})
@Api(tags={"\u4fc3\u9500\u89c4\u5212\u6574\u4f53\u4e00\u89c8\u8868"})
public class PromotionPlanWholeSummaryController {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanWholeSummaryController.class);
    @Autowired(required=false)
    private PromotionPlanWholeSummaryService promotionPlanWholeSummaryService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u91cd\u65b0\u751f\u6210\u4fc3\u9500\u89c4\u5212\u6574\u4f53\u4e00\u89c8\u8868")
    @GetMapping(value={"createPromotionPlanWholeSummary"})
    public Result<?> createPromotionPlanWholeSummary(@ApiParam(name="yearMonthLy", value="\u5e74\u6708") @RequestParam(value="yearMonthLy") String yearMonthLy) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            lockKey = "tpm_promotion_plan_whole_summary:lock:approve:" + yearMonthLy;
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 10L);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
            }
            this.promotionPlanWholeSummaryService.createPromotionPlanWholeSummary(yearMonthLy);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @ApiOperation(value="\u6839\u636e\u5e74\u6708\u83b7\u53d6\u4e00\u89c8\u8868\u660e\u7ec6")
    @GetMapping(value={"getPromotionPlanWholeSummaryDetail"})
    public Result<?> getPromotionPlanWholeSummaryDetail(@ApiParam(name="yearMonthLy", value="\u5e74\u6708") @RequestParam(value="yearMonthLy") String yearMonthLy) {
        try {
            return Result.ok((Object)this.promotionPlanWholeSummaryService.getPromotionPlanWholeSummaryDetail(yearMonthLy));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"submitApproval"})
    public Result<?> submitApproval(@ApiParam(name="PromotionPlanWholeSummaryDto", value="\u63d0\u4ea4\u5ba1\u6279dto") @RequestBody PromotionPlanWholeSummaryDto dto) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            Validate.notNull((Object)dto.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01", (Object[])new Object[0]);
            lockKey = "tpm_promotion_plan_whole_summary:lock:approve:" + dto.getId();
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 1L);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
            }
            this.promotionPlanWholeSummaryService.submitApproval(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }
}

