/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.register;

import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionFeeApportionDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionFeeApportionService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PromotionFeeApportionFormulaVariableRegister
implements FormulaVariableRegister {
    @Autowired(required=false)
    private PromotionFeeApportionService promotionFeeApportionService;

    public String getVariableCode() {
        return "promotionFeeApportion";
    }

    public String getVariableName() {
        return "\u6d88\u8d39\u8005\u8d39\u7528\u5206\u644a\u9500\u552e\u989d";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PromotionFeeApportionDto dto = new PromotionFeeApportionDto();
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setYearMonthLy(calculateDto.getYearMonthLy());
        dto.setActivityFormCode(calculateDto.getActivityFormCode());
        BigDecimal total = this.promotionFeeApportionService.findForFormulaVariable(dto);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), Objects.nonNull(total) ? total : BigDecimal.ZERO);
        return resultMap;
    }
}

