/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.repository;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.CurrentMonthSaleEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.ExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.CurrentMonthSaleMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthSaleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CurrentMonthSaleRepository
extends ServiceImpl<CurrentMonthSaleMapper, CurrentMonthSaleEntity> {
    @Autowired(required=false)
    private CurrentMonthSaleMapper currentMonthSaleMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<CurrentMonthSaleVo> findByConditions(Pageable pageable, CurrentMonthSaleDto currentMonthSale) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<CurrentMonthSaleVo> pageList = this.currentMonthSaleMapper.findByConditions((Page<CurrentMonthSaleVo>)page, currentMonthSale);
        return pageList;
    }

    public List<CurrentMonthSaleDto> findByPlanCode(String code) {
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ExpensesEntity::getPromotionPlanCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByDesc((Object[])new SFunction[]{UuidOpEntity::getCreateTime, UuidEntity::getId})).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, CurrentMonthSaleEntity.class, CurrentMonthSaleDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CurrentMonthSaleDto> findByPlanCodeList(List<String> codeList) {
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ExpensesEntity::getPromotionPlanCode, codeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return new ArrayList<CurrentMonthSaleDto>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, CurrentMonthSaleEntity.class, CurrentMonthSaleDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void deleteByPromotionPlanCode(String code) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ExpensesEntity::getPromotionPlanCode, (Object)code)).remove();
    }

    public void removeByPromotionPlanCodeList(List<String> codeList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ExpensesEntity::getPromotionPlanCode, codeList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public BigDecimal getMinActivityBasePrice(CurrentMonthSaleDto currentMonthSaleDto) {
        return this.currentMonthSaleMapper.getMinActivityBasePrice(currentMonthSaleDto);
    }

    public List<CurrentMonthSaleVo> findCustomerProductMonthSaleSumList(CurrentMonthSaleDto dto) {
        return this.currentMonthSaleMapper.findCustomerProductMonthSaleSumList(dto);
    }
}

