/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.repository;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.ExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.GeneralExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.GeneralExpensesMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanCostProgressDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class GeneralExpensesRepository
extends ServiceImpl<GeneralExpensesMapper, GeneralExpensesEntity> {
    @Autowired(required=false)
    private GeneralExpensesMapper generalExpensesMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<GeneralExpensesVo> findByConditions(Pageable pageable, GeneralExpensesDto generalExpenses) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<GeneralExpensesVo> pageList = this.generalExpensesMapper.findByConditions((Page<GeneralExpensesVo>)page, generalExpenses);
        return pageList;
    }

    public Page<GeneralExpensesVo> findByConditionsGeneral(Pageable pageable, PromotionPlanDto promotionPlan) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<GeneralExpensesVo> pageList = this.generalExpensesMapper.findByConditionsGeneral((Page<GeneralExpensesVo>)page, promotionPlan);
        return pageList;
    }

    public List<GeneralExpensesDto> findByPlanCode(String code) {
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ExpensesEntity::getPromotionPlanCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, GeneralExpensesEntity.class, GeneralExpensesDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<GeneralExpensesDto> findByPlanDetailCodes(List<String> codes) {
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ExpensesEntity::getExpensesCode, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, GeneralExpensesEntity.class, GeneralExpensesDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<GeneralExpensesEntity> findByExpensesCode(String expensesCode) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(ExpensesEntity::getExpensesCode, (Object)expensesCode)).list();
    }

    public List<GeneralExpensesVo> findByExpensesCodeExt(List<String> expensesCodeList) {
        return this.generalExpensesMapper.findByExpensesCode(expensesCodeList);
    }

    public void deleteByPromotionPlanCode(String code) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ExpensesEntity::getPromotionPlanCode, (Object)code)).remove();
    }

    public void removeByPromotionPlanCodeList(List<String> codeList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ExpensesEntity::getPromotionPlanCode, codeList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateAuditAmount(List<GeneralExpensesDto> dtoList) {
        this.generalExpensesMapper.updateAuditAmount(dtoList);
    }

    public Page<GeneralExpensesVo> findForWithholding(Page<GeneralExpensesVo> page, String processStatus, String upAccountStatus) {
        return this.generalExpensesMapper.findForWithholding(page, processStatus, upAccountStatus);
    }

    public BigDecimal getContractAmount(String promotionPlanCode) {
        return this.generalExpensesMapper.getContractAmount(promotionPlanCode);
    }

    public int getTotalNum(PromotionPlanDto promotionPlanDto) {
        Integer total = this.generalExpensesMapper.getGeneralExpenseTotal(promotionPlanDto);
        return total == null ? 0 : total;
    }

    public List<GeneralExpensesEntity> findListByExpensesCodes(Set<String> activityDetailCodes) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ExpensesEntity::getExpensesCode, activityDetailCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        return list;
    }

    public String findOtherDetailWholeAudit(String businessPolicyCode) {
        if (StringUtils.isEmpty((CharSequence)businessPolicyCode)) {
            return YesOrNoEnum.YES.getCode();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(GeneralExpensesEntity::getCommercePolicyCode, (Object)businessPolicyCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        for (GeneralExpensesEntity generalExpensesEntity : list) {
            if (YesOrNoEnum.YES.getCode().equals(generalExpensesEntity.getWholeAudit())) continue;
            return YesOrNoEnum.NO.getCode();
        }
        return YesOrNoEnum.YES.getCode();
    }

    public Page<PromotionPlanCostProgressVo> findCostProgressByConditions(Pageable pageable, PromotionPlanCostProgressDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<PromotionPlanCostProgressVo> pageList = this.generalExpensesMapper.findCostProgressByConditions((Page<PromotionPlanCostProgressVo>)page, dto);
        return pageList;
    }

    public List<GeneralExpensesVo> findByBusinessPolicyCode(List<String> businessPolicyCodeList) {
        return this.generalExpensesMapper.findByBusinessPolicyCode(businessPolicyCodeList);
    }

    public List<GeneralExpensesVo> findDataByExpensesCodes(Set<String> set) {
        return this.generalExpensesMapper.findDataByExpensesCodes(set);
    }

    public List<GeneralExpensesVo> findByExpensesCodes(Set<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        return this.generalExpensesMapper.findByExpensesCodes(detailCodes);
    }

    public boolean isOtherDetailWholeAudit2(String businessPolicyCode, List<String> expensesCodes) {
        if (StringUtils.isEmpty((CharSequence)businessPolicyCode)) {
            return false;
        }
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(GeneralExpensesEntity::getCommercePolicyCode, (Object)businessPolicyCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).ne(GeneralExpensesEntity::getWholeAudit, (Object)YesOrNoEnum.YES.getCode())).notIn(!CollectionUtils.isEmpty(expensesCodes), ExpensesEntity::getExpensesCode, expensesCodes)).count();
        return count <= 0;
    }

    public Page<GeneralExpensesVo> findCanAutoAuditItemPage(Page<GeneralExpensesVo> page, AutoAuditParamsDto autoAuditParams) {
        Page<GeneralExpensesVo> itemPage = ((GeneralExpensesMapper)this.getBaseMapper()).findCanAutoAuditItemPage(page, autoAuditParams);
        List itemList = itemPage.getRecords();
        if (CollUtil.isEmpty((Collection)itemList)) {
            return itemPage;
        }
        String endCaseForm = autoAuditParams.getEndCaseForm();
        List<String> endCaseFormList = null;
        if (CharSequenceUtil.isNotEmpty((CharSequence)endCaseForm)) {
            endCaseFormList = Arrays.asList(endCaseForm.split(","));
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        ArrayList<GeneralExpensesVo> resultList = new ArrayList<GeneralExpensesVo>();
        for (GeneralExpensesVo item : itemList) {
            if (CollUtil.isNotEmpty(endCaseFormList)) {
                String auditForm = item.getAuditWayCode();
                if (CharSequenceUtil.isNotEmpty((CharSequence)autoAuditParams.getEndCaseForm())) continue;
                List<String> list = Arrays.asList(auditForm.split(","));
                ArrayList filterEndCaseFormList = com.google.common.collect.Lists.newArrayList();
                for (String s : list) {
                    if (!endCaseFormList.contains(s)) continue;
                    filterEndCaseFormList.add(s);
                }
                if (CollUtil.isEmpty((Collection)filterEndCaseFormList)) continue;
            }
            resultList.add(item);
        }
        itemPage.setRecords(resultList);
        return itemPage;
    }

    public void updateAutoAuditFlag(List<String> codes, String autoAudit) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        List partition = com.google.common.collect.Lists.partition(codes, (int)800);
        partition.forEach(list -> ((GeneralExpensesMapper)this.baseMapper).updateAutoAuditFlag((List<String>)list, autoAudit));
    }
}

