/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.OtherExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.OtherExpensesMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.OtherExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.OtherExpensesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OtherExpensesRepository
extends ServiceImpl<OtherExpensesMapper, OtherExpensesEntity> {
    @Autowired(required=false)
    private OtherExpensesMapper otherExpensesMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<OtherExpensesVo> findByConditions(Pageable pageable, OtherExpensesDto otherExpenses) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<OtherExpensesVo> pageList = this.otherExpensesMapper.findByConditions((Page<OtherExpensesVo>)page, otherExpenses);
        return pageList;
    }

    public List<OtherExpensesDto> findByPlanCode(String code) {
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(OtherExpensesEntity::getPromotionPlanCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return new ArrayList<OtherExpensesDto>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, OtherExpensesEntity.class, OtherExpensesDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void deleteByPromotionPlanCode(String code) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(OtherExpensesEntity::getPromotionPlanCode, (Object)code)).remove();
    }

    public void removeByPromotionPlanCodeList(List<String> codeList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(OtherExpensesEntity::getPromotionPlanCode, codeList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }
}

