/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanEntity;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PromotionPlanMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanForEventPrepaymentDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanForEventPrepaymentVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PromotionPlanRepository
extends ServiceImpl<PromotionPlanMapper, PromotionPlanEntity> {
    @Autowired(required=false)
    private PromotionPlanMapper promotionPlanMapper;

    public Page<PromotionPlanVo> findByConditions(Pageable pageable, PromotionPlanDto promotionPlan) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<PromotionPlanVo> pageList = this.promotionPlanMapper.findByConditions((Page<PromotionPlanVo>)page, promotionPlan);
        return pageList;
    }

    public Page<PromotionPlanForEventPrepaymentVo> findPromotionPlanPageListForEventPrepayment(Page<PromotionPlanForEventPrepaymentVo> page, PromotionPlanForEventPrepaymentDto dto) {
        return this.promotionPlanMapper.findPromotionPlanPageListForEventPrepayment(page, dto);
    }

    public void removePromotionPlanByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public PromotionPlanEntity findByCode(String code) {
        return (PromotionPlanEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PromotionPlanEntity::getPromotionPlanCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<PromotionPlanEntity> findByCodes(List<String> codes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PromotionPlanEntity::getPromotionPlanCode, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<PromotionPlanEntity> findByCodeList(List<String> codeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PromotionPlanEntity::getPromotionPlanCode, codeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public int getTotalPromotion(PromotionPlanDto promotionPlan) {
        Integer promotionTotal = this.promotionPlanMapper.getPromotionTotal(promotionPlan);
        return promotionTotal == null ? 0 : promotionTotal;
    }

    public List<PromotionPlanVo> findByDateConditions(PromotionPlanDto promotionPlanDto) {
        return ((PromotionPlanMapper)this.baseMapper).findByDateConditions(promotionPlanDto);
    }

    public void updateProcessStatusById(String id, String processStatus) {
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)processStatus)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).set(PromotionPlanEntity::getProcessStatus, (Object)processStatus)).update();
    }
}

