/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PurchaseSale;
import com.biz.crm.tpm.business.promotion.plan.local.mapper.PurchaseSaleMapper;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PurchaseSaleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PurchaseSaleRepository
extends ServiceImpl<PurchaseSaleMapper, PurchaseSale> {
    @Autowired(required=false)
    private PurchaseSaleMapper purchaseSaleMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<PurchaseSaleVo> findByConditions(Pageable pageable, PurchaseSaleDto purchaseSale) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<PurchaseSaleVo> pageList = this.purchaseSaleMapper.findByConditions((Page<PurchaseSaleVo>)page, purchaseSale);
        return pageList;
    }

    public List<PurchaseSaleDto> findByPlanCode(String code) {
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PurchaseSale::getPromotionPlanCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, PurchaseSale.class, PurchaseSaleDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void deleteByPromotionPlanCode(String code) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(PurchaseSale::getPromotionPlanCode, (Object)code)).remove();
    }

    public void removeByPromotionPlanCodeList(List<String> codeList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(PurchaseSale::getPromotionPlanCode, codeList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }
}

