/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.biz.crm.tpm.business.promotion.plan.local.entity.ActualProfitLoss;
import com.biz.crm.tpm.business.promotion.plan.local.repository.ActualProfitLossRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="actualProfitLossService")
public class ActualProfitLossServiceImpl
implements ActualProfitLossService {
    private static final Logger log = LoggerFactory.getLogger(ActualProfitLossServiceImpl.class);
    @Autowired(required=false)
    private ActualProfitLossRepository actualProfitLossRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List list = this.actualProfitLossRepository.listByIds(idList);
        Validate.notEmpty((Collection)list, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        this.actualProfitLossRepository.removeProfitLossByIds(idList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<ActualProfitLossVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Collection profitLosses = this.nebulaToolkitService.copyCollectionByWhiteList(list, ActualProfitLossVo.class, ActualProfitLoss.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.actualProfitLossRepository.saveBatch(profitLosses);
    }

    public List<ActualProfitLossVo> findProfitLoss(ActualProfitLossVo dto, List<String> month) {
        return this.actualProfitLossRepository.findProfitLoss(dto, month);
    }

    public List<ActualProfitLossVo> findProfitLossByDto(ActualProfitLossVo dto) {
        return this.actualProfitLossRepository.findProfitLossByDto(dto);
    }
}

