/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.tpm.business.promotion.plan.local.repository.CurrentMonthSaleRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthSaleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="currentMonthSaleService")
public class CurrentMonthSaleServiceImpl
implements CurrentMonthSaleService {
    private static final Logger log = LoggerFactory.getLogger(CurrentMonthSaleServiceImpl.class);
    @Autowired(required=false)
    private CurrentMonthSaleRepository currentMonthSaleRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<CurrentMonthSaleVo> findByConditions(Pageable pageable, CurrentMonthSaleDto currentMonthSale) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(currentMonthSale)) {
            currentMonthSale = new CurrentMonthSaleDto();
        }
        return this.currentMonthSaleRepository.findByConditions(pageable, currentMonthSale);
    }

    public Page<CurrentMonthSaleVo> findCachePageList(Pageable pageable, String cacheKey, String promotionPlanCode) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheKey);
            page.setTotal(total.longValue());
            List objects = this.redisService.lRange(redisCacheKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty((Collection)objects)) {
                List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)objects, CurrentMonthSaleDto.class, CurrentMonthSaleVo.class, HashSet.class, ArrayList.class, new String[0]);
                page.setRecords(voList);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)promotionPlanCode)) {
            List<CurrentMonthSaleDto> dtoList = this.currentMonthSaleRepository.findByPlanCode(promotionPlanCode);
            if (!CollectionUtils.isEmpty(dtoList)) {
                this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), dtoList.toArray());
            }
            page.setTotal((long)dtoList.size());
            long start = page.offset();
            if (page.getTotal() > start) {
                long end = page.offset() + page.getSize();
                if (page.getTotal() < end) {
                    end = page.getTotal();
                }
                List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(dtoList.subList((int)page.offset(), (int)end), CurrentMonthSaleDto.class, CurrentMonthSaleVo.class, HashSet.class, ArrayList.class, new String[0]);
                page.setRecords(voList);
            }
        }
        return page;
    }

    public List<CurrentMonthSaleDto> findCacheList(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        if (!this.redisService.hasKey(redisCacheKey).booleanValue()) {
            return Lists.newArrayList();
        }
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        return objects;
    }

    public List<CurrentMonthSaleDto> findList(String code) {
        return this.currentMonthSaleRepository.findByPlanCode(code);
    }

    public void addItemCache(String cacheKey, List<CurrentMonthSaleDto> saveList) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList();
        Map<Object, Object> saveItemMap = !CollectionUtils.isEmpty(saveList) ? saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity())) : Maps.newHashMap();
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            for (Object object : objects) {
                CurrentMonthSaleDto item = (CurrentMonthSaleDto)object;
                newList.add(saveItemMap.getOrDefault(item.getId(), item));
            }
        }
        CurrentMonthSaleDto newItem = new CurrentMonthSaleDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newList.add(0, newItem);
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void copyItemListCache(String cacheKey, List<CurrentMonthSaleDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        ArrayList copyList = Lists.newArrayList();
        for (Object object : objects) {
            CurrentMonthSaleDto item = (CurrentMonthSaleDto)object;
            if (saveItemMap.containsKey(item.getId())) {
                CurrentMonthSaleDto newItem = (CurrentMonthSaleDto)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) {
                    CurrentMonthSaleDto copyItem = (CurrentMonthSaleDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newItem, CurrentMonthSaleDto.class, HashSet.class, ArrayList.class, new String[0]);
                    copyItem.setId(UUID.randomUUID().toString().replace("-", ""));
                    copyItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    copyItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    copyList.add(copyItem);
                }
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        newList.addAll(0, copyList);
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void saveCurrentPageCache(String cacheKey, List<CurrentMonthSaleDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            CurrentMonthSaleDto item = (CurrentMonthSaleDto)object;
            newList.add(saveItemMap.getOrDefault(item.getId(), item));
        }
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void deleteCacheList(String cacheKey, List<CurrentMonthSaleDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Map saveItemMap = itemList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            CurrentMonthSaleDto item = (CurrentMonthSaleDto)object;
            if (saveItemMap.containsKey(item.getId())) {
                CurrentMonthSaleDto newItem = (CurrentMonthSaleDto)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) continue;
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void clearCache(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        this.redisService.del(redisCacheKey);
    }

    public Integer getTotal(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        return this.redisService.lSize(redisCacheKey).intValue();
    }

    public void addListCache(String cacheKey, List<CurrentMonthSaleDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList();
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            newList.addAll(objects);
        }
        newList.addAll(saveList);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void calculationFee(CurrentMonthSaleDto dto, String businessModelCode) {
        dto.setEstimatedSalesTon(dto.getEstimatedSalesBox().multiply(dto.getRatio()).multiply(dto.getCombinationQuantity()).setScale(2, RoundingMode.HALF_UP).divide(new BigDecimal(1000), 6, 4));
        if (dto.getDiscount() != null) {
            dto.setEstimatedAmountAfter(dto.getEstimatedAmountBefore().subtract(dto.getDiscount()).setScale(2, RoundingMode.HALF_UP));
        }
        dto.setVat(dto.getEstimatedAmountBefore().divide(BigDecimal.ONE.add(dto.getTaxRate()), 6, 4).multiply(dto.getTaxRate()).setScale(2, RoundingMode.HALF_UP));
        dto.setQuotaTotal(this.bdNull(dto.getProductPromotion()).add(this.bdNull(dto.getLargeDateProcess())).add(this.bdNull(dto.getNewCustomer())).add(this.bdNull(dto.getOldCustomer())).add(this.bdNull(dto.getUneven())).add(this.bdNull(dto.getHighTurnover())).add(this.bdNull(dto.getPlatformGrossProtection())).add(this.bdNull(dto.getSaleCommission())).setScale(2, RoundingMode.HALF_UP));
        dto.setGmv(dto.getActivityBasePrice().multiply(dto.getEstimatedSalesBox()).multiply(dto.getCombinationQuantity()).setScale(2, RoundingMode.HALF_UP));
        try {
            dto.setNetIncome(dto.getEstimatedAmountBefore().subtract(dto.getVat()).subtract(dto.getDiscount()).add(dto.getDiscount().divide(BigDecimal.ONE.add(dto.getTaxRate()), 6, 4).multiply(dto.getTaxRate())).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            dto.setNetIncome(BigDecimal.ZERO);
        }
        try {
            dto.setGrossProfit(dto.getNetIncome().subtract(dto.getCostPrice().multiply(dto.getEstimatedSalesBox()).multiply(dto.getCombinationQuantity()).divide(BigDecimal.ONE.add(dto.getTaxRate()), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            dto.setGrossProfit(BigDecimal.ZERO);
        }
        try {
            dto.setOperateProfit(dto.getNetIncome().subtract(dto.getNetIncome().multiply(new BigDecimal("0.005"))).subtract(dto.getCostPrice().multiply(dto.getEstimatedSalesBox()).multiply(dto.getCombinationQuantity()).divide(BigDecimal.ONE.add(dto.getTaxRate()), 2, RoundingMode.HALF_UP)).subtract(dto.getSaleReimburse()).subtract(dto.getLogistics()).subtract(dto.getAdminHuman()).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            dto.setOperateProfit(BigDecimal.ZERO);
        }
        try {
            dto.setIncomeTax(dto.getOperateProfit().multiply(new BigDecimal("0.25")).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            dto.setIncomeTax(BigDecimal.ZERO);
        }
        try {
            dto.setNetProfit(dto.getOperateProfit().subtract(dto.getIncomeTax()).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            dto.setNetProfit(BigDecimal.ZERO);
        }
        try {
            dto.setNetProfitRate(dto.getNetProfit().divide(dto.getNetIncome(), 2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            dto.setNetProfitRate(BigDecimal.ZERO);
        }
        if ("distribution_mode".equals(businessModelCode)) {
            dto.setDistributionBaseTen(dto.getEstimatedAmountBefore().multiply(this.bdNull(dto.getDistributionBaseTenPoint())).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            dto.setDistributionBaseMonth(dto.getEstimatedAmountBefore().multiply(this.bdNull(dto.getDistributionBaseMonthPoint())).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            dto.setMonthGoalAchievement(dto.getEstimatedAmountBefore().multiply(this.bdNull(dto.getMonthGoalAchievementPoint())).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            dto.setPrePack(dto.getEstimatedAmountBefore().multiply(this.bdNull(dto.getPrePackPoint())).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            dto.setStaffFee(dto.getEstimatedAmountBefore().multiply(this.bdNull(dto.getStaffFeePoint())).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            dto.setPutFee(dto.getEstimatedAmountBefore().multiply(this.bdNull(dto.getPutFeePoint())).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            dto.setLogisticsSupport(dto.getEstimatedAmountBefore().multiply(this.bdNull(dto.getLogisticsSupportPoint())).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            BigDecimal sum = this.bdNull(dto.getDistributionBaseTenPoint()).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP).add(this.bdNull(dto.getDistributionBaseMonthPoint()).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP)).add(this.bdNull(dto.getMonthGoalAchievementPoint()).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP)).add(this.bdNull(dto.getPrePackPoint()).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP)).add(this.bdNull(dto.getStaffFeePoint()).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP)).add(this.bdNull(dto.getPutFeePoint()).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP)).add(this.bdNull(dto.getLogisticsSupportPoint()).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            dto.setYearGoalAchievement(dto.getEstimatedAmountBefore().multiply(this.bdNull(dto.getYearGoalAchievementPoint())).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
            if (dto.getTakeHomePricePolicy() != null) {
                dto.setTakeHomePricePolicyFee(dto.getPlatformSupplyPrice().subtract(dto.getTakeHomePricePolicy()).multiply(dto.getCombinationQuantity()).multiply(dto.getEstimatedSalesBox()));
            }
        }
    }

    private String getRedisCacheKey(String cacheKey) {
        return "month_sale_cache:page:" + cacheKey;
    }

    private BigDecimal bdNull(BigDecimal b) {
        return b == null ? BigDecimal.ZERO : b;
    }
}

