/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanEntity;
import com.biz.crm.tpm.business.promotion.plan.local.repository.GeneralExpensesRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.ExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="generalExpensesService")
public class GeneralExpensesServiceImpl
implements GeneralExpensesService {
    @Autowired(required=false)
    private GeneralExpensesRepository generalExpensesRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private BusinessPolicyService businessPolicyService;
    @Autowired(required=false)
    private PromotionPlanRepository promotionPlanRepository;

    public Page<GeneralExpensesVo> findByConditions(Pageable pageable, GeneralExpensesDto generalExpenses) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(generalExpenses)) {
            generalExpenses = new GeneralExpensesDto();
        }
        return this.generalExpensesRepository.findByConditions(pageable, generalExpenses);
    }

    public Page<GeneralExpensesVo> findCachePageList(Pageable pageable, String cacheKey, String promotionPlanCode) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheKey);
            page.setTotal(total.longValue());
            List objects = this.redisService.lRange(redisCacheKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty((Collection)objects)) {
                List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)objects, GeneralExpensesDto.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
                page.setRecords(voList);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)promotionPlanCode)) {
            List<GeneralExpensesDto> dtoList = this.generalExpensesRepository.findByPlanCode(promotionPlanCode);
            if (!CollectionUtils.isEmpty(dtoList)) {
                this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), dtoList.toArray());
            }
            page.setTotal((long)dtoList.size());
            long start = page.offset();
            if (page.getTotal() > start) {
                long end = page.offset() + page.getSize();
                if (page.getTotal() < end) {
                    end = page.getTotal();
                }
                List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(dtoList.subList((int)page.offset(), (int)end), GeneralExpensesDto.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
                page.setRecords(voList);
            }
        }
        return page;
    }

    public List<GeneralExpensesDto> findCacheList(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        if (!this.redisService.hasKey(redisCacheKey).booleanValue()) {
            return Lists.newArrayList();
        }
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        return objects;
    }

    public List<GeneralExpensesDto> findList(String code) {
        return this.generalExpensesRepository.findByPlanCode(code);
    }

    public List<GeneralExpensesDto> findByDetailCodeList(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        List<GeneralExpensesDto> generalExpensesDtos = this.generalExpensesRepository.findByPlanDetailCodes(codes);
        if (!CollectionUtils.isEmpty(generalExpensesDtos)) {
            List<String> promotionPlanCodes = generalExpensesDtos.stream().map(ExpensesDto::getPromotionPlanCode).collect(Collectors.toList());
            List<PromotionPlanEntity> promotionPlanEntities = this.promotionPlanRepository.findByCodes(promotionPlanCodes);
            Map promotionPlanEntityMap = promotionPlanEntities.stream().collect(Collectors.toMap(PromotionPlanEntity::getPromotionPlanCode, Function.identity()));
            for (GeneralExpensesDto generalExpensesDto : generalExpensesDtos) {
                PromotionPlanEntity promotionPlanEntity = (PromotionPlanEntity)((Object)promotionPlanEntityMap.get(generalExpensesDto.getPromotionPlanCode()));
                if (promotionPlanEntity == null) continue;
                generalExpensesDto.setSalesOrgCode(promotionPlanEntity.getSalesOrgCode());
                generalExpensesDto.setSalesOrgName(promotionPlanEntity.getSalesOrgName());
            }
        }
        return generalExpensesDtos;
    }

    public void addItemCache(String cacheKey, List<GeneralExpensesDto> saveList) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList();
        Map<Object, Object> saveItemMap = !CollectionUtils.isEmpty(saveList) ? saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity())) : Maps.newHashMap();
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            for (Object object : objects) {
                GeneralExpensesDto item = (GeneralExpensesDto)object;
                newList.add(saveItemMap.getOrDefault(item.getId(), item));
            }
        }
        GeneralExpensesDto newItem = new GeneralExpensesDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newList.add(0, newItem);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void copyItemListCache(String cacheKey, List<GeneralExpensesDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        ArrayList copyList = Lists.newArrayList();
        for (Object object : objects) {
            GeneralExpensesDto item = (GeneralExpensesDto)object;
            if (saveItemMap.containsKey(item.getId())) {
                GeneralExpensesDto newItem = (GeneralExpensesDto)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) {
                    GeneralExpensesDto copyItem = (GeneralExpensesDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newItem, GeneralExpensesDto.class, HashSet.class, ArrayList.class, new String[0]);
                    copyItem.setId(UUID.randomUUID().toString().replace("-", ""));
                    copyItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    copyItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    copyList.add(copyItem);
                }
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        newList.addAll(0, copyList);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void saveCurrentPageCache(String cacheKey, List<GeneralExpensesDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            GeneralExpensesDto item = (GeneralExpensesDto)object;
            newList.add(saveItemMap.getOrDefault(item.getId(), item));
        }
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void deleteCacheList(String cacheKey, List<GeneralExpensesDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Map saveItemMap = itemList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            GeneralExpensesDto item = (GeneralExpensesDto)object;
            if (saveItemMap.containsKey(item.getId())) {
                GeneralExpensesDto newItem = (GeneralExpensesDto)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) continue;
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void clearCache(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        this.redisService.del(redisCacheKey);
    }

    public void addItemListCache(String cacheKey, List<GeneralExpensesDto> saveList) {
        ArrayList<Object> newList = new ArrayList<Object>();
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List<GeneralExpensesDto> cacheList = this.findCacheList(cacheKey);
        List manualList = cacheList.stream().filter(e -> !Boolean.TRUE.equals(e.getBeGenerate())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(manualList)) {
            newList.addAll(manualList);
            cacheList.removeAll(manualList);
        }
        List oldListCode = cacheList.stream().map(e -> e.getActivityFormCode() + e.getCustomerCode() + Optional.ofNullable(e.getChannelCode()).orElse("")).collect(Collectors.toList());
        List newListCode = saveList.stream().map(e -> e.getActivityFormCode() + e.getCustomerCode() + Optional.ofNullable(e.getChannelCode()).orElse("")).collect(Collectors.toList());
        List subList = cacheList.stream().filter(e -> !newListCode.contains(e.getActivityFormCode() + e.getCustomerCode() + Optional.ofNullable(e.getChannelCode()).orElse(""))).collect(Collectors.toList());
        cacheList.removeAll(subList);
        cacheList.forEach(e -> {
            for (GeneralExpensesDto dto : saveList) {
                if (!e.getActivityFormCode().equals(dto.getActivityFormCode()) || !e.getCustomerCode().equals(dto.getCustomerCode()) || !Optional.ofNullable(e.getChannelCode()).orElse("").equals(Optional.ofNullable(dto.getChannelCode()).orElse(""))) continue;
                e.setApplyAmount(dto.getApplyAmount());
                break;
            }
        });
        List addList = saveList.stream().filter(e -> !oldListCode.contains(e.getActivityFormCode() + e.getCustomerCode() + Optional.ofNullable(e.getChannelCode()).orElse(""))).collect(Collectors.toList());
        cacheList.addAll(addList);
        this.redisService.del(redisCacheKey);
        newList.addAll(cacheList);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAuditAmount(List<GeneralExpensesDto> dtoList) {
        this.generalExpensesRepository.updateAuditAmount(dtoList);
        List<String> expensesCodes = dtoList.stream().map(ExpensesDto::getExpensesCode).collect(Collectors.toList());
        List<GeneralExpensesDto> generalExpensesDtoList = this.generalExpensesRepository.findByPlanDetailCodes(expensesCodes);
        Map<String, List<GeneralExpensesDto>> generalExpensesDtoMap = generalExpensesDtoList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getCommercePolicyCode())).collect(Collectors.groupingBy(GeneralExpensesDto::getCommercePolicyCode));
        if (!CollectionUtils.isEmpty(generalExpensesDtoList)) {
            Map generalExpensesDtoMap1 = dtoList.stream().collect(Collectors.toMap(ExpensesDto::getExpensesCode, Function.identity()));
            ArrayList businessPolicyDtoList = new ArrayList();
            generalExpensesDtoMap.forEach((key, value) -> {
                BusinessPolicyDto businessPolicyDto = new BusinessPolicyDto();
                businessPolicyDto.setBusinessPolicyCode(key);
                businessPolicyDto.setAlreadyAuditAmount(BigDecimal.ZERO);
                for (GeneralExpensesDto generalExpensesDto : value) {
                    GeneralExpensesDto generalExpensesDto1 = (GeneralExpensesDto)generalExpensesDtoMap1.get(generalExpensesDto.getExpensesCode());
                    businessPolicyDto.setAlreadyAuditAmount(businessPolicyDto.getAlreadyAuditAmount().add(generalExpensesDto1.getAlreadyAuditAmount()));
                    businessPolicyDto.setLastAuditAmount(businessPolicyDto.getAlreadyAuditAmount());
                    if (YesOrNoEnum.YES.getCode().equals(generalExpensesDto1.getWholeAudit())) continue;
                    businessPolicyDto.setWholeAudit(YesOrNoEnum.NO.getCode());
                }
                if (!YesOrNoEnum.NO.getCode().equals(businessPolicyDto.getWholeAudit())) {
                    businessPolicyDto.setWholeAudit(this.generalExpensesRepository.findOtherDetailWholeAudit((String)key));
                }
                businessPolicyDtoList.add(businessPolicyDto);
            });
            if (!CollectionUtils.isEmpty(businessPolicyDtoList)) {
                this.businessPolicyService.updateBusinessPolicyByAuditPass(businessPolicyDtoList);
            }
        }
    }

    public List<GeneralExpensesVo> findByExpensesCode(List<String> expensesCodeList) {
        return this.generalExpensesRepository.findByExpensesCodeExt(expensesCodeList);
    }

    public Page<GeneralExpensesVo> findForWithholding(Pageable pageable, String processStatus, String upAccountStatus) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.generalExpensesRepository.findForWithholding((Page<GeneralExpensesVo>)page, processStatus, upAccountStatus);
    }

    public Integer getTotal(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        return this.redisService.lSize(redisCacheKey).intValue();
    }

    public void addListCache(String cacheKey, List<GeneralExpensesDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList();
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        HashSet ids = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            List original = objects;
            original.forEach(e -> {
                GeneralExpensesDto sameDto = saveList.stream().filter(save -> save.getId().equals(e.getId())).findFirst().orElse(null);
                if (sameDto != null) {
                    if (Boolean.TRUE.equals(e.getBeGenerate())) {
                        ids.add(e.getId());
                    }
                } else {
                    newList.add(e);
                }
            });
        }
        saveList.forEach(e -> {
            if (ids.contains(e.getId())) {
                e.setBeGenerate(Boolean.TRUE);
            }
        });
        newList.addAll(saveList);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public BigDecimal getContractAmount(String promotionPlanCode) {
        return this.generalExpensesRepository.getContractAmount(promotionPlanCode);
    }

    public List<GeneralExpensesVo> findByBusinessPolicyCode(List<String> businessPolicyCodeList) {
        return this.generalExpensesRepository.findByBusinessPolicyCode(businessPolicyCodeList);
    }

    public boolean isOtherDetailWholeAudit(String businessPolicyCode, List<String> expensesCodes) {
        if (StringUtils.isEmpty((CharSequence)businessPolicyCode)) {
            return false;
        }
        return this.generalExpensesRepository.isOtherDetailWholeAudit2(businessPolicyCode, expensesCodes);
    }

    private String getRedisCacheKey(String cacheKey) {
        return "general_expenses_cache:page:" + cacheKey;
    }
}

