/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.tpm.business.promotion.plan.local.repository.OtherExpensesRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.OtherExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.OtherExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.OtherExpensesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="otherExpensesService")
public class OtherExpensesServiceImpl
implements OtherExpensesService {
    @Autowired(required=false)
    private OtherExpensesRepository otherExpensesRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private BudgetProfitLossService budgetProfitLossService;

    public Page<OtherExpensesVo> findByConditions(Pageable pageable, OtherExpensesDto otherExpenses) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(otherExpenses)) {
            otherExpenses = new OtherExpensesDto();
        }
        return this.otherExpensesRepository.findByConditions(pageable, otherExpenses);
    }

    public Page<OtherExpensesVo> findCachePageList(Pageable pageable, String cacheKey, String promotionPlanCode) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheKey);
            page.setTotal(total.longValue());
            List objects = this.redisService.lRange(redisCacheKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty((Collection)objects)) {
                List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)objects, OtherExpensesDto.class, OtherExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
                page.setRecords(voList);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)promotionPlanCode)) {
            List<OtherExpensesDto> dtoList = this.otherExpensesRepository.findByPlanCode(promotionPlanCode);
            if (!CollectionUtils.isEmpty(dtoList)) {
                this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), dtoList.toArray());
            }
            page.setTotal((long)dtoList.size());
            long start = page.offset();
            if (page.getTotal() > start) {
                long end = page.offset() + page.getSize();
                if (page.getTotal() < end) {
                    end = page.getTotal();
                }
                List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(dtoList.subList((int)page.offset(), (int)end), OtherExpensesDto.class, OtherExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
                page.setRecords(voList);
            }
        }
        return page;
    }

    public List<OtherExpensesDto> findCacheList(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        if (!this.redisService.hasKey(redisCacheKey).booleanValue()) {
            return Lists.newArrayList();
        }
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        return objects;
    }

    public void addItemCache(String cacheKey, String businessModelCode, String customerCode, String yearMonthLy, List<OtherExpensesDto> saveList) {
        List objects;
        Map<Object, Object> saveItemMap;
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(saveList)) {
            if (saveList.size() > 1) {
                throw new RuntimeException("\u5176\u4ed6\u8d39\u7528\u5f55\u5165\u53ea\u80fd\u6709\u4e00\u6761\u8bb0\u5f55\uff01");
            }
            saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        } else {
            saveItemMap = Maps.newHashMap();
        }
        BudgetProfitLossVo dto = new BudgetProfitLossVo();
        if ("distribution_mode".equals(businessModelCode)) {
            dto.setDepartmentCode("2006279");
        } else {
            dto.setCustomerCode(customerCode);
        }
        dto.setType("\u8d26\u9762");
        List profitLoss = this.budgetProfitLossService.findProfitLoss(dto, Arrays.asList(yearMonthLy));
        BigDecimal sum = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)profitLoss)) {
            sum = profitLoss.stream().map(e -> this.bdNull(e.getTransportHandling()).add(this.bdNull(e.getSaleFeeInventory()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (!CollectionUtils.isEmpty((Collection)(objects = this.redisService.lRange(redisCacheKey, 0L, -1L)))) {
            for (Object object : objects) {
                OtherExpensesDto item = (OtherExpensesDto)object;
                newList.add(saveItemMap.getOrDefault(item.getId(), item));
            }
        }
        OtherExpensesDto newItem = new OtherExpensesDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setLogisticsAmountPlan(sum);
        newItem.setLogisticsAmountBudget(sum);
        newList.add(0, newItem);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void copyItemListCache(String cacheKey, List<OtherExpensesDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        ArrayList copyList = Lists.newArrayList();
        for (Object object : objects) {
            OtherExpensesDto item = (OtherExpensesDto)object;
            if (saveItemMap.containsKey(item.getId())) {
                OtherExpensesDto newItem = (OtherExpensesDto)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) {
                    OtherExpensesDto copyItem = (OtherExpensesDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newItem, OtherExpensesDto.class, HashSet.class, ArrayList.class, new String[0]);
                    copyItem.setId(UUID.randomUUID().toString().replace("-", ""));
                    copyItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    copyItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    copyList.add(copyItem);
                }
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        newList.addAll(0, copyList);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void saveCurrentPageCache(String cacheKey, List<OtherExpensesDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            OtherExpensesDto item = (OtherExpensesDto)object;
            newList.add(saveItemMap.getOrDefault(item.getId(), item));
        }
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void deleteCacheList(String cacheKey, List<OtherExpensesDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Map saveItemMap = itemList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            OtherExpensesDto item = (OtherExpensesDto)object;
            if (saveItemMap.containsKey(item.getId())) {
                OtherExpensesDto newItem = (OtherExpensesDto)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) continue;
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void clearCache(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        this.redisService.del(redisCacheKey);
    }

    public BigDecimal getAdminHumanTotal(String cacheKey, String purchaseCode) {
        BigDecimal amount = BigDecimal.ZERO;
        List<Object> otherExpensesDtos = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            otherExpensesDtos = this.findCacheList(cacheKey);
        } else if (StringUtils.isNotBlank((CharSequence)purchaseCode)) {
            otherExpensesDtos = this.otherExpensesRepository.findByPlanCode(purchaseCode);
        }
        if (!CollectionUtils.isEmpty(otherExpensesDtos)) {
            amount = otherExpensesDtos.stream().map(e -> (e.getAdminAmountPlan() == null ? BigDecimal.ZERO : e.getAdminAmountPlan()).add(e.getHumanAmountPlan() == null ? BigDecimal.ZERO : e.getHumanAmountPlan())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return amount;
    }

    private BigDecimal bdNull(BigDecimal b) {
        return b == null ? BigDecimal.ZERO : b;
    }

    public List<OtherExpensesDto> findList(String code) {
        return this.otherExpensesRepository.findByPlanCode(code);
    }

    private String getRedisCacheKey(String cacheKey) {
        return "other_expenses_cache:page:" + cacheKey;
    }
}

