/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionAllResult;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionAllResultRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanResultRepository;
import com.biz.crm.tpm.business.promotion.plan.local.service.PromotionResultRegister;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionAllResultService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanParamVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="promotionAllResultService")
public class PromotionAllResultServiceImpl
implements PromotionAllResultService {
    private static final Logger log = LoggerFactory.getLogger(PromotionAllResultServiceImpl.class);
    @Autowired(required=false)
    private ActualProfitLossService actualProfitLossService;
    @Autowired(required=false)
    private BudgetProfitLossService budgetProfitLossService;
    @Autowired(required=false)
    private List<PromotionResultRegister> promotionResultRegisters;
    @Autowired(required=false)
    private PromotionPlanResultRepository promotionPlanResultRepository;
    @Autowired(required=false)
    private PromotionAllResultRepository promotionAllResultRepository;

    @Transactional(rollbackFor={Exception.class})
    public void autoGetPromotionAllResult(String date) {
        if (!StringUtils.isEmpty((CharSequence)date)) {
            date = DateUtil.getDate((String)"yyyy-MM");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        String lastMonth = DateUtil.format((Date)cal.getTime(), (String)"yyyy-MM");
        cal.add(2, -1);
        String lastLastMonth = DateUtil.format((Date)cal.getTime(), (String)"yyyy-MM");
        cal.set(2, 1);
        String yearMonthDate = DateUtil.format((Date)cal.getTime(), (String)"yyyy-MM");
        cal.add(1, -1);
        String lastYearMonthDate = DateUtil.format((Date)cal.getTime(), (String)"yyyy-MM");
        String lastYearDate = DateUtil.format((Date)DateUtil.formatAddYear((Date)DateUtil.parseDate((String)date, (String)"yyyy-MM"), (int)-1), (String)"yyyy-MM");
        ActualProfitLossVo dto = new ActualProfitLossVo();
        dto.setType("\u8d26\u9762");
        dto.setBeginDate(lastYearMonthDate);
        dto.setEndDate(date);
        List profitLoss = Optional.ofNullable(this.actualProfitLossService.findProfitLossByDto(dto)).orElse(new ArrayList());
        log.info("\u67e5\u8be2\u635f\u76ca\u8868-\u5b9e\u9645\u7684\u6570\u636e\u91cf\u4e3a:{}", (Object)profitLoss.size());
        HashMap<String, List<ActualProfitLossVo>> actualProfitLossMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)profitLoss)) {
            actualProfitLossMap = profitLoss.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getYearMonthly())).collect(Collectors.groupingBy(ProfitLossVo::getYearMonthly));
        }
        BudgetProfitLossVo budgetDto = new BudgetProfitLossVo();
        budgetDto.setType("\u8d26\u9762");
        budgetDto.setBeginDate(lastYearMonthDate);
        budgetDto.setEndDate(date);
        List profitLossByDto = Optional.ofNullable(this.budgetProfitLossService.findProfitLossByDto(budgetDto)).orElse(new ArrayList());
        log.info("\u67e5\u8be2\u635f\u76ca\u8868-\u9884\u7b97\u7684\u6570\u636e\u91cf\u4e3a:{}", (Object)profitLoss.size());
        HashMap<String, List<BudgetProfitLossVo>> budgetProfitLossMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)profitLossByDto)) {
            budgetProfitLossMap = profitLossByDto.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getYearMonthly())).collect(Collectors.groupingBy(ProfitLossVo::getYearMonthly));
        }
        List paramVoList = Optional.ofNullable(this.promotionPlanResultRepository.getAllByStartDateAndEnd(date, yearMonthDate, "\u8d26\u9762")).orElse(new ArrayList());
        HashMap<String, List<PromotionPlanParamVo>> paramVoMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)paramVoList)) {
            paramVoMap = paramVoList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getProjectCode())).collect(Collectors.groupingBy(vo -> StringUtils.join((Object[])new String[]{vo.getProjectCode(), vo.getStartDate().substring(0, 7)})));
        }
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        ArrayList<PromotionAllResult> promotionAllResultList = new ArrayList<PromotionAllResult>();
        for (PromotionResultRegister promotionResultRegister : this.promotionResultRegisters) {
            String projectCode = promotionResultRegister.planResultCode();
            String projectName = promotionResultRegister.planResultName();
            PromotionAllResult promotionAllResult = promotionResultRegister.buildParam(date, projectCode, actualProfitLossMap, budgetProfitLossMap, paramVoMap, profitLoss, profitLossByDto, yearMonthDate, paramVoList, lastLastMonth, lastMonth, lastYearDate);
            promotionAllResult.setTenantCode(tenantCode);
            promotionAllResult.setDelFlag(delFlag);
            promotionAllResult.setProjectName(projectName);
            promotionAllResultList.add(promotionAllResult);
        }
        this.promotionAllResultRepository.updateBatchById(promotionAllResultList);
    }
}

