/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.promotion.plan.local.repository.CurrentMonthSaleRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.GeneralExpensesRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanCostProgressDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanCostProgressService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressVo;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="promotionPlanCostProgressService")
public class PromotionPlanCostProgressServiceImpl
implements PromotionPlanCostProgressService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanCostProgressServiceImpl.class);
    @Autowired(required=false)
    private GeneralExpensesRepository generalExpensesRepository;
    @Autowired(required=false)
    private CurrentMonthSaleRepository currentMonthSaleRepository;
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private Ce1MnjtSdkService ce1MnjtSdkService;

    public Page<PromotionPlanCostProgressVo> findCostProgressByConditions(Pageable pageable, PromotionPlanCostProgressDto dto) {
        Map customerVoMap;
        Page<PromotionPlanCostProgressVo> page;
        if (StringUtils.isBlank((CharSequence)dto.getYearMonthLy())) {
            dto.setYearMonthLy(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
        }
        if (CollectionUtils.isEmpty((Collection)(page = this.generalExpensesRepository.findCostProgressByConditions(pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50)), dto)).getRecords())) {
            return page;
        }
        List records = page.getRecords();
        HashSet<String> ppCodeSet = new HashSet<String>();
        HashSet<String> detailCodeSet = new HashSet<String>();
        HashSet<String> customerCodeSet = new HashSet<String>();
        for (PromotionPlanCostProgressVo vo : records) {
            ppCodeSet.add(vo.getPromotionPlanCode());
            detailCodeSet.add(vo.getExpensesCode());
            customerCodeSet.add(vo.getCustomerCode());
        }
        HashMap<String, CustomerVo> customerVirtualVoMap = new HashMap<String, CustomerVo>();
        List customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet));
        if (!CollectionUtils.isEmpty((Collection)customerVos)) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            Iterator<String> it = customerVoMap.keySet().iterator();
            while (it.hasNext()) {
                String k2 = it.next();
                CustomerVo customerVo = (CustomerVo)customerVoMap.get(k2);
                if (!BooleanEnum.TRUE.getCapital().equals(customerVo.getIsVirtually())) continue;
                customerVirtualVoMap.put(k2, customerVo);
                it.remove();
            }
        } else {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u610f\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        PageRequest pageableSales = PageRequest.of((int)1, (int)20000);
        String startDate = dto.getYearMonthLy().replace("-", "") + "01";
        String endDate = DateUtil.getFinalDayOfMonth((String)dto.getYearMonthLy()).replace("-", "");
        HashMap virtualStrMap = new HashMap();
        HashMap salesAmountMap = new HashMap();
        if (!customerVirtualVoMap.isEmpty()) {
            HashSet dtoStrSet = new HashSet();
            customerVirtualVoMap.forEach((k, v) -> {
                String str = v.getBusinessFormatCode() + v.getSalesInstitutionErpCode() + v.getCustomerChannelCode();
                dtoStrSet.add(str);
                virtualStrMap.put(k, str);
            });
            Ce1MnjtFullDto ce1MnjtFullDto = new Ce1MnjtFullDto();
            ce1MnjtFullDto.setCustomerVirtualCodeList(new ArrayList(dtoStrSet));
            ce1MnjtFullDto.setPostDateStart(startDate);
            ce1MnjtFullDto.setPostDateEnd(endDate);
            Page salesVoPage = this.ce1MnjtSdkService.findSalesByConditions((Pageable)pageableSales, ce1MnjtFullDto);
            if (!CollectionUtils.isEmpty((Collection)salesVoPage.getRecords())) {
                List salesVoList = salesVoPage.getRecords();
                Map stringListMap = salesVoList.stream().collect(Collectors.groupingBy(e -> e.getProductTeamCode() + e.getSaleOrgCode() + e.getDistributionChannelCode(), Collectors.mapping(e -> e.getSalesTaxAmount(), Collectors.toList())));
                stringListMap.forEach((k, v) -> salesAmountMap.put(k, v.stream().map(e -> new BigDecimal((String)e)).reduce(BigDecimal.ZERO, BigDecimal::add)));
            }
        }
        HashMap strMap = new HashMap();
        if (!customerVoMap.isEmpty()) {
            HashSet dtoStrSet = new HashSet();
            customerVoMap.forEach((k, v) -> {
                String str = v.getBusinessFormatCode() + v.getSalesInstitutionErpCode() + v.getCustomerChannelCode() + v.getErpCode();
                dtoStrSet.add(str);
                strMap.put(k, str);
            });
            Ce1MnjtFullDto ce1MnjtFullDto = new Ce1MnjtFullDto();
            ce1MnjtFullDto.setCustomerUniqueCodeList(new ArrayList(dtoStrSet));
            ce1MnjtFullDto.setPostDateStart(startDate);
            ce1MnjtFullDto.setPostDateEnd(endDate);
            Page salesVoPage = this.ce1MnjtSdkService.findSalesByConditions((Pageable)pageableSales, ce1MnjtFullDto);
            if (!CollectionUtils.isEmpty((Collection)salesVoPage.getRecords())) {
                List salesVoList = salesVoPage.getRecords();
                Map stringListMap = salesVoList.stream().collect(Collectors.groupingBy(e -> e.getProductTeamCode() + e.getSaleOrgCode() + e.getDistributionChannelCode() + e.getCustomerCode(), Collectors.mapping(e -> e.getSalesTaxAmount(), Collectors.toList())));
                stringListMap.forEach((k, v) -> salesAmountMap.put(k, v.stream().map(e -> new BigDecimal((String)e)).reduce(BigDecimal.ZERO, BigDecimal::add)));
            }
        }
        HashMap<String, BigDecimal> cmsAmountMap = new HashMap<String, BigDecimal>();
        List<CurrentMonthSaleDto> cmsDtoList = this.currentMonthSaleRepository.findByPlanCodeList(new ArrayList<String>(ppCodeSet));
        if (!CollectionUtils.isEmpty(cmsDtoList)) {
            Map<String, List<CurrentMonthSaleDto>> cmsMap = cmsDtoList.stream().collect(Collectors.groupingBy(e -> e.getPromotionPlanCode()));
            for (String k3 : cmsMap.keySet()) {
                List<CurrentMonthSaleDto> currentMonthSaleDtos = cmsMap.get(k3);
                cmsAmountMap.put(k3, currentMonthSaleDtos.stream().map(e -> Optional.ofNullable(e.getEstimatedAmountAfter()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        List dfVoList = this.detailedForecastService.findByActivityDetailItemCode(detailCodeSet);
        Map<Object, Object> dfVoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)dfVoList)) {
            dfVoMap = dfVoList.stream().collect(Collectors.toMap(e -> e.getActivityDetailItemCode(), Function.identity()));
        }
        for (PromotionPlanCostProgressVo item : page.getRecords()) {
            String str;
            BigDecimal monthSaleAmount = BigDecimal.ZERO;
            if (cmsAmountMap.containsKey(item.getPromotionPlanCode())) {
                monthSaleAmount = (BigDecimal)cmsAmountMap.get(item.getPromotionPlanCode());
            }
            item.setMonthSaleAmount(monthSaleAmount);
            if (BigDecimal.ZERO.compareTo(monthSaleAmount) != 0) {
                item.setPlanRate(item.getApplyAmount().divide(monthSaleAmount, 2, 4));
            }
            if (virtualStrMap.containsKey(item.getCustomerCode())) {
                item.setChannelCode(((CustomerVo)customerVirtualVoMap.get(item.getCustomerCode())).getCustomerChannelCode());
                str = (String)virtualStrMap.get(item.getCustomerCode());
                if (salesAmountMap.containsKey(str)) {
                    item.setActualSaleAmount((BigDecimal)salesAmountMap.get(str));
                }
            } else if (strMap.containsKey(item.getCustomerCode())) {
                item.setChannelCode(((CustomerVo)customerVoMap.get(item.getCustomerCode())).getCustomerChannelCode());
                str = (String)strMap.get(item.getCustomerCode());
                if (salesAmountMap.containsKey(str)) {
                    item.setActualSaleAmount((BigDecimal)salesAmountMap.get(str));
                }
            }
            if (dfVoMap.containsKey(item.getExpensesCode())) {
                BigDecimal actualCost = ((DetailedForecastVo)dfVoMap.get(item.getExpensesCode())).getEstimatedWriteOffAmount();
                item.setActualCost(actualCost != null ? actualCost : BigDecimal.ZERO);
                item.setCostProgress(item.getActualCost().divide(item.getApplyAmount(), 2, 4));
            }
            if (item.getActualSaleAmount() == null) continue;
            if (item.getActualSaleAmount().compareTo(BigDecimal.ZERO) != 0) {
                item.setActualRate(item.getActualCost().divide(item.getActualSaleAmount(), 2, 4));
            }
            if (item.getMonthSaleAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            item.setSaleAmountProgress(item.getActualSaleAmount().divide(item.getMonthSaleAmount(), 2, 4));
        }
        return page;
    }
}

